/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.variables;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.Release;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.exceptions.NoSuchVariableException;
import org.apache.wiki.api.filters.PageFilter;
import org.apache.wiki.api.providers.AttachmentProvider;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.filters.FilterManager;
import org.apache.wiki.modules.InternalModule;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.variables.VariableManager;

public class DefaultVariableManager
implements VariableManager {
    private static final Logger log = LogManager.getLogger(DefaultVariableManager.class);
    static final String[] THE_BIG_NO_NO_LIST = new String[]{"jspwiki.auth.masterpassword"};

    public DefaultVariableManager(Properties props) {
    }

    @Override
    public String parseAndGetValue(Context context, String link) throws IllegalArgumentException, NoSuchVariableException {
        if (!link.startsWith("{$")) {
            throw new IllegalArgumentException("Link does not start with {$");
        }
        if (!link.endsWith("}")) {
            throw new IllegalArgumentException("Link does not end with }");
        }
        String varName = link.substring(2, link.length() - 1);
        return this.getValue(context, varName.trim());
    }

    @Override
    public String expandVariables(Context context, String source) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) == '{') {
                if (i < source.length() - 2 && source.charAt(i + 1) == '$') {
                    String value;
                    int end = source.indexOf(125, i);
                    if (end == -1) continue;
                    String varname = source.substring(i + 2, end);
                    try {
                        value = this.getValue(context, varname);
                    }
                    catch (IllegalArgumentException | NoSuchVariableException e) {
                        value = e.getMessage();
                    }
                    result.append(value);
                    i = end;
                    continue;
                }
                result.append('{');
                continue;
            }
            result.append(source.charAt(i));
        }
        return result.toString();
    }

    @Override
    public String getValue(Context context, String varName, String defValue) {
        try {
            return this.getValue(context, varName);
        }
        catch (NoSuchVariableException e) {
            return defValue;
        }
    }

    @Override
    public String getVariable(Context context, String name) {
        return this.getValue(context, name, null);
    }

    @Override
    public String getValue(Context context, String varName) throws IllegalArgumentException, NoSuchVariableException {
        if (varName == null) {
            throw new IllegalArgumentException("Null variable name.");
        }
        if (varName.isEmpty()) {
            throw new IllegalArgumentException("Zero length variable name.");
        }
        String name = varName.toLowerCase();
        for (String value : THE_BIG_NO_NO_LIST) {
            if (!name.equals(value)) continue;
            return "";
        }
        try {
            SystemVariables sysvars = new SystemVariables(context);
            String methodName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            Method method = sysvars.getClass().getMethod(methodName, new Class[0]);
            return (String)method.invoke((Object)sysvars, new Object[0]);
        }
        catch (NoSuchMethodException e1) {
            Properties props;
            String s;
            Object metadata;
            Object metadata2;
            Page pg;
            if (context.getVariable(varName) != null) {
                return context.getVariable(varName).toString();
            }
            HttpServletRequest req = context.getHttpRequest();
            if (req != null && req.getSession() != null) {
                HttpSession session = req.getSession();
                try {
                    String s2 = (String)session.getAttribute(varName);
                    if (s2 != null) {
                        return s2;
                    }
                    s2 = context.getHttpParameter(varName);
                    if (s2 != null) {
                        return s2;
                    }
                }
                catch (ClassCastException e) {
                    log.debug("Not a String: " + varName);
                }
            }
            if ((pg = context.getPage()) != null && (metadata2 = pg.getAttribute(varName)) != null) {
                return metadata2.toString();
            }
            Page rpg = context.getRealPage();
            if (rpg != null && (metadata = rpg.getAttribute(varName)) != null) {
                return metadata.toString();
            }
            if (varName.startsWith("jspwiki.") && (s = (props = context.getEngine().getWikiProperties()).getProperty(varName)) != null) {
                return s;
            }
            if (varName.equals("error") || varName.equals("msg")) {
                return "";
            }
            throw new NoSuchVariableException("No variable " + varName + " defined.");
        }
        catch (Exception e) {
            log.info("Interesting exception: cannot fetch variable value", (Throwable)e);
            return "";
        }
    }

    private static class SystemVariables {
        private final Context m_context;

        public SystemVariables(Context context) {
            this.m_context = context;
        }

        public String getPagename() {
            return this.m_context.getPage().getName();
        }

        public String getApplicationname() {
            return this.m_context.getEngine().getApplicationName();
        }

        public String getJspwikiversion() {
            return Release.getVersionString();
        }

        public String getEncoding() {
            return this.m_context.getEngine().getContentEncoding().displayName();
        }

        public String getTotalpages() {
            return Integer.toString(((PageManager)this.m_context.getEngine().getManager(PageManager.class)).getTotalPageCount());
        }

        public String getPageprovider() {
            return ((PageManager)this.m_context.getEngine().getManager(PageManager.class)).getCurrentProvider();
        }

        public String getPageproviderdescription() {
            return ((PageManager)this.m_context.getEngine().getManager(PageManager.class)).getProviderDescription();
        }

        public String getAttachmentprovider() {
            AttachmentProvider p = ((AttachmentManager)this.m_context.getEngine().getManager(AttachmentManager.class)).getCurrentProvider();
            return p != null ? p.getClass().getName() : "-";
        }

        public String getAttachmentproviderdescription() {
            AttachmentProvider p = ((AttachmentManager)this.m_context.getEngine().getManager(AttachmentManager.class)).getCurrentProvider();
            return p != null ? p.getProviderInfo() : "-";
        }

        public String getInterwikilinks() {
            StringBuilder res = new StringBuilder();
            for (String link : this.m_context.getEngine().getAllInterWikiLinks()) {
                if (res.length() > 0) {
                    res.append(", ");
                }
                res.append(link);
                res.append(" --> ");
                res.append(this.m_context.getEngine().getInterWikiURL(link));
            }
            return res.toString();
        }

        public String getInlinedimages() {
            StringBuilder res = new StringBuilder();
            for (String ptrn : this.m_context.getEngine().getAllInlinedImagePatterns()) {
                if (res.length() > 0) {
                    res.append(", ");
                }
                res.append(ptrn);
            }
            return res.toString();
        }

        public String getPluginpath() {
            String s = this.m_context.getEngine().getPluginSearchPath();
            return s == null ? "-" : s;
        }

        public String getBaseurl() {
            return this.m_context.getEngine().getBaseURL();
        }

        public String getUptime() {
            Date now = new Date();
            long secondsRunning = (now.getTime() - this.m_context.getEngine().getStartTime().getTime()) / 1000L;
            long seconds = secondsRunning % 60L;
            long minutes = (secondsRunning /= 60L) % 60L;
            long hours = (secondsRunning /= 60L) % 24L;
            long days = secondsRunning /= 24L;
            return days + "d, " + hours + "h " + minutes + "m " + seconds + "s";
        }

        public String getLoginstatus() {
            Session session = this.m_context.getWikiSession();
            return Preferences.getBundle(this.m_context, "CoreResources").getString("varmgr." + session.getStatus());
        }

        public String getUsername() {
            Principal wup = this.m_context.getCurrentUser();
            ResourceBundle rb = Preferences.getBundle(this.m_context, "CoreResources");
            return wup != null ? wup.getName() : rb.getString("varmgr.not.logged.in");
        }

        public String getRequestcontext() {
            return this.m_context.getRequestContext();
        }

        public String getPagefilters() {
            FilterManager fm = (FilterManager)this.m_context.getEngine().getManager(FilterManager.class);
            List<PageFilter> filters = fm.getFilterList();
            StringBuilder sb = new StringBuilder();
            for (PageFilter pf : filters) {
                String f = pf.getClass().getName();
                if (pf instanceof InternalModule) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(f);
            }
            return sb.toString();
        }
    }
}

