/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.render;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.StringTransmutator;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.FilterException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.cache.CachingManager;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.filters.FilterManager;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.parser.JSPWikiMarkupParser;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.references.ReferenceManager;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.render.WikiRenderer;
import org.apache.wiki.render.WysiwygEditingRenderer;
import org.apache.wiki.render.XHTMLRenderer;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.variables.VariableManager;

public class DefaultRenderingManager
implements RenderingManager {
    private static final Logger LOG = LogManager.getLogger(DefaultRenderingManager.class);
    private static final String VERSION_DELIMITER = "::";
    private static final String DEFAULT_PARSER = JSPWikiMarkupParser.class.getName();
    private static final String DEFAULT_RENDERER = XHTMLRenderer.class.getName();
    private static final String DEFAULT_WYSIWYG_RENDERER = WysiwygEditingRenderer.class.getName();
    private Engine m_engine;
    private CachingManager cachingManager;
    private boolean m_beautifyTitle;
    private Constructor<?> m_rendererConstructor;
    private Constructor<?> m_rendererWysiwygConstructor;
    private String m_markupParserClass = DEFAULT_PARSER;

    public void initialize(Engine engine, Properties properties) throws WikiException {
        this.m_engine = engine;
        this.cachingManager = (CachingManager)this.m_engine.getManager(CachingManager.class);
        this.m_markupParserClass = properties.getProperty("jspwiki.renderingManager.markupParser", DEFAULT_PARSER);
        if (!ClassUtil.assignable((String)this.m_markupParserClass, (String)MarkupParser.class.getName())) {
            LOG.warn("{} does not subclass {} reverting to default markup parser.", (Object)this.m_markupParserClass, (Object)MarkupParser.class.getName());
            this.m_markupParserClass = DEFAULT_PARSER;
        }
        LOG.info("Using {} as markup parser.", (Object)this.m_markupParserClass);
        this.m_beautifyTitle = TextUtil.getBooleanProperty((Properties)properties, (String)"jspwiki.breakTitleWithSpaces", (boolean)this.m_beautifyTitle);
        String renderImplName = properties.getProperty("jspwiki.renderingManager.renderer", DEFAULT_RENDERER);
        String renderWysiwygImplName = properties.getProperty("jspwiki.renderingManager.renderer.wysiwyg", DEFAULT_WYSIWYG_RENDERER);
        Class[] rendererParams = new Class[]{Context.class, WikiDocument.class};
        this.m_rendererConstructor = this.initRenderer(renderImplName, rendererParams);
        this.m_rendererWysiwygConstructor = this.initRenderer(renderWysiwygImplName, rendererParams);
        LOG.info("Rendering content with {}.", (Object)renderImplName);
        WikiEventManager.addWikiEventListener((Object)this.m_engine.getManager(FilterManager.class), (WikiEventListener)this);
    }

    private Constructor<?> initRenderer(String renderImplName, Class<?>[] rendererParams) throws WikiException {
        Constructor<?> c = null;
        try {
            Class<?> clazz = Class.forName(renderImplName);
            c = clazz.getConstructor(rendererParams);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to find WikiRenderer implementation {}", (Object)renderImplName);
        }
        catch (SecurityException e) {
            LOG.error("Unable to access the WikiRenderer(WikiContext,WikiDocument) constructor for {}", (Object)renderImplName);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Unable to locate the WikiRenderer(WikiContext,WikiDocument) constructor for {}", (Object)renderImplName);
        }
        if (c == null) {
            throw new WikiException("Failed to get WikiRenderer '" + renderImplName + "'.");
        }
        return c;
    }

    @Override
    public String beautifyTitle(String title) {
        if (this.m_beautifyTitle) {
            try {
                Attachment att = ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).getAttachmentInfo(title);
                if (att == null) {
                    return TextUtil.beautifyString((String)title);
                }
                String parent = TextUtil.beautifyString((String)att.getParentName());
                return parent + "/" + att.getFileName();
            }
            catch (ProviderException e) {
                return title;
            }
        }
        return title;
    }

    @Override
    public String beautifyTitleNoBreak(String title) {
        if (this.m_beautifyTitle) {
            return TextUtil.beautifyString((String)title, (String)"&nbsp;");
        }
        return title;
    }

    @Override
    public MarkupParser getParser(Context context, String pagedata) {
        try {
            return (MarkupParser)ClassUtil.getMappedObject((String)this.m_markupParserClass, (Object[])new Object[]{context, new StringReader(pagedata)});
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            LOG.error("unable to get an instance of {} ({}), returning default markup parser.", (Object)this.m_markupParserClass, (Object)e.getMessage(), (Object)e);
            return new JSPWikiMarkupParser(context, new StringReader(pagedata));
        }
    }

    @Override
    public WikiDocument getRenderedDocument(Context context, String pagedata) {
        String pageid = context.getRealPage().getName() + VERSION_DELIMITER + context.getRealPage().getVersion() + VERSION_DELIMITER + context.getVariable("_PluginContent.execute");
        if (this.useCache(context)) {
            WikiDocument doc = (WikiDocument)((Object)this.cachingManager.get("jspwiki.renderingCache", (Serializable)((Object)pageid), () -> null));
            if (doc != null) {
                if (pagedata.equals(doc.getPageData())) {
                    LOG.debug("Using cached HTML for page {}", (Object)pageid);
                    return doc;
                }
            } else {
                LOG.debug("Re-rendering and storing {}", (Object)pageid);
            }
        }
        try {
            MarkupParser parser = this.getParser(context, pagedata);
            WikiDocument doc = parser.parse();
            doc.setPageData(pagedata);
            if (this.useCache(context)) {
                this.cachingManager.put("jspwiki.renderingCache", (Serializable)((Object)pageid), (Object)doc);
            }
            return doc;
        }
        catch (IOException ex) {
            LOG.error("Unable to parse", (Throwable)ex);
            return null;
        }
    }

    boolean useCache(Context context) {
        return this.cachingManager.enabled("jspwiki.renderingCache") && ContextEnum.PAGE_VIEW.getRequestContext().equals(context.getRequestContext());
    }

    @Override
    public String getHTML(Context context, WikiDocument doc) throws IOException {
        Boolean wysiwygVariable = (Boolean)context.getVariable("WYSIWYG_EDITOR_MODE");
        boolean wysiwygEditorMode = wysiwygVariable != null ? wysiwygVariable : false;
        WikiRenderer rend = wysiwygEditorMode ? this.getWysiwygRenderer(context, doc) : this.getRenderer(context, doc);
        return rend.getString();
    }

    @Override
    public String getHTML(Context context, Page page) {
        String pagedata = ((PageManager)this.m_engine.getManager(PageManager.class)).getPureText(page.getName(), page.getVersion());
        return this.textToHTML(context, pagedata);
    }

    @Override
    public String getHTML(String pagename, int version) {
        Page page = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pagename, version);
        Context context = Wiki.context().create(this.m_engine, page);
        context.setRequestContext(ContextEnum.PAGE_NONE.getRequestContext());
        return this.getHTML(context, page);
    }

    public String textToHTML(Context context, String pagedata) {
        String result = "";
        boolean runFilters = "true".equals(((VariableManager)this.m_engine.getManager(VariableManager.class)).getValue(context, "jspwiki.runFilters", "true"));
        StopWatch sw = new StopWatch();
        sw.start();
        try {
            if (runFilters) {
                pagedata = ((FilterManager)this.m_engine.getManager(FilterManager.class)).doPreTranslateFiltering(context, pagedata);
            }
            result = this.getHTML(context, pagedata);
            if (runFilters) {
                result = ((FilterManager)this.m_engine.getManager(FilterManager.class)).doPostTranslateFiltering(context, result);
            }
        }
        catch (FilterException e) {
            LOG.error("page filter threw exception: ", (Throwable)e);
        }
        sw.stop();
        LOG.debug("Page {} rendered, took {}", (Object)context.getRealPage().getName(), (Object)sw);
        return result;
    }

    @Override
    public String textToHTML(Context context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook, StringTransmutator attLinkHook, boolean parseAccessRules, boolean justParse) {
        String result = "";
        if (pagedata == null) {
            LOG.error("NULL pagedata to textToHTML()");
            return null;
        }
        boolean runFilters = "true".equals(((VariableManager)this.m_engine.getManager(VariableManager.class)).getValue(context, "jspwiki.runFilters", "true"));
        try {
            StopWatch sw = new StopWatch();
            sw.start();
            if (runFilters && this.m_engine.getManager(FilterManager.class) != null) {
                pagedata = ((FilterManager)this.m_engine.getManager(FilterManager.class)).doPreTranslateFiltering(context, pagedata);
            }
            MarkupParser mp = this.getParser(context, pagedata);
            mp.addLocalLinkHook(localLinkHook);
            mp.addExternalLinkHook(extLinkHook);
            mp.addAttachmentLinkHook(attLinkHook);
            if (!parseAccessRules) {
                mp.disableAccessRules();
            }
            WikiDocument doc = mp.parse();
            if (!justParse) {
                result = this.getHTML(context, doc);
                if (runFilters && this.m_engine.getManager(FilterManager.class) != null) {
                    result = ((FilterManager)this.m_engine.getManager(FilterManager.class)).doPostTranslateFiltering(context, result);
                }
            }
            sw.stop();
            LOG.debug("Page {} rendered, took {}", (Object)context.getRealPage().getName(), (Object)sw);
        }
        catch (IOException e) {
            LOG.error("Failed to scan page data: ", (Throwable)e);
        }
        catch (FilterException e) {
            LOG.error("page filter threw exception: ", (Throwable)e);
        }
        return result;
    }

    @Override
    public WikiRenderer getRenderer(Context context, WikiDocument doc) {
        Object[] params = new Object[]{context, doc};
        return this.getRenderer(params, this.m_rendererConstructor);
    }

    @Override
    public WikiRenderer getWysiwygRenderer(Context context, WikiDocument doc) {
        Object[] params = new Object[]{context, doc};
        return this.getRenderer(params, this.m_rendererWysiwygConstructor);
    }

    private <T extends WikiRenderer> T getRenderer(Object[] params, Constructor<?> rendererConstructor) {
        try {
            return (T)((WikiRenderer)rendererConstructor.newInstance(params));
        }
        catch (Exception e) {
            LOG.error("Unable to create WikiRenderer", (Throwable)e);
            return null;
        }
    }

    public void actionPerformed(WikiEvent event) {
        LOG.debug("event received: {}", (Object)event.toString());
        if (this.isBeginningAWikiPagePostSaveEventAndDocumentCacheIsEnabled(event)) {
            String pageName = ((WikiPageEvent)event).getPageName();
            this.cachingManager.remove("jspwiki.renderingCache", (Serializable)((Object)pageName));
            Set<String> referringPages = ((ReferenceManager)this.m_engine.getManager(ReferenceManager.class)).findReferrers(pageName);
            if (referringPages != null) {
                for (String page : referringPages) {
                    LOG.debug("Flushing latest version of {}", (Object)page);
                    this.cachingManager.remove("jspwiki.renderingCache", (Serializable)((Object)(page + VERSION_DELIMITER + -1 + VERSION_DELIMITER + Boolean.FALSE)));
                    this.cachingManager.remove("jspwiki.renderingCache", (Serializable)((Object)(page + VERSION_DELIMITER + -1 + VERSION_DELIMITER + Boolean.TRUE)));
                    this.cachingManager.remove("jspwiki.renderingCache", (Serializable)((Object)(page + VERSION_DELIMITER + -1 + VERSION_DELIMITER + null)));
                }
            }
        }
    }

    boolean isBeginningAWikiPagePostSaveEventAndDocumentCacheIsEnabled(WikiEvent event) {
        return event instanceof WikiPageEvent && event.getType() == 21 && this.cachingManager.enabled("jspwiki.renderingCache");
    }
}

