/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.permissions;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Arrays;
import org.apache.wiki.auth.permissions.AllPermissionCollection;
import org.apache.wiki.auth.permissions.PagePermission;

public final class WikiPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CREATE_GROUPS_ACTION = "createGroups";
    public static final String CREATE_PAGES_ACTION = "createPages";
    public static final String LOGIN_ACTION = "login";
    public static final String EDIT_PREFERENCES_ACTION = "editPreferences";
    public static final String EDIT_PROFILE_ACTION = "editProfile";
    public static final String WILDCARD = "*";
    static final int CREATE_GROUPS_MASK = 1;
    static final int CREATE_PAGES_MASK = 2;
    static final int EDIT_PREFERENCES_MASK = 4;
    static final int EDIT_PROFILE_MASK = 8;
    static final int LOGIN_MASK = 16;
    public static final WikiPermission CREATE_GROUPS = new WikiPermission("*", "createGroups");
    public static final WikiPermission CREATE_PAGES = new WikiPermission("*", "createPages");
    public static final WikiPermission LOGIN = new WikiPermission("*", "login");
    public static final WikiPermission EDIT_PREFERENCES = new WikiPermission("*", "editPreferences");
    public static final WikiPermission EDIT_PROFILE = new WikiPermission("*", "editProfile");
    private final String m_actionString;
    private final String m_wiki;
    private final int m_mask;

    public WikiPermission(String wiki, String actions) {
        super(wiki);
        String[] pageActions = actions.toLowerCase().split(",");
        Arrays.sort(pageActions, String.CASE_INSENSITIVE_ORDER);
        this.m_mask = WikiPermission.createMask(actions);
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < pageActions.length; ++i) {
            buffer.append(pageActions[i]);
            if (i >= pageActions.length - 1) continue;
            buffer.append(",");
        }
        this.m_actionString = buffer.toString();
        this.m_wiki = wiki == null ? WILDCARD : wiki;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WikiPermission)) {
            return false;
        }
        WikiPermission p = (WikiPermission)obj;
        return p.m_mask == this.m_mask && p.m_wiki != null && p.m_wiki.equals(this.m_wiki);
    }

    @Override
    public String getActions() {
        return this.m_actionString;
    }

    public String getWiki() {
        return this.m_wiki;
    }

    @Override
    public int hashCode() {
        return this.m_mask + 13 * this.m_actionString.hashCode() * 23 * this.m_wiki.hashCode();
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof WikiPermission)) {
            return false;
        }
        WikiPermission p = (WikiPermission)permission;
        boolean impliedWiki = PagePermission.isSubset(this.m_wiki, p.m_wiki);
        int impliedMask = WikiPermission.impliedMask(this.m_mask);
        return impliedWiki && (impliedMask & p.m_mask) == p.m_mask;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new AllPermissionCollection();
    }

    @Override
    public String toString() {
        return "(\"" + this.getClass().getName() + "\",\"" + this.m_wiki + "\",\"" + this.getActions() + "\")";
    }

    static int impliedMask(int mask) {
        if ((mask & 1) > 0) {
            mask |= 2;
        }
        return mask;
    }

    static int createMask(String actions) {
        if (actions == null || actions.isEmpty()) {
            throw new IllegalArgumentException("Actions cannot be blank or null");
        }
        int mask = 0;
        String[] actionList = actions.split(",");
        for (int i = 0; i < actionList.length; ++i) {
            String action = actionList[i];
            if (action.equalsIgnoreCase(CREATE_GROUPS_ACTION)) {
                mask |= 1;
                continue;
            }
            if (action.equalsIgnoreCase(CREATE_PAGES_ACTION)) {
                mask |= 2;
                continue;
            }
            if (action.equalsIgnoreCase(LOGIN_ACTION)) {
                mask |= 0x10;
                continue;
            }
            if (action.equalsIgnoreCase(EDIT_PREFERENCES_ACTION)) {
                mask |= 4;
                continue;
            }
            if (action.equalsIgnoreCase(EDIT_PROFILE_ACTION)) {
                mask |= 8;
                continue;
            }
            throw new IllegalArgumentException("Unrecognized action: " + action);
        }
        return mask;
    }
}

