/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.xmlrpc;

import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.apache.wiki.LinkCollector;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.xmlrpc.AbstractRPCHandler;
import org.apache.xmlrpc.XmlRpcException;

public class RPCHandler
extends AbstractRPCHandler {
    private String toRPCString(String src) {
        return TextUtil.urlEncodeUTF8((String)src);
    }

    private String fromRPCString(String src) {
        return TextUtil.urlDecodeUTF8((String)src);
    }

    private byte[] toRPCBase64(String src) {
        return src.getBytes(StandardCharsets.UTF_8);
    }

    public String getApplicationName() {
        this.checkPermission(PagePermission.VIEW);
        return this.toRPCString(this.m_engine.getApplicationName());
    }

    public Vector<String> getAllPages() {
        this.checkPermission(PagePermission.VIEW);
        Set<Page> pages = ((PageManager)this.m_engine.getManager(PageManager.class)).getRecentChanges();
        Vector<String> result = new Vector<String>();
        for (Page p : pages) {
            if (p instanceof Attachment) continue;
            result.add(this.toRPCString(p.getName()));
        }
        return result;
    }

    @Override
    protected Hashtable<String, Object> encodeWikiPage(Page page) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("name", this.toRPCString(page.getName()));
        Date d = page.getLastModified();
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(14, -(cal.get(15) + (cal.getTimeZone().inDaylightTime(d) ? cal.get(16) : 0)));
        ht.put("lastModified", cal.getTime());
        ht.put("version", page.getVersion());
        if (page.getAuthor() != null) {
            ht.put("author", this.toRPCString(page.getAuthor()));
        }
        return ht;
    }

    @Override
    public Vector<Hashtable<String, Object>> getRecentChanges(Date since) {
        this.checkPermission(PagePermission.VIEW);
        Set<Page> pages = ((PageManager)this.m_engine.getManager(PageManager.class)).getRecentChanges();
        Vector<Hashtable<String, Object>> result = new Vector<Hashtable<String, Object>>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(since);
        cal.add(14, cal.get(15) + (cal.getTimeZone().inDaylightTime(since) ? cal.get(16) : 0));
        since = cal.getTime();
        for (Page page : pages) {
            if (!page.getLastModified().after(since) || page instanceof Attachment) continue;
            result.add(this.encodeWikiPage(page));
        }
        return result;
    }

    private String parsePageCheckCondition(String pagename) throws XmlRpcException {
        pagename = this.fromRPCString(pagename);
        if (!((PageManager)this.m_engine.getManager(PageManager.class)).wikiPageExists(pagename)) {
            throw new XmlRpcException(1, "No such page '" + pagename + "' found, o master.");
        }
        Page p = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pagename);
        this.checkPermission(PermissionFactory.getPagePermission(p, "view"));
        return pagename;
    }

    public Hashtable getPageInfo(String pagename) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.encodeWikiPage(((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pagename));
    }

    public Hashtable getPageInfoVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.encodeWikiPage(((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pagename, version));
    }

    public byte[] getPage(String pagename) throws XmlRpcException {
        String text = ((PageManager)this.m_engine.getManager(PageManager.class)).getPureText(this.parsePageCheckCondition(pagename), -1);
        return this.toRPCBase64(text);
    }

    public byte[] getPageVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.toRPCBase64(((PageManager)this.m_engine.getManager(PageManager.class)).getPureText(pagename, version));
    }

    public byte[] getPageHTML(String pagename) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.toRPCBase64(((RenderingManager)this.m_engine.getManager(RenderingManager.class)).getHTML(pagename));
    }

    public byte[] getPageHTMLVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.toRPCBase64(((RenderingManager)this.m_engine.getManager(RenderingManager.class)).getHTML(pagename, version));
    }

    public Vector<Hashtable<String, String>> listLinks(String pagename) throws XmlRpcException {
        Hashtable<String, String> ht;
        pagename = this.parsePageCheckCondition(pagename);
        Page page = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pagename);
        String pagedata = ((PageManager)this.m_engine.getManager(PageManager.class)).getPureText(page);
        LinkCollector localCollector = new LinkCollector();
        LinkCollector extCollector = new LinkCollector();
        LinkCollector attCollector = new LinkCollector();
        Context context = Wiki.context().create(this.m_engine, page);
        ((RenderingManager)this.m_engine.getManager(RenderingManager.class)).textToHTML(context, pagedata, localCollector, extCollector, attCollector);
        Vector<Hashtable<String, String>> result = new Vector<Hashtable<String, String>>();
        for (String link : localCollector.getLinks()) {
            ht = new Hashtable<String, String>();
            ht.put("page", this.toRPCString(link));
            ht.put("type", "local");
            if (((PageManager)this.m_engine.getManager(PageManager.class)).wikiPageExists(link)) {
                ht.put("href", context.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), link));
            } else {
                ht.put("href", context.getURL(ContextEnum.PAGE_EDIT.getRequestContext(), link));
            }
            result.add(ht);
        }
        for (String link : attCollector.getLinks()) {
            ht = new Hashtable();
            ht.put("page", this.toRPCString(link));
            ht.put("type", "local");
            ht.put("href", context.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), link));
            result.add(ht);
        }
        for (String link : extCollector.getLinks()) {
            ht = new Hashtable();
            ht.put("page", link);
            ht.put("type", "external");
            ht.put("href", link);
            result.add(ht);
        }
        return result;
    }
}

