/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rpc.atom;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.plugin.WeblogEntryPlugin;
import org.apache.wiki.rss.Feed;
import org.apache.wiki.util.TextUtil;
import org.intabulas.sandler.Sandler;
import org.intabulas.sandler.SyndicationFactory;
import org.intabulas.sandler.elements.Content;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Link;
import org.intabulas.sandler.elements.Person;
import org.intabulas.sandler.elements.impl.LinkImpl;
import org.intabulas.sandler.exceptions.FeedMarshallException;

public class AtomAPIServlet
extends HttpServlet {
    private static final Logger log = LogManager.getLogger(AtomAPIServlet.class);
    private static final long serialVersionUID = 0L;
    private Engine m_engine;

    public void init(ServletConfig config) throws ServletException {
        this.m_engine = Wiki.engine().find(config);
    }

    private String getPageName(HttpServletRequest request) {
        String name = request.getPathInfo();
        if (name == null || name.length() <= 1) {
            return null;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return TextUtil.urlDecodeUTF8((String)name);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        log.debug("Received POST to AtomAPIServlet");
        try {
            String blogid = this.getPageName(request);
            Page page = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(blogid);
            if (page == null) {
                throw new ServletException("Page " + blogid + " does not exist, cannot add blog post.");
            }
            Entry entry = Sandler.unmarshallEntry((InputStream)request.getInputStream());
            Content title = entry.getTitle();
            Content content = entry.getContent(0);
            Person author = entry.getAuthor();
            WeblogEntryPlugin plugin = new WeblogEntryPlugin();
            String pageName = plugin.getNewEntryPage(this.m_engine, blogid);
            String username = author.getName();
            Page entryPage = Wiki.contents().page(this.m_engine, pageName);
            entryPage.setAuthor(username);
            Context context = Wiki.context().create(this.m_engine, request, entryPage);
            StringBuilder text = new StringBuilder();
            text.append("!").append(title.getBody()).append("\n\n").append(content.getBody());
            log.debug("Writing entry: " + text);
            ((PageManager)this.m_engine.getManager(PageManager.class)).saveText(context, text.toString());
        }
        catch (FeedMarshallException e) {
            log.error("Received faulty Atom entry", (Throwable)e);
            throw new ServletException("Faulty Atom entry", (Throwable)e);
        }
        catch (IOException e) {
            log.error("I/O exception", (Throwable)e);
            throw new ServletException("Could not get body of request", (Throwable)e);
        }
        catch (WikiException e) {
            log.error("Provider exception while posting", (Throwable)e);
            throw new ServletException("JSPWiki cannot save the entry", (Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        log.debug("Received HTTP GET to AtomAPIServlet");
        String blogid = this.getPageName(request);
        log.debug("Requested page " + blogid);
        try {
            if (blogid == null) {
                org.intabulas.sandler.elements.Feed feed = this.listBlogs();
                response.setContentType("application/x.atom+xml; charset=UTF-8");
                response.getWriter().println(Sandler.marshallFeed((org.intabulas.sandler.elements.Feed)feed));
            } else {
                Entry entry = this.getBlogEntry(blogid);
                response.setContentType("application/x.atom+xml; charset=UTF-8");
                response.getWriter().println(Sandler.marshallEntry((Entry)entry));
            }
            response.getWriter().flush();
        }
        catch (Exception e) {
            log.error("Unable to generate response", (Throwable)e);
            throw new ServletException("Internal problem - whack Janne on the head to get a better error report", (Throwable)e);
        }
    }

    private Entry getBlogEntry(String entryid) {
        Page page = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(entryid);
        Page firstVersion = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(entryid, 1);
        Entry entry = SyndicationFactory.newSyndicationEntry();
        String pageText = ((PageManager)this.m_engine.getManager(PageManager.class)).getText(page.getName());
        int firstLine = pageText.indexOf(10);
        String title = "";
        if (firstLine > 0) {
            title = pageText.substring(0, firstLine);
        }
        if (title.trim().isEmpty()) {
            title = page.getName();
        }
        while (title.startsWith("!")) {
            title = title.substring(1);
        }
        entry.setTitle(title);
        entry.setCreated(firstVersion.getLastModified());
        entry.setModified(page.getLastModified());
        entry.setAuthor(SyndicationFactory.createPerson((String)page.getAuthor(), null, null));
        entry.addContent(SyndicationFactory.createEscapedContent((String)pageText));
        return entry;
    }

    private org.intabulas.sandler.elements.Feed listBlogs() throws ProviderException {
        Collection<Page> pages = ((PageManager)this.m_engine.getManager(PageManager.class)).getAllPages();
        org.intabulas.sandler.elements.Feed feed = SyndicationFactory.newSyndicationFeed();
        feed.setTitle("List of blogs at this site");
        feed.setModified(new Date());
        for (Page p : pages) {
            log.debug(p.getName() + " = " + p.getAttribute("weblogplugin.isweblog"));
            if (!"true".equals(p.getAttribute("weblogplugin.isweblog"))) continue;
            String encodedName = TextUtil.urlEncodeUTF8((String)p.getName());
            Context context = Wiki.context().create(this.m_engine, p);
            String title = TextUtil.replaceEntities((String)Feed.getSiteName(context));
            Link postlink = this.createLink("service.post", this.m_engine.getBaseURL() + "atom/" + encodedName, title);
            Link editlink = this.createLink("service.edit", this.m_engine.getBaseURL() + "atom/" + encodedName, title);
            Link feedlink = this.createLink("service.feed", this.m_engine.getBaseURL() + "atom.jsp?page=" + encodedName, title);
            feed.addLink(postlink);
            feed.addLink(feedlink);
            feed.addLink(editlink);
        }
        return feed;
    }

    private Link createLink(String rel, String href, String title) {
        LinkImpl link = new LinkImpl();
        link.setRelationship(rel);
        link.setTitle(title);
        link.setType("application/x.atom+xml");
        link.setHref(href);
        return link;
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) {
        log.debug("Received HTTP DELETE");
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) {
        log.debug("Received HTTP PUT");
    }
}

