/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.plugin.AbstractReferralPlugin;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.references.ReferenceManager;
import org.apache.wiki.util.TextUtil;

public class ReferringPagesPlugin
extends AbstractReferralPlugin {
    private static final Logger log = LogManager.getLogger(ReferringPagesPlugin.class);
    public static final String PARAM_MAX = "max";
    public static final String PARAM_EXTRAS = "extras";
    public static final String PARAM_PAGE = "page";

    public String execute(Context context, Map<String, String> params) throws PluginException {
        Page page;
        ReferenceManager refmgr = (ReferenceManager)context.getEngine().getManager(ReferenceManager.class);
        String pageName = params.get(PARAM_PAGE);
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        StringBuilder result = new StringBuilder(256);
        if (pageName == null) {
            pageName = context.getPage().getName();
        }
        if ((page = ((PageManager)context.getEngine().getManager(PageManager.class)).getPage(pageName)) != null) {
            String wikitext;
            Collection<String> links = refmgr.findReferrers(page.getName());
            super.initialize(context, params);
            int items = TextUtil.parseIntParameter((String)params.get(PARAM_MAX), (int)-1);
            String extras = TextUtil.replaceEntities((String)params.get(PARAM_EXTRAS));
            if (extras == null) {
                extras = rb.getString("referringpagesplugin.more");
            }
            log.debug("Fetching referring pages for {} with a max of {}", (Object)page.getName(), (Object)items);
            if (links != null && links.size() > 0) {
                links = this.filterAndSortCollection(links);
                wikitext = this.wikitizeCollection(links, this.m_separator, items);
                result.append(this.applyColumnsStyle(this.makeHTML(context, wikitext)));
                if (items < links.size() && items > 0) {
                    Object[] args = new Object[]{"" + (links.size() - items)};
                    extras = MessageFormat.format(extras, args);
                    result.append("<br />").append("<a class='morelink' href='").append(context.getURL(ContextEnum.PAGE_INFO.getRequestContext(), page.getName())).append("' ").append(">").append(extras).append("</a><br />");
                }
            }
            if (links == null || links.size() == 0) {
                wikitext = rb.getString("referringpagesplugin.nobody");
                result.append(this.makeHTML(context, wikitext));
            } else if (this.m_show.equals("count")) {
                result = new StringBuilder();
                result.append(links.size());
                if (this.m_lastModified) {
                    result.append(" (").append(this.m_dateFormat.format(this.m_dateLastModified)).append(")");
                }
            }
            return result.toString();
        }
        return "";
    }
}

