/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WhitespaceTrimWriter
extends Writer {
    private final StringBuffer m_result = new StringBuffer();
    private StringBuffer m_buffer = new StringBuffer();
    private boolean m_trimMode = true;
    private static final Pattern ONLINE_PATTERN = Pattern.compile(".*?\\n\\s*?", 8);
    private boolean m_currentlyOnLineBegin = true;

    @Override
    public void flush() {
        if (this.m_buffer.length() > 0) {
            String s = this.m_buffer.toString();
            s = s.replaceAll("\r\n", "\n");
            if (this.m_trimMode) {
                s = s.replaceAll("(\\w+) \\[\\?\\|Edit\\.jsp\\?page=\\1\\]", "[$1]");
                s = s.replaceAll("\n{2,}", "\n\n");
                s = s.replaceAll("\\p{Blank}+", " ");
                s = s.replaceAll("[ ]*\n[ ]*", "\n");
                s = this.replacePluginNewlineBackslashes(s);
            }
            this.m_result.append(s);
            this.m_buffer = new StringBuffer();
        }
    }

    private String replacePluginNewlineBackslashes(String s) {
        Pattern p = Pattern.compile("\\{\\{\\{(.*?)\\}\\}\\}|\\{\\{(.*?)\\}\\}|\\[\\{(.*?)\\}\\]", 40);
        Matcher m = p.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String groupEscaped = m.group().replaceAll("\\\\|\\$", "\\\\$0");
            if (m.group(3) != null) {
                m.appendReplacement(sb, groupEscaped.replaceAll("\\\\\\\\\\\\\\\\", "\n"));
                continue;
            }
            m.appendReplacement(sb, groupEscaped);
        }
        m.appendTail(sb);
        s = sb.toString();
        return s;
    }

    public boolean isWhitespaceTrimMode() {
        return this.m_trimMode;
    }

    public void setWhitespaceTrimMode(boolean trimMode) {
        if (this.m_trimMode != trimMode) {
            this.flush();
            this.m_trimMode = trimMode;
        }
    }

    @Override
    public void write(char[] arg0, int arg1, int arg2) throws IOException {
        this.m_buffer.append(arg0, arg1, arg2);
        this.m_currentlyOnLineBegin = ONLINE_PATTERN.matcher(this.m_buffer).matches();
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        this.flush();
        return this.m_result.toString();
    }

    public boolean isCurrentlyOnLineBegin() {
        return this.m_currentlyOnLineBegin;
    }
}

