/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLoginModule
implements LoginModule {
    private static final Logger log = LogManager.getLogger(AbstractLoginModule.class);
    protected CallbackHandler m_handler;
    protected Map<String, ?> m_options;
    protected Collection<Principal> m_principals;
    protected Map<String, ?> m_state;
    protected Subject m_subject;
    protected static final String NULL = "(null)";

    @Override
    public final boolean abort() {
        this.removePrincipals(this.m_principals);
        this.m_principals.clear();
        return true;
    }

    @Override
    public final boolean commit() {
        if (this.succeeded()) {
            for (Principal principal : this.m_principals) {
                this.m_subject.getPrincipals().add(principal);
                log.debug("Committed Principal {}", (Object)principal.getName());
            }
            return true;
        }
        this.removePrincipals(this.m_principals);
        this.m_principals.clear();
        return false;
    }

    @Override
    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.m_principals = new HashSet<Principal>();
        this.m_subject = subject;
        this.m_handler = callbackHandler;
        this.m_state = sharedState;
        this.m_options = options;
        if (subject == null) {
            throw new IllegalStateException("Subject cannot be null");
        }
        if (callbackHandler == null) {
            throw new IllegalStateException("Callback handler cannot be null");
        }
    }

    @Override
    public abstract boolean login() throws LoginException;

    @Override
    public final boolean logout() {
        this.removePrincipals(this.m_principals);
        this.m_principals.clear();
        return true;
    }

    private boolean succeeded() {
        return this.m_principals.size() > 0;
    }

    private void removePrincipals(Collection<Principal> principals) {
        for (Principal principal : principals) {
            if (!this.m_subject.getPrincipals().contains(principal)) continue;
            this.m_subject.getPrincipals().remove(principal);
            log.debug("Removed Principal {}", (Object)principal.getName());
        }
    }
}

