/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hsqldb.Server;
import org.hsqldb.cmdline.SqlFile;

public class HsqlDbUtils {
    private static final Logger LOG = LogManager.getLogger(HsqlDbUtils.class);
    Server hsqlServer = null;
    int localPort = 0;

    public void setUp() {
        try {
            this.startOnRandomPort();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        this.exec("src/test/config/hsql-userdb-setup.ddl");
    }

    public void tearDown() {
        this.exec("src/test/config/hsql-userdb-teardown.ddl");
        this.shutdown();
    }

    public void start() throws Exception {
        Properties hProps = this.loadPropertiesFrom("target/test-classes/jspwiki-custom.properties");
        this.localPort = Integer.parseInt(hProps.getProperty("server.port"));
        this.startHsqlServer();
    }

    public void startOnRandomPort() throws Exception {
        this.localPort = this.findFreeTcpPort();
        this.startHsqlServer();
    }

    int findFreeTcpPort() throws Exception {
        try (ServerSocket socket = new ServerSocket(0);){
            socket.setReuseAddress(true);
            int n = socket.getLocalPort();
            return n;
        }
    }

    void startHsqlServer() throws Exception {
        Properties hProps = this.loadPropertiesFrom("target/test-classes/jspwiki-custom.properties");
        this.hsqlServer = new Server();
        this.hsqlServer.setSilent(true);
        this.hsqlServer.setLogWriter(null);
        this.hsqlServer.checkRunning(false);
        this.hsqlServer.setPort(this.localPort);
        this.hsqlServer.setDatabaseName(0, hProps.getProperty("server.dbname.0"));
        this.hsqlServer.setDatabasePath(0, hProps.getProperty("server.database.0"));
        this.hsqlServer.start();
        Class.forName("org.hsqldb.jdbc.JDBCDriver");
        this.hsqlServer.checkRunning(true);
    }

    public void exec(String file) {
        try (Connection conn = this.getConnection();){
            SqlFile userDbSetup = new SqlFile(new File(file));
            userDbSetup.setConnection(conn);
            userDbSetup.execute();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
        LOG.info("Shutting down Hypersonic JDBC server on localhost.");
        if (this.hsqlServer != null) {
            try (Connection conn = this.getConnection();){
                conn.setAutoCommit(true);
                conn.prepareStatement("SHUTDOWN").execute();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            this.hsqlServer.shutdown();
        }
    }

    Connection getConnection() throws IOException, SQLException {
        Properties jProps = this.loadPropertiesFrom("target/test-classes/jspwiki-custom.properties");
        return DriverManager.getConnection(this.getDriverUrl(), jProps.getProperty("jdbc.admin.id"), jProps.getProperty("jdbc.admin.password"));
    }

    public String getDriverUrl() throws IOException {
        Properties jProps = this.loadPropertiesFrom("target/test-classes/jspwiki-custom.properties");
        return jProps.getProperty("jdbc.driver.url").replace(":9321", ":" + this.localPort);
    }

    Properties loadPropertiesFrom(String fileLocation) throws IOException {
        Properties p = new Properties();
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(fileLocation));
        p.load(inStream);
        ((InputStream)inStream).close();
        return p;
    }
}

