/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.SessionMonitor;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.ui.WikiRequestWrapper;

public class WikiServletFilter
implements Filter {
    private static final Logger log = LogManager.getLogger(WikiServletFilter.class);
    protected Engine m_engine;

    public void init(FilterConfig config) throws ServletException {
        ServletContext context = config.getServletContext();
        if (System.getSecurityManager() != null) {
            context.log("== JSPWIKI WARNING ==  : This container is running with a security manager. JSPWiki does not yet really support that right now. See issue JSPWIKI-129 for details and information on how to proceed.");
        }
        this.m_engine = Wiki.engine().find(context, null);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (chain == null) {
            throw new ServletException("FilterChain is null, even if it should not be.  Please report this to the jspwiki development team.");
        }
        if (this.m_engine == null) {
            PrintWriter out = response.getWriter();
            out.print("<!DOCTYPE html><html lang=\"en\"><head><title>Fatal problem with JSPWiki</title></head>");
            out.print("<body>");
            out.print("<h1>JSPWiki has not been started</h1>");
            out.print("<p>JSPWiki is not running.  This is probably due to a configuration error in your jspwiki.properties file, ");
            out.print("or a problem with your servlet container.  Please double-check everything before issuing a bug report ");
            out.print("at jspwiki.apache.org.</p>");
            out.print("<p>We apologize for the inconvenience.  No, really, we do.  We're trying to ");
            out.print("JSPWiki as easy as we can, but there is only so much we have time to test ");
            out.print("platforms.</p>");
            out.print("<p>Please go to the <a href='Install.jsp'>installer</a> to continue.</p>");
            out.print("</body></html>");
            return;
        }
        Object httpRequest = (HttpServletRequest)request;
        httpRequest.setCharacterEncoding(this.m_engine.getContentEncoding().displayName());
        if (!this.isWrapped(request)) {
            try {
                ((AuthenticationManager)this.m_engine.getManager(AuthenticationManager.class)).login((HttpServletRequest)httpRequest);
                Session wikiSession = SessionMonitor.getInstance(this.m_engine).find(httpRequest.getSession());
                httpRequest = new WikiRequestWrapper(this.m_engine, (HttpServletRequest)httpRequest);
                log.debug("Executed security filters for user={}, path={}", (Object)wikiSession.getLoginPrincipal().getName(), (Object)httpRequest.getRequestURI());
            }
            catch (WikiSecurityException e) {
                throw new ServletException((Throwable)((Object)e));
            }
        }
        try {
            ThreadContext.push((String)(this.m_engine.getApplicationName() + ":" + httpRequest.getRequestURL()));
            chain.doFilter((ServletRequest)httpRequest, response);
        }
        finally {
            ThreadContext.pop();
            ThreadContext.remove((String)(this.m_engine.getApplicationName() + ":" + httpRequest.getRequestURL()));
        }
    }

    protected WikiContext getWikiContext(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        return (WikiContext)httpRequest.getAttribute("jspwiki.context");
    }

    private boolean isWrapped(ServletRequest request) {
        while (!(request instanceof WikiRequestWrapper) && request instanceof HttpServletRequestWrapper) {
            request = ((HttpServletRequestWrapper)request).getRequest();
        }
        return request instanceof WikiRequestWrapper;
    }
}

