/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.providers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.providers.AbstractFileProvider;

public class FileSystemProvider
extends AbstractFileProvider {
    private static final Logger log = LogManager.getLogger(FileSystemProvider.class);
    public static final String PROP_EXT = ".properties";

    @Override
    public void putPageText(Page page, String text) throws ProviderException {
        try {
            super.putPageText(page, text);
            this.putPageProperties(page);
        }
        catch (IOException e) {
            log.error("Saving failed");
        }
    }

    private void putPageProperties(Page page) throws IOException {
        Properties props = new Properties();
        String author = page.getAuthor();
        String changenote = (String)page.getAttribute("changenote");
        String viewcount = (String)page.getAttribute("viewcount");
        if (author != null) {
            props.setProperty("author", author);
        }
        if (changenote != null) {
            props.setProperty("changenote", changenote);
        }
        if (viewcount != null) {
            props.setProperty("viewcount", viewcount);
        }
        this.getCustomProperties(page, props);
        File file = new File(this.getPageDirectory(), this.mangleName(page.getName()) + PROP_EXT);
        try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            props.store(out, "JSPWiki page properties for page " + page.getName());
        }
    }

    private void getPageProperties(Page page) throws IOException {
        File file = new File(this.getPageDirectory(), this.mangleName(page.getName()) + PROP_EXT);
        if (file.exists()) {
            try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                String viewcount;
                Properties props = new Properties();
                props.load(in);
                page.setAuthor(props.getProperty("author"));
                String changenote = props.getProperty("changenote");
                if (changenote != null) {
                    page.setAttribute("changenote", (Object)changenote);
                }
                if ((viewcount = props.getProperty("viewcount")) != null) {
                    page.setAttribute("viewcount", (Object)viewcount);
                }
                this.setCustomProperties(page, props);
            }
        }
    }

    @Override
    public Page getPageInfo(String page, int version) throws ProviderException {
        Page p = super.getPageInfo(page, version);
        if (p != null) {
            try {
                this.getPageProperties(p);
            }
            catch (IOException e) {
                log.error("Unable to read page properties", (Throwable)e);
                throw new ProviderException("Unable to read page properties, check logs.");
            }
        }
        return p;
    }

    @Override
    public void deletePage(String pageName) throws ProviderException {
        super.deletePage(pageName);
        File file = new File(this.getPageDirectory(), this.mangleName(pageName) + PROP_EXT);
        if (file.exists()) {
            file.delete();
        }
    }

    public void movePage(String from, String to) throws ProviderException {
        File fromPage = this.findPage(from);
        File toPage = this.findPage(to);
        fromPage.renameTo(toPage);
    }
}

