/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki.syntax.jspwiki;

import java.io.PrintWriter;
import java.util.Map;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.apache.wiki.htmltowiki.syntax.jspwiki.MarkupHelper;
import org.jdom2.Element;

class ImageDecorator {
    final PrintWriter out;
    final XHtmlToWikiConfig config;

    ImageDecorator(PrintWriter out, XHtmlToWikiConfig config) {
        this.out = out;
        this.config = config;
    }

    void decorate(String src, Map<String, Object> imageAttrs) {
        if (imageAttrs.isEmpty()) {
            this.out.print("[" + src + "]");
        } else {
            this.out.print("[{Image src='" + src + "'");
            for (Map.Entry<String, Object> objectObjectEntry : imageAttrs.entrySet()) {
                if (objectObjectEntry.getValue().equals("")) continue;
                this.out.print(" " + objectObjectEntry.getKey() + "='" + objectObjectEntry.getValue() + "'");
            }
            this.out.print("}]");
        }
    }

    void decorate(Element e) {
        if (this.config.isNotIgnorableWikiMarkupLink(e)) {
            this.out.print("[");
            MarkupHelper.printUnescaped(this.out, this.config.trimLink(e.getAttributeValue("src")));
            this.out.print("]");
        }
    }
}

