/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki.syntax.jspwiki;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.wiki.htmltowiki.XHtmlElementToWikiTranslator;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.apache.wiki.htmltowiki.syntax.jspwiki.MarkupHelper;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

class ADecorator {
    final PrintWriter out;
    final XHtmlToWikiConfig config;
    final XHtmlElementToWikiTranslator chain;

    ADecorator(PrintWriter out, XHtmlToWikiConfig config, XHtmlElementToWikiTranslator chain) {
        this.out = out;
        this.config = config;
        this.chain = chain;
    }

    void decorate(Element e) throws JDOMException {
        if (this.config.isNotIgnorableWikiMarkupLink(e)) {
            if (e.getChild("IMG") != null) {
                this.chain.translateImage(e);
            } else {
                String ref = e.getAttributeValue("href");
                if (ref == null) {
                    if (this.isUndefinedPageLink(e)) {
                        this.out.print("[");
                        this.chain.translate((Content)e);
                        this.out.print("]");
                    } else {
                        this.chain.translate((Content)e);
                    }
                } else if ((ref = this.config.trimLink(ref)) != null) {
                    if (ref.startsWith("#")) {
                        String textValue;
                        String href = ref.replaceFirst("#ref-.+-(\\d+)", "$1");
                        if (href.equals(textValue = e.getValue().substring(1, e.getValue().length() - 1))) {
                            this.chain.translate((Content)e);
                        } else {
                            this.out.print("[" + textValue + "|" + href + "]");
                        }
                    } else {
                        Map<String, String> augmentedWikiLinkAttributes = this.getAugmentedWikiLinkAttributes(e);
                        this.out.print("[");
                        this.chain.translate((Content)e);
                        if (!e.getTextTrim().equalsIgnoreCase(ref)) {
                            this.out.print("|");
                            MarkupHelper.printUnescaped(this.out, ref);
                            if (!augmentedWikiLinkAttributes.isEmpty()) {
                                this.out.print("|");
                                String augmentedWikiLink = this.augmentedWikiLinkMapToString(augmentedWikiLinkAttributes);
                                this.out.print(augmentedWikiLink);
                            }
                        } else if (!augmentedWikiLinkAttributes.isEmpty()) {
                            this.out.print("|" + ref + "|");
                            String augmentedWikiLink = this.augmentedWikiLinkMapToString(augmentedWikiLinkAttributes);
                            this.out.print(augmentedWikiLink);
                        }
                        this.out.print("]");
                    }
                }
            }
        }
    }

    private boolean isUndefinedPageLink(Element a) {
        String classVal = a.getAttributeValue("class");
        return "createpage".equals(classVal);
    }

    private Map<String, String> getAugmentedWikiLinkAttributes(Element a) {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        String cssClass = a.getAttributeValue("class");
        if (StringUtils.isNotEmpty((CharSequence)cssClass) && !cssClass.matches("wikipage|createpage|external|interwiki|attachment")) {
            attributesMap.put("class", cssClass.replace("'", "\""));
        }
        this.addAttributeIfPresent(a, attributesMap, "accesskey");
        this.addAttributeIfPresent(a, attributesMap, "charset");
        this.addAttributeIfPresent(a, attributesMap, "dir");
        this.addAttributeIfPresent(a, attributesMap, "hreflang");
        this.addAttributeIfPresent(a, attributesMap, "id");
        this.addAttributeIfPresent(a, attributesMap, "lang");
        this.addAttributeIfPresent(a, attributesMap, "rel");
        this.addAttributeIfPresent(a, attributesMap, "rev");
        this.addAttributeIfPresent(a, attributesMap, "style");
        this.addAttributeIfPresent(a, attributesMap, "tabindex");
        this.addAttributeIfPresent(a, attributesMap, "target");
        this.addAttributeIfPresent(a, attributesMap, "title");
        this.addAttributeIfPresent(a, attributesMap, "type");
        return attributesMap;
    }

    private void addAttributeIfPresent(Element a, Map<String, String> attributesMap, String attribute) {
        String attr = a.getAttributeValue(attribute);
        if (StringUtils.isNotEmpty((CharSequence)attr)) {
            attributesMap.put(attribute, attr.replace("'", "\""));
        }
    }

    private String augmentedWikiLinkMapToString(Map<String, String> attributesMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            String attributeName = entry.getKey();
            String attributeValue = entry.getValue();
            sb.append(" ").append(attributeName).append("='").append(attributeValue).append("'");
        }
        return sb.toString().trim();
    }
}

