/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.htmltowiki.XHtmlElementToWikiTranslator;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderSAX2Factory;
import org.jdom2.output.XMLOutputter;

public class HtmlStringToWikiTranslator {
    private static final String CYBERNEKO_PARSER = "org.cyberneko.html.parsers.SAXParser";
    private final Engine e;

    public HtmlStringToWikiTranslator(Engine e) {
        this.e = e;
    }

    public String translate(String html) throws JDOMException, IOException, ReflectiveOperationException {
        return this.translate(html, new XHtmlToWikiConfig());
    }

    public String translate(String html, Context wikiContext) throws JDOMException, IOException, ReflectiveOperationException {
        return this.translate(html, new XHtmlToWikiConfig(wikiContext));
    }

    public String translate(String html, XHtmlToWikiConfig config) throws JDOMException, IOException, ReflectiveOperationException {
        Element element = this.htmlStringToElement(html);
        XHtmlElementToWikiTranslator xhtmlTranslator = new XHtmlElementToWikiTranslator(this.e, element, config);
        return xhtmlTranslator.getWikiString();
    }

    private Element htmlStringToElement(String html) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)new XMLReaderSAX2Factory(true, CYBERNEKO_PARSER), null, null);
        Document doc = builder.build((Reader)new StringReader(html));
        return doc.getRootElement();
    }

    public static String element2String(Element element) {
        Document document = new Document(element);
        XMLOutputter outputter = new XMLOutputter();
        return outputter.outputString(document);
    }
}

