/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.filters;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.FilterException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.filters.PageFilter;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.filters.FilterManager;
import org.apache.wiki.modules.BaseModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.PriorityList;
import org.apache.wiki.util.XmlUtil;
import org.jdom2.Element;

public class DefaultFilterManager
extends BaseModuleManager
implements FilterManager {
    private final PriorityList<PageFilter> m_pageFilters = new PriorityList();
    private final Map<String, PageFilterInfo> m_filterClassMap = new HashMap<String, PageFilterInfo>();
    private static final Logger log = LogManager.getLogger(DefaultFilterManager.class);

    public DefaultFilterManager(Engine engine, Properties props) throws WikiException {
        super(engine);
        this.initialize(props);
    }

    @Override
    public void addPageFilter(PageFilter f, int priority) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException("Attempt to provide a null filter - this should never happen.  Please check your configuration (or if you're a developer, check your own code.)");
        }
        this.m_pageFilters.add((Object)f, priority);
    }

    private void initPageFilter(String className, Properties props) {
        try {
            PageFilterInfo info = this.m_filterClassMap.get(className);
            if (info != null && !this.checkCompatibility(info)) {
                log.warn("Filter '{}' not compatible with this version of JSPWiki", (Object)info.getName());
                return;
            }
            boolean priority = false;
            PageFilter filter = (PageFilter)ClassUtil.buildInstance((String)"org.apache.wiki.filters", (String)className);
            filter.initialize(this.m_engine, props);
            this.addPageFilter(filter, 0);
            log.info("Added page filter {} with priority {}", (Object)filter.getClass().getName(), (Object)0);
        }
        catch (ReflectiveOperationException e) {
            log.error("Unable to instantiate PageFilter: {}", (Object)className);
        }
        catch (FilterException e) {
            log.error("Filter {} failed to initialize itself.", (Object)className, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(Properties props) throws WikiException {
        InputStream xmlStream = null;
        String xmlFile = props.getProperty("jspwiki.filterConfig");
        try {
            this.registerFilters();
            if (this.m_engine.getServletContext() != null) {
                log.debug("Attempting to locate /WEB-INF/filters.xml from servlet context.");
                xmlStream = xmlFile == null ? this.m_engine.getServletContext().getResourceAsStream("/WEB-INF/filters.xml") : this.m_engine.getServletContext().getResourceAsStream(xmlFile);
            }
            if (xmlStream == null) {
                log.debug("Attempting to locate filters.xml from class path.");
                xmlStream = xmlFile == null ? this.getClass().getResourceAsStream("/filters.xml") : this.getClass().getResourceAsStream(xmlFile);
            }
            if (xmlStream == null && xmlFile != null) {
                log.debug("Attempting to load property file " + xmlFile);
                xmlStream = Files.newInputStream(new File(xmlFile).toPath(), new OpenOption[0]);
            }
            if (xmlStream == null) {
                log.info("Cannot find property file for filters (this is okay, expected to find it as: '/WEB-INF/filters.xml')");
                return;
            }
            this.parseConfigFile(xmlStream);
        }
        catch (IOException e) {
            log.error("Unable to read property file", (Throwable)e);
        }
        finally {
            try {
                if (xmlStream != null) {
                    xmlStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void parseConfigFile(InputStream xmlStream) {
        List pageFilters = XmlUtil.parse((InputStream)xmlStream, (String)"/pagefilters/filter");
        for (Element f : pageFilters) {
            String filterClass = f.getChildText("class");
            Properties props = new Properties();
            List params = f.getChildren("param");
            for (Element p : params) {
                props.setProperty(p.getChildText("name"), p.getChildText("value"));
            }
            this.initPageFilter(filterClass, props);
        }
    }

    @Override
    public String doPreTranslateFiltering(Context context, String pageData) throws FilterException {
        this.fireEvent(12, context);
        for (PageFilter f : this.m_pageFilters) {
            pageData = f.preTranslate(context, pageData);
        }
        this.fireEvent(14, context);
        return pageData;
    }

    @Override
    public String doPostTranslateFiltering(Context context, String htmlData) throws FilterException {
        this.fireEvent(15, context);
        for (PageFilter f : this.m_pageFilters) {
            htmlData = f.postTranslate(context, htmlData);
        }
        this.fireEvent(17, context);
        return htmlData;
    }

    @Override
    public String doPreSaveFiltering(Context context, String pageData) throws FilterException {
        this.fireEvent(18, context);
        for (PageFilter f : this.m_pageFilters) {
            pageData = f.preSave(context, pageData);
        }
        this.fireEvent(20, context);
        return pageData;
    }

    @Override
    public void doPostSaveFiltering(Context context, String pageData) throws FilterException {
        this.fireEvent(21, context);
        for (PageFilter f : this.m_pageFilters) {
            f.postSave(context, pageData);
        }
        this.fireEvent(23, context);
    }

    @Override
    public List<PageFilter> getFilterList() {
        return this.m_pageFilters;
    }

    @Override
    public void destroy() {
        for (PageFilter f : this.m_pageFilters) {
            f.destroy(this.m_engine);
        }
    }

    public void fireEvent(int type, Context context) {
        if (WikiEventManager.isListening((Object)this) && WikiPageEvent.isValidType((int)type)) {
            WikiEventManager.fireEvent((Object)this, (WikiEvent)new WikiPageEvent((Object)this.m_engine, type, context.getPage().getName()));
        }
    }

    @Override
    public Collection<WikiModuleInfo> modules() {
        return this.modules(this.m_filterClassMap.values().iterator());
    }

    @Override
    public PageFilterInfo getModuleInfo(String moduleName) {
        return this.m_filterClassMap.get(moduleName);
    }

    private void registerFilters() {
        log.info("Registering filters");
        List filters = XmlUtil.parse((String)"ini/jspwiki_module.xml", (String)"/modules/filter");
        for (Element pluginEl : filters) {
            String className = pluginEl.getAttributeValue("class");
            PageFilterInfo filterInfo = PageFilterInfo.newInstance(className, pluginEl);
            if (filterInfo == null) continue;
            this.registerFilter(filterInfo);
        }
    }

    private void registerFilter(PageFilterInfo pluginInfo) {
        this.m_filterClassMap.put(pluginInfo.getName(), pluginInfo);
    }

    private static final class PageFilterInfo
    extends WikiModuleInfo {
        private PageFilterInfo(String name) {
            super(name);
        }

        static PageFilterInfo newInstance(String className, Element pluginEl) {
            if (className == null || className.isEmpty()) {
                return null;
            }
            PageFilterInfo info = new PageFilterInfo(className);
            info.initializeFromXML(pluginEl);
            return info;
        }
    }
}

