/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.diff;

import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.diff.DiffProvider;
import org.apache.wiki.diff.DifferenceManager;
import org.apache.wiki.diff.TraditionalDiffProvider;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.util.ClassUtil;

public class DefaultDifferenceManager
implements DifferenceManager {
    private static final Logger log = LogManager.getLogger(DefaultDifferenceManager.class);
    private DiffProvider m_provider;

    public DefaultDifferenceManager(Engine engine, Properties props) {
        this.loadProvider(props);
        this.initializeProvider(engine, props);
        log.info("Using difference provider: " + this.m_provider.getProviderInfo());
    }

    private void loadProvider(Properties props) {
        String providerClassName = props.getProperty("jspwiki.diffProvider", TraditionalDiffProvider.class.getName());
        try {
            this.m_provider = (DiffProvider)ClassUtil.buildInstance((String)"org.apache.wiki.diff", (String)providerClassName);
        }
        catch (ReflectiveOperationException e) {
            log.warn("Failed loading DiffProvider, will use NullDiffProvider.", (Throwable)e);
        }
        if (this.m_provider == null) {
            this.m_provider = new DiffProvider.NullDiffProvider();
        }
    }

    private void initializeProvider(Engine engine, Properties props) {
        try {
            this.m_provider.initialize(engine, props);
        }
        catch (IOException | NoRequiredPropertyException e) {
            log.warn("Failed initializing DiffProvider, will use NullDiffProvider.", e);
            this.m_provider = new DiffProvider.NullDiffProvider();
        }
    }

    @Override
    public String makeDiff(Context context, String firstWikiText, String secondWikiText) {
        String diff;
        try {
            diff = this.m_provider.makeDiffHtml(context, firstWikiText, secondWikiText);
            if (diff == null) {
                diff = "";
            }
        }
        catch (Exception e) {
            diff = "Failed to create a diff, check the logs.";
            log.warn(diff, (Throwable)e);
        }
        return diff;
    }

    @Override
    public String getDiff(Context context, int version1, int version2) {
        String page = context.getPage().getName();
        String page1 = ((PageManager)context.getEngine().getManager(PageManager.class)).getPureText(page, version1);
        String page2 = ((PageManager)context.getEngine().getManager(PageManager.class)).getPureText(page, version2);
        if (version1 == -1) {
            page1 = "";
        }
        return this.makeDiff(context, page1, page2);
    }
}

