/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.user;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.user.AbstractUserDatabase;
import org.apache.wiki.auth.user.DuplicateUserException;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.util.Serializer;
import org.apache.wiki.util.TextUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLUserDatabase
extends AbstractUserDatabase {
    public static final String PROP_USERDATABASE = "jspwiki.xmlUserDatabaseFile";
    private static final String DEFAULT_USERDATABASE = "userdatabase.xml";
    private static final String ATTRIBUTES_TAG = "attributes";
    private static final String CREATED = "created";
    private static final String EMAIL = "email";
    private static final String FULL_NAME = "fullName";
    private static final String LOGIN_NAME = "loginName";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String LOCK_EXPIRY = "lockExpiry";
    private static final String PASSWORD = "password";
    private static final String UID = "uid";
    private static final String USER_TAG = "user";
    private static final String WIKI_NAME = "wikiName";
    private static final String DATE_FORMAT = "yyyy.MM.dd 'at' HH:mm:ss:SSS z";
    private Document c_dom;
    private File c_file;
    private long c_lastCheck;
    private long c_lastModified;

    @Override
    public synchronized void deleteByLoginName(String loginName) throws NoSuchPrincipalException, WikiSecurityException {
        if (this.c_dom == null) {
            throw new WikiSecurityException("FATAL: database does not exist");
        }
        NodeList users = this.c_dom.getDocumentElement().getElementsByTagName(USER_TAG);
        for (int i = 0; i < users.getLength(); ++i) {
            Element user = (Element)users.item(i);
            if (!user.getAttribute(LOGIN_NAME).equals(loginName)) continue;
            this.c_dom.getDocumentElement().removeChild(user);
            this.saveDOM();
            return;
        }
        throw new NoSuchPrincipalException("Not in database: " + loginName);
    }

    @Override
    public UserProfile findByEmail(String index) throws NoSuchPrincipalException {
        return this.findBy(EMAIL, index);
    }

    @Override
    public UserProfile findByFullName(String index) throws NoSuchPrincipalException {
        return this.findBy(FULL_NAME, index);
    }

    @Override
    public UserProfile findByLoginName(String index) throws NoSuchPrincipalException {
        return this.findBy(LOGIN_NAME, index);
    }

    @Override
    public UserProfile findByUid(String uid) throws NoSuchPrincipalException {
        return this.findBy(UID, uid);
    }

    @Override
    public UserProfile findByWikiName(String index) throws NoSuchPrincipalException {
        return this.findBy(WIKI_NAME, index);
    }

    public UserProfile findBy(String attr, String value) throws NoSuchPrincipalException {
        UserProfile profile = this.findByAttribute(attr, value);
        if (profile != null) {
            return profile;
        }
        throw new NoSuchPrincipalException("Not in database: " + value);
    }

    @Override
    public Principal[] getWikiNames() throws WikiSecurityException {
        if (this.c_dom == null) {
            throw new IllegalStateException("FATAL: database does not exist");
        }
        TreeSet<WikiPrincipal> principals = new TreeSet<WikiPrincipal>();
        NodeList users = this.c_dom.getElementsByTagName(USER_TAG);
        for (int i = 0; i < users.getLength(); ++i) {
            Element user = (Element)users.item(i);
            String wikiName = user.getAttribute(WIKI_NAME);
            if (wikiName == null) {
                log.warn("Detected null wiki name in XMLUserDataBase. Check your user database.");
                continue;
            }
            WikiPrincipal principal = new WikiPrincipal(wikiName, WIKI_NAME);
            principals.add(principal);
        }
        return principals.toArray(new Principal[0]);
    }

    @Override
    public void initialize(Engine engine, Properties props) throws NoRequiredPropertyException {
        File defaultFile;
        if (engine.getRootPath() == null) {
            log.warn("Cannot identify JSPWiki root path");
            defaultFile = new File("WEB-INF/userdatabase.xml").getAbsoluteFile();
        } else {
            defaultFile = new File(engine.getRootPath() + "/WEB-INF/" + DEFAULT_USERDATABASE);
        }
        String file = TextUtil.getStringProperty((Properties)props, (String)PROP_USERDATABASE, (String)defaultFile.getAbsolutePath());
        if (file == null) {
            log.warn("XML user database property jspwiki.xmlUserDatabaseFile not found; trying " + defaultFile);
            this.c_file = defaultFile;
        } else {
            this.c_file = new File(file);
        }
        log.info("XML user database at " + this.c_file.getAbsolutePath());
        this.buildDOM();
        this.sanitizeDOM();
    }

    private void buildDOM() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setExpandEntityReferences(false);
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(false);
        try {
            this.c_dom = factory.newDocumentBuilder().parse(this.c_file);
            log.debug("Database successfully initialized");
            this.c_lastModified = this.c_file.lastModified();
            this.c_lastCheck = System.currentTimeMillis();
        }
        catch (ParserConfigurationException e) {
            log.error("Configuration error: " + e.getMessage());
        }
        catch (SAXException e) {
            log.error("SAX error: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            log.info("User database not found; creating from scratch...");
        }
        catch (IOException e) {
            log.error("IO error: " + e.getMessage());
        }
        if (this.c_dom == null) {
            try {
                this.c_dom = factory.newDocumentBuilder().newDocument();
                this.c_dom.appendChild(this.c_dom.createElement("users"));
            }
            catch (ParserConfigurationException e) {
                log.fatal("Could not create in-memory DOM");
            }
        }
    }

    private void saveDOM() throws WikiSecurityException {
        if (this.c_dom == null) {
            throw new IllegalStateException("FATAL: database does not exist");
        }
        File newFile = new File(this.c_file.getAbsolutePath() + ".new");
        try (BufferedWriter io = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(newFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            io.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            io.write("<users>\n");
            Element root = this.c_dom.getDocumentElement();
            NodeList nodes = root.getElementsByTagName(USER_TAG);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element user = (Element)nodes.item(i);
                io.write("    <user ");
                io.write(UID);
                io.write("=\"" + user.getAttribute(UID) + "\" ");
                io.write(LOGIN_NAME);
                io.write("=\"" + user.getAttribute(LOGIN_NAME) + "\" ");
                io.write(WIKI_NAME);
                io.write("=\"" + user.getAttribute(WIKI_NAME) + "\" ");
                io.write(FULL_NAME);
                io.write("=\"" + user.getAttribute(FULL_NAME) + "\" ");
                io.write(EMAIL);
                io.write("=\"" + user.getAttribute(EMAIL) + "\" ");
                io.write(PASSWORD);
                io.write("=\"" + user.getAttribute(PASSWORD) + "\" ");
                io.write(CREATED);
                io.write("=\"" + user.getAttribute(CREATED) + "\" ");
                io.write(LAST_MODIFIED);
                io.write("=\"" + user.getAttribute(LAST_MODIFIED) + "\" ");
                io.write(LOCK_EXPIRY);
                io.write("=\"" + user.getAttribute(LOCK_EXPIRY) + "\" ");
                io.write(">");
                NodeList attributes = user.getElementsByTagName(ATTRIBUTES_TAG);
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Element attribute = (Element)attributes.item(j);
                    String value = this.extractText(attribute);
                    io.write("\n        <attributes>");
                    io.write(value);
                    io.write("</attributes>");
                }
                io.write("\n    </user>\n");
            }
            io.write("</users>");
        }
        catch (IOException e) {
            throw new WikiSecurityException(e.getLocalizedMessage(), e);
        }
        File backup = new File(this.c_file.getAbsolutePath() + ".old");
        if (backup.exists() && !backup.delete()) {
            log.error("Could not delete old user database backup: " + backup);
        }
        if (!this.c_file.renameTo(backup)) {
            log.error("Could not create user database backup: " + backup);
        }
        if (!newFile.renameTo(this.c_file)) {
            log.error("Could not save database: " + backup + " restoring backup.");
            if (!backup.renameTo(this.c_file)) {
                log.error("Restore failed. Check the file permissions.");
            }
            log.error("Could not save database: " + this.c_file + ". Check the file permissions");
        }
    }

    private void checkForRefresh() {
        long lastModified;
        long time = System.currentTimeMillis();
        if (time - this.c_lastCheck > 60000L && (lastModified = this.c_file.lastModified()) > this.c_lastModified) {
            this.buildDOM();
        }
    }

    @Override
    public synchronized void rename(String loginName, String newName) throws NoSuchPrincipalException, DuplicateUserException, WikiSecurityException {
        if (this.c_dom == null) {
            log.fatal("Could not rename profile '" + loginName + "'; database does not exist");
            throw new IllegalStateException("FATAL: database does not exist");
        }
        this.checkForRefresh();
        UserProfile profile = this.findByLoginName(loginName);
        try {
            UserProfile otherProfile = this.findByLoginName(newName);
            if (otherProfile != null) {
                throw new DuplicateUserException("security.error.cannot.rename", newName);
            }
        }
        catch (NoSuchPrincipalException otherProfile) {
            // empty catch block
        }
        NodeList users = this.c_dom.getElementsByTagName(USER_TAG);
        for (int i = 0; i < users.getLength(); ++i) {
            Element user = (Element)users.item(i);
            if (!user.getAttribute(LOGIN_NAME).equals(loginName)) continue;
            SimpleDateFormat c_format = new SimpleDateFormat(DATE_FORMAT);
            Date modDate = new Date(System.currentTimeMillis());
            this.setAttribute(user, LOGIN_NAME, newName);
            this.setAttribute(user, LAST_MODIFIED, c_format.format(modDate));
            profile.setLoginName(newName);
            profile.setLastModified(modDate);
            break;
        }
        this.saveDOM();
    }

    @Override
    public synchronized void save(UserProfile profile) throws WikiSecurityException {
        String oldPassword;
        if (this.c_dom == null) {
            log.fatal("Could not save profile " + profile + " database does not exist");
            throw new IllegalStateException("FATAL: database does not exist");
        }
        this.checkForRefresh();
        SimpleDateFormat c_format = new SimpleDateFormat(DATE_FORMAT);
        String index = profile.getLoginName();
        NodeList users = this.c_dom.getElementsByTagName(USER_TAG);
        Element user = null;
        for (int i = 0; i < users.getLength(); ++i) {
            Element currentUser = (Element)users.item(i);
            if (!currentUser.getAttribute(LOGIN_NAME).equals(index)) continue;
            user = currentUser;
            break;
        }
        boolean isNew = false;
        Date modDate = new Date(System.currentTimeMillis());
        if (user == null) {
            profile.setCreated(modDate);
            log.info("Creating new user " + index);
            user = this.c_dom.createElement(USER_TAG);
            this.c_dom.getDocumentElement().appendChild(user);
            this.setAttribute(user, CREATED, c_format.format(profile.getCreated()));
            isNew = true;
        } else {
            NodeList attributes = user.getElementsByTagName(ATTRIBUTES_TAG);
            for (int i = 0; i < attributes.getLength(); ++i) {
                user.removeChild(attributes.item(i));
            }
        }
        this.setAttribute(user, UID, profile.getUid());
        this.setAttribute(user, LAST_MODIFIED, c_format.format(modDate));
        this.setAttribute(user, LOGIN_NAME, profile.getLoginName());
        this.setAttribute(user, FULL_NAME, profile.getFullname());
        this.setAttribute(user, WIKI_NAME, profile.getWikiName());
        this.setAttribute(user, EMAIL, profile.getEmail());
        Date lockExpiry = profile.getLockExpiry();
        this.setAttribute(user, LOCK_EXPIRY, lockExpiry == null ? "" : c_format.format(lockExpiry));
        String newPassword = profile.getPassword();
        if (newPassword != null && !newPassword.equals("") && !(oldPassword = user.getAttribute(PASSWORD)).equals(newPassword)) {
            this.setAttribute(user, PASSWORD, this.getHash(newPassword));
        }
        if (profile.getAttributes().size() > 0) {
            try {
                String encodedAttributes = Serializer.serializeToBase64(profile.getAttributes());
                Element attributes = this.c_dom.createElement(ATTRIBUTES_TAG);
                user.appendChild(attributes);
                Text value = this.c_dom.createTextNode(encodedAttributes);
                attributes.appendChild(value);
            }
            catch (IOException e) {
                throw new WikiSecurityException("Could not save user profile attribute. Reason: " + e.getMessage(), e);
            }
        }
        if (isNew) {
            profile.setCreated(modDate);
        }
        profile.setLastModified(modDate);
        this.saveDOM();
    }

    private UserProfile findByAttribute(String matchAttribute, String index) {
        if (this.c_dom == null) {
            throw new IllegalStateException("FATAL: database does not exist");
        }
        this.checkForRefresh();
        NodeList users = this.c_dom.getElementsByTagName(USER_TAG);
        if (users == null) {
            return null;
        }
        boolean caseSensitiveCompare = !matchAttribute.equals(EMAIL);
        for (int i = 0; i < users.getLength(); ++i) {
            Element user = (Element)users.item(i);
            String userAttribute = user.getAttribute(matchAttribute);
            if (!caseSensitiveCompare) {
                userAttribute = StringUtils.lowerCase((String)userAttribute);
                index = StringUtils.lowerCase((String)index);
            }
            if (!userAttribute.equals(index)) continue;
            UserProfile profile = this.newProfile();
            profile.setUid(user.getAttribute(UID));
            if (profile.getUid() == null || profile.getUid().isEmpty()) {
                profile.setUid(XMLUserDatabase.generateUid(this));
            }
            profile.setLoginName(user.getAttribute(LOGIN_NAME));
            profile.setFullname(user.getAttribute(FULL_NAME));
            profile.setPassword(user.getAttribute(PASSWORD));
            profile.setEmail(user.getAttribute(EMAIL));
            String created = user.getAttribute(CREATED);
            String modified = user.getAttribute(LAST_MODIFIED);
            profile.setCreated(this.parseDate(profile, created));
            profile.setLastModified(this.parseDate(profile, modified));
            String lockExpiry = user.getAttribute(LOCK_EXPIRY);
            if (lockExpiry == null || lockExpiry.isEmpty()) {
                profile.setLockExpiry(null);
            } else {
                profile.setLockExpiry(new Date(Long.parseLong(lockExpiry)));
            }
            NodeList attributes = user.getElementsByTagName(ATTRIBUTES_TAG);
            for (int j = 0; j < attributes.getLength(); ++j) {
                Element attribute = (Element)attributes.item(j);
                String serializedMap = this.extractText(attribute);
                try {
                    Map map = Serializer.deserializeFromBase64((String)serializedMap);
                    profile.getAttributes().putAll(map);
                    continue;
                }
                catch (IOException e) {
                    log.error("Could not parse user profile attributes!", (Throwable)e);
                }
            }
            return profile;
        }
        return null;
    }

    private String extractText(Element element) {
        StringBuilder text = new StringBuilder();
        if (element.getChildNodes().getLength() > 0) {
            NodeList children = element.getChildNodes();
            for (int k = 0; k < children.getLength(); ++k) {
                Node child = children.item(k);
                if (child.getNodeType() != 3) continue;
                text.append(((Text)child).getData());
            }
        }
        return text.toString();
    }

    private Date parseDate(UserProfile profile, String date) {
        try {
            SimpleDateFormat c_format = new SimpleDateFormat(DATE_FORMAT);
            return c_format.parse(date);
        }
        catch (ParseException e) {
            try {
                return DateFormat.getDateTimeInstance().parse(date);
            }
            catch (ParseException e2) {
                log.warn("Could not parse 'created' or 'lastModified' attribute for profile '" + profile.getLoginName() + "'. It may have been tampered with.", (Throwable)e2);
                return null;
            }
        }
    }

    private void sanitizeDOM() {
        if (this.c_dom == null) {
            throw new IllegalStateException("FATAL: database does not exist");
        }
        NodeList users = this.c_dom.getElementsByTagName(USER_TAG);
        for (int i = 0; i < users.getLength(); ++i) {
            Element user = (Element)users.item(i);
            String uid = user.getAttribute(UID).trim();
            if (uid == null || uid.isEmpty() || "-1".equals(uid)) {
                uid = String.valueOf(XMLUserDatabase.generateUid(this));
                user.setAttribute(UID, uid);
            }
            String loginName = user.getAttribute(LOGIN_NAME);
            String created = user.getAttribute(CREATED);
            String modified = user.getAttribute(LAST_MODIFIED);
            SimpleDateFormat c_format = new SimpleDateFormat(DATE_FORMAT);
            try {
                created = c_format.format(c_format.parse(created));
                modified = c_format.format(c_format.parse(modified));
                user.setAttribute(CREATED, created);
                user.setAttribute(LAST_MODIFIED, modified);
                continue;
            }
            catch (ParseException e) {
                try {
                    created = c_format.format(DateFormat.getDateTimeInstance().parse(created));
                    modified = c_format.format(DateFormat.getDateTimeInstance().parse(modified));
                    user.setAttribute(CREATED, created);
                    user.setAttribute(LAST_MODIFIED, modified);
                    continue;
                }
                catch (ParseException e2) {
                    log.warn("Could not parse 'created' or 'lastModified' attribute for profile '" + loginName + "'. It may have been tampered with.");
                }
            }
        }
    }

    private void setAttribute(Element element, String attribute, String value) {
        if (value != null) {
            element.setAttribute(attribute, value);
        }
    }
}

