/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor;

import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ext.toc.TocBlock;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorStateCommonOperations;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.parser.PluginContent;
import org.apache.wiki.preferences.Preferences;

public class PluginLinkNodePostProcessorState
implements NodePostProcessorState<JSPWikiLink> {
    private static final Logger LOG = LogManager.getLogger(PluginLinkNodePostProcessorState.class);
    private final Context wikiContext;
    private final boolean m_wysiwygEditorMode;

    public PluginLinkNodePostProcessorState(Context wikiContext) {
        this.wikiContext = wikiContext;
        Boolean wysiwygVariable = (Boolean)wikiContext.getVariable("WYSIWYG_EDITOR_MODE");
        this.m_wysiwygEditorMode = wysiwygVariable != null ? wysiwygVariable : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(NodeTracker state, JSPWikiLink link) {
        if (link.getText().toString().startsWith("{TableOfContents")) {
            this.handleTableOfContentsPlugin(state, link);
            return;
        }
        PluginContent pluginContent = null;
        try {
            pluginContent = PluginContent.parsePluginLine((Context)this.wikiContext, (String)link.getUrl().toString(), (int)-1);
            if (pluginContent != null) {
                String pluginInvocation = this.pluginInvocation(link.getText().toString(), pluginContent);
                HtmlInline content = new HtmlInline((BasedSequence)CharSubSequence.of((CharSequence)pluginInvocation));
                pluginContent.executeParse(this.wikiContext);
                NodePostProcessorStateCommonOperations.addContent(state, (Node)link, (Node)content);
            }
        }
        catch (PluginException e) {
            LOG.info(this.wikiContext.getRealPage().getWiki() + " : " + this.wikiContext.getRealPage().getName() + " - Failed to insert plugin: " + e.getMessage());
            if (!this.m_wysiwygEditorMode) {
                ResourceBundle rbPlugin = Preferences.getBundle((Context)this.wikiContext, (String)"plugin.PluginResources");
                NodePostProcessorStateCommonOperations.makeError(state, (Node)link, MessageFormat.format(rbPlugin.getString("plugin.error.insertionfailed"), this.wikiContext.getRealPage().getWiki(), this.wikiContext.getRealPage().getName(), e.getMessage()));
            }
        }
        finally {
            if (pluginContent != null) {
                this.removeLink(state, link);
            }
        }
    }

    String pluginInvocation(String pluginMarkup, PluginContent pluginContent) {
        String pluginInvocation = pluginContent.invoke(this.wikiContext);
        if (pluginMarkup.equals(pluginInvocation + "()")) {
            return pluginMarkup;
        }
        return pluginInvocation;
    }

    void handleTableOfContentsPlugin(NodeTracker state, JSPWikiLink link) {
        if (!this.m_wysiwygEditorMode) {
            ResourceBundle rb = Preferences.getBundle((Context)this.wikiContext, (String)"plugin.PluginResources");
            HtmlInline divToc = new HtmlInline((BasedSequence)CharSubSequence.of((CharSequence)"<div class=\"toc\">\n"));
            HtmlInline divCollapseBox = new HtmlInline((BasedSequence)CharSubSequence.of((CharSequence)"<div class=\"collapsebox\">\n"));
            HtmlInline divsClosing = new HtmlInline((BasedSequence)CharSubSequence.of((CharSequence)"</div>\n</div>\n"));
            HtmlInline h4Title = new HtmlInline((BasedSequence)CharSubSequence.of((CharSequence)("<h4 id=\"section-TOC\">" + rb.getString("tableofcontents.title") + "</h4>\n")));
            TocBlock toc = new TocBlock((BasedSequence)CharSubSequence.of((CharSequence)"[TOC]"), (BasedSequence)CharSubSequence.of((CharSequence)"levels=1-3"));
            link.insertAfter((Node)divToc);
            divToc.insertAfter((Node)divCollapseBox);
            divCollapseBox.insertAfter((Node)h4Title);
            h4Title.insertAfter((Node)toc);
            toc.insertAfter((Node)divsClosing);
        } else {
            NodePostProcessorStateCommonOperations.inlineLinkTextOnWysiwyg(state, link, this.m_wysiwygEditorMode);
        }
        this.removeLink(state, link);
    }

    void removeLink(NodeTracker state, JSPWikiLink link) {
        link.unlink();
        state.nodeRemoved((Node)link);
    }
}

