/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kendra.model.AttributeFilter;
import com.amazonaws.services.kendra.model.DocumentRelevanceConfiguration;
import com.amazonaws.services.kendra.model.Facet;
import com.amazonaws.services.kendra.model.QueryResultType;
import com.amazonaws.services.kendra.model.SortingConfiguration;
import com.amazonaws.services.kendra.model.UserContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QueryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String indexId;
    private String queryText;
    private AttributeFilter attributeFilter;
    private List<Facet> facets;
    private List<String> requestedDocumentAttributes;
    private String queryResultTypeFilter;
    private List<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations;
    private Integer pageNumber;
    private Integer pageSize;
    private SortingConfiguration sortingConfiguration;
    private UserContext userContext;
    private String visitorId;

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public String getIndexId() {
        return this.indexId;
    }

    public QueryRequest withIndexId(String indexId) {
        this.setIndexId(indexId);
        return this;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public QueryRequest withQueryText(String queryText) {
        this.setQueryText(queryText);
        return this;
    }

    public void setAttributeFilter(AttributeFilter attributeFilter) {
        this.attributeFilter = attributeFilter;
    }

    public AttributeFilter getAttributeFilter() {
        return this.attributeFilter;
    }

    public QueryRequest withAttributeFilter(AttributeFilter attributeFilter) {
        this.setAttributeFilter(attributeFilter);
        return this;
    }

    public List<Facet> getFacets() {
        return this.facets;
    }

    public void setFacets(Collection<Facet> facets) {
        if (facets == null) {
            this.facets = null;
            return;
        }
        this.facets = new ArrayList<Facet>(facets);
    }

    public QueryRequest withFacets(Facet ... facets) {
        if (this.facets == null) {
            this.setFacets(new ArrayList<Facet>(facets.length));
        }
        for (Facet ele : facets) {
            this.facets.add(ele);
        }
        return this;
    }

    public QueryRequest withFacets(Collection<Facet> facets) {
        this.setFacets(facets);
        return this;
    }

    public List<String> getRequestedDocumentAttributes() {
        return this.requestedDocumentAttributes;
    }

    public void setRequestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
        if (requestedDocumentAttributes == null) {
            this.requestedDocumentAttributes = null;
            return;
        }
        this.requestedDocumentAttributes = new ArrayList<String>(requestedDocumentAttributes);
    }

    public QueryRequest withRequestedDocumentAttributes(String ... requestedDocumentAttributes) {
        if (this.requestedDocumentAttributes == null) {
            this.setRequestedDocumentAttributes(new ArrayList<String>(requestedDocumentAttributes.length));
        }
        for (String ele : requestedDocumentAttributes) {
            this.requestedDocumentAttributes.add(ele);
        }
        return this;
    }

    public QueryRequest withRequestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
        this.setRequestedDocumentAttributes(requestedDocumentAttributes);
        return this;
    }

    public void setQueryResultTypeFilter(String queryResultTypeFilter) {
        this.queryResultTypeFilter = queryResultTypeFilter;
    }

    public String getQueryResultTypeFilter() {
        return this.queryResultTypeFilter;
    }

    public QueryRequest withQueryResultTypeFilter(String queryResultTypeFilter) {
        this.setQueryResultTypeFilter(queryResultTypeFilter);
        return this;
    }

    public QueryRequest withQueryResultTypeFilter(QueryResultType queryResultTypeFilter) {
        this.queryResultTypeFilter = queryResultTypeFilter.toString();
        return this;
    }

    public List<DocumentRelevanceConfiguration> getDocumentRelevanceOverrideConfigurations() {
        return this.documentRelevanceOverrideConfigurations;
    }

    public void setDocumentRelevanceOverrideConfigurations(Collection<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations) {
        if (documentRelevanceOverrideConfigurations == null) {
            this.documentRelevanceOverrideConfigurations = null;
            return;
        }
        this.documentRelevanceOverrideConfigurations = new ArrayList<DocumentRelevanceConfiguration>(documentRelevanceOverrideConfigurations);
    }

    public QueryRequest withDocumentRelevanceOverrideConfigurations(DocumentRelevanceConfiguration ... documentRelevanceOverrideConfigurations) {
        if (this.documentRelevanceOverrideConfigurations == null) {
            this.setDocumentRelevanceOverrideConfigurations(new ArrayList<DocumentRelevanceConfiguration>(documentRelevanceOverrideConfigurations.length));
        }
        for (DocumentRelevanceConfiguration ele : documentRelevanceOverrideConfigurations) {
            this.documentRelevanceOverrideConfigurations.add(ele);
        }
        return this;
    }

    public QueryRequest withDocumentRelevanceOverrideConfigurations(Collection<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations) {
        this.setDocumentRelevanceOverrideConfigurations(documentRelevanceOverrideConfigurations);
        return this;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public QueryRequest withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public QueryRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public void setSortingConfiguration(SortingConfiguration sortingConfiguration) {
        this.sortingConfiguration = sortingConfiguration;
    }

    public SortingConfiguration getSortingConfiguration() {
        return this.sortingConfiguration;
    }

    public QueryRequest withSortingConfiguration(SortingConfiguration sortingConfiguration) {
        this.setSortingConfiguration(sortingConfiguration);
        return this;
    }

    public void setUserContext(UserContext userContext) {
        this.userContext = userContext;
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public QueryRequest withUserContext(UserContext userContext) {
        this.setUserContext(userContext);
        return this;
    }

    public void setVisitorId(String visitorId) {
        this.visitorId = visitorId;
    }

    public String getVisitorId() {
        return this.visitorId;
    }

    public QueryRequest withVisitorId(String visitorId) {
        this.setVisitorId(visitorId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexId() != null) {
            sb.append("IndexId: ").append(this.getIndexId()).append(",");
        }
        if (this.getQueryText() != null) {
            sb.append("QueryText: ").append(this.getQueryText()).append(",");
        }
        if (this.getAttributeFilter() != null) {
            sb.append("AttributeFilter: ").append(this.getAttributeFilter()).append(",");
        }
        if (this.getFacets() != null) {
            sb.append("Facets: ").append(this.getFacets()).append(",");
        }
        if (this.getRequestedDocumentAttributes() != null) {
            sb.append("RequestedDocumentAttributes: ").append(this.getRequestedDocumentAttributes()).append(",");
        }
        if (this.getQueryResultTypeFilter() != null) {
            sb.append("QueryResultTypeFilter: ").append(this.getQueryResultTypeFilter()).append(",");
        }
        if (this.getDocumentRelevanceOverrideConfigurations() != null) {
            sb.append("DocumentRelevanceOverrideConfigurations: ").append(this.getDocumentRelevanceOverrideConfigurations()).append(",");
        }
        if (this.getPageNumber() != null) {
            sb.append("PageNumber: ").append(this.getPageNumber()).append(",");
        }
        if (this.getPageSize() != null) {
            sb.append("PageSize: ").append(this.getPageSize()).append(",");
        }
        if (this.getSortingConfiguration() != null) {
            sb.append("SortingConfiguration: ").append(this.getSortingConfiguration()).append(",");
        }
        if (this.getUserContext() != null) {
            sb.append("UserContext: ").append(this.getUserContext()).append(",");
        }
        if (this.getVisitorId() != null) {
            sb.append("VisitorId: ").append(this.getVisitorId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest)obj;
        if (other.getIndexId() == null ^ this.getIndexId() == null) {
            return false;
        }
        if (other.getIndexId() != null && !other.getIndexId().equals(this.getIndexId())) {
            return false;
        }
        if (other.getQueryText() == null ^ this.getQueryText() == null) {
            return false;
        }
        if (other.getQueryText() != null && !other.getQueryText().equals(this.getQueryText())) {
            return false;
        }
        if (other.getAttributeFilter() == null ^ this.getAttributeFilter() == null) {
            return false;
        }
        if (other.getAttributeFilter() != null && !other.getAttributeFilter().equals(this.getAttributeFilter())) {
            return false;
        }
        if (other.getFacets() == null ^ this.getFacets() == null) {
            return false;
        }
        if (other.getFacets() != null && !other.getFacets().equals(this.getFacets())) {
            return false;
        }
        if (other.getRequestedDocumentAttributes() == null ^ this.getRequestedDocumentAttributes() == null) {
            return false;
        }
        if (other.getRequestedDocumentAttributes() != null && !other.getRequestedDocumentAttributes().equals(this.getRequestedDocumentAttributes())) {
            return false;
        }
        if (other.getQueryResultTypeFilter() == null ^ this.getQueryResultTypeFilter() == null) {
            return false;
        }
        if (other.getQueryResultTypeFilter() != null && !other.getQueryResultTypeFilter().equals(this.getQueryResultTypeFilter())) {
            return false;
        }
        if (other.getDocumentRelevanceOverrideConfigurations() == null ^ this.getDocumentRelevanceOverrideConfigurations() == null) {
            return false;
        }
        if (other.getDocumentRelevanceOverrideConfigurations() != null && !other.getDocumentRelevanceOverrideConfigurations().equals(this.getDocumentRelevanceOverrideConfigurations())) {
            return false;
        }
        if (other.getPageNumber() == null ^ this.getPageNumber() == null) {
            return false;
        }
        if (other.getPageNumber() != null && !other.getPageNumber().equals(this.getPageNumber())) {
            return false;
        }
        if (other.getPageSize() == null ^ this.getPageSize() == null) {
            return false;
        }
        if (other.getPageSize() != null && !other.getPageSize().equals(this.getPageSize())) {
            return false;
        }
        if (other.getSortingConfiguration() == null ^ this.getSortingConfiguration() == null) {
            return false;
        }
        if (other.getSortingConfiguration() != null && !other.getSortingConfiguration().equals(this.getSortingConfiguration())) {
            return false;
        }
        if (other.getUserContext() == null ^ this.getUserContext() == null) {
            return false;
        }
        if (other.getUserContext() != null && !other.getUserContext().equals(this.getUserContext())) {
            return false;
        }
        if (other.getVisitorId() == null ^ this.getVisitorId() == null) {
            return false;
        }
        return other.getVisitorId() == null || other.getVisitorId().equals(this.getVisitorId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexId() == null ? 0 : this.getIndexId().hashCode());
        hashCode = 31 * hashCode + (this.getQueryText() == null ? 0 : this.getQueryText().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeFilter() == null ? 0 : this.getAttributeFilter().hashCode());
        hashCode = 31 * hashCode + (this.getFacets() == null ? 0 : this.getFacets().hashCode());
        hashCode = 31 * hashCode + (this.getRequestedDocumentAttributes() == null ? 0 : this.getRequestedDocumentAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getQueryResultTypeFilter() == null ? 0 : this.getQueryResultTypeFilter().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentRelevanceOverrideConfigurations() == null ? 0 : this.getDocumentRelevanceOverrideConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getPageNumber() == null ? 0 : this.getPageNumber().hashCode());
        hashCode = 31 * hashCode + (this.getPageSize() == null ? 0 : this.getPageSize().hashCode());
        hashCode = 31 * hashCode + (this.getSortingConfiguration() == null ? 0 : this.getSortingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getUserContext() == null ? 0 : this.getUserContext().hashCode());
        hashCode = 31 * hashCode + (this.getVisitorId() == null ? 0 : this.getVisitorId().hashCode());
        return hashCode;
    }

    public QueryRequest clone() {
        return (QueryRequest)super.clone();
    }
}

