/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.NoSuchVariableException;
import org.apache.wiki.modules.BaseModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.ui.EditorManager;
import org.apache.wiki.util.XmlUtil;
import org.apache.wiki.variables.VariableManager;
import org.jdom2.Element;

public class DefaultEditorManager
extends BaseModuleManager
implements EditorManager {
    private Map<String, WikiEditorInfo> m_editors;
    private static final Logger log = LogManager.getLogger(DefaultEditorManager.class);

    public DefaultEditorManager(Engine engine) {
        super(engine);
    }

    public void initialize(Engine engine, Properties props) {
        this.registerEditors();
    }

    private void registerEditors() {
        log.info("Registering editor modules");
        this.m_editors = new HashMap<String, WikiEditorInfo>();
        List editors = XmlUtil.parse((String)"ini/jspwiki_module.xml", (String)"/modules/editor");
        for (Element pluginEl : editors) {
            String name = pluginEl.getAttributeValue("name");
            WikiEditorInfo info = WikiEditorInfo.newInstance(name, pluginEl);
            if (this.checkCompatibility(info)) {
                this.m_editors.put(name, info);
                log.debug("Registered editor " + name);
                continue;
            }
            log.info("Editor '" + name + "' not compatible with this version of JSPWiki.");
        }
    }

    @Override
    public String getEditorName(Context context) {
        if (context.getRequestContext().equals(ContextEnum.PAGE_PREVIEW.getRequestContext())) {
            return "preview";
        }
        String editor = Preferences.getPreference(context, "editor");
        if (editor == null) {
            try {
                editor = ((VariableManager)this.m_engine.getManager(VariableManager.class)).getValue(context, "jspwiki.editor");
            }
            catch (NoSuchVariableException noSuchVariableException) {
                // empty catch block
            }
        }
        if (editor != null) {
            String[] editorlist = this.getEditorList();
            editor = editor.trim();
            for (String s : editorlist) {
                if (!s.equalsIgnoreCase(editor)) continue;
                return s;
            }
        }
        return "plain";
    }

    @Override
    public String[] getEditorList() {
        String[] editors = new String[this.m_editors.size()];
        Set<String> keys = this.m_editors.keySet();
        return keys.toArray(editors);
    }

    @Override
    public String getEditorPath(Context context) {
        String editor = this.getEditorName(context);
        WikiEditorInfo ed = this.m_editors.get(editor);
        String path = ed != null ? ed.getPath() : "editors/" + editor + ".jsp";
        return path;
    }

    @Override
    public Collection<WikiModuleInfo> modules() {
        return this.modules(this.m_editors.values().iterator());
    }

    @Override
    public WikiEditorInfo getModuleInfo(String moduleName) {
        return this.m_editors.get(moduleName);
    }

    private static final class WikiEditorInfo
    extends WikiModuleInfo {
        private String m_path;

        static WikiEditorInfo newInstance(String name, Element el) {
            if (name == null || name.isEmpty()) {
                return null;
            }
            WikiEditorInfo info = new WikiEditorInfo(name);
            info.initializeFromXML(el);
            return info;
        }

        @Override
        protected void initializeFromXML(Element el) {
            super.initializeFromXML(el);
            this.m_path = el.getChildText("path");
        }

        private WikiEditorInfo(String name) {
            super(name);
        }

        public String getPath() {
            return this.m_path;
        }
    }
}

