/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.wiki.tags.TabbedSectionTag;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.util.TextUtil;

public class TabTag
extends WikiTagBase {
    private static final long serialVersionUID = -8534125226484616489L;
    private String m_accesskey;
    private String m_tabTitle;
    private String m_url;

    @Override
    public void doFinally() {
        super.doFinally();
        this.m_accesskey = null;
        this.m_tabTitle = null;
        this.m_url = null;
    }

    public void setTitle(String aTabTitle) {
        this.m_tabTitle = TextUtil.replaceEntities((String)aTabTitle);
    }

    public void setAccesskey(String anAccesskey) {
        this.m_accesskey = TextUtil.replaceEntities((String)anAccesskey);
    }

    public void setUrl(String url) {
        this.m_url = TextUtil.replaceEntities((String)url);
    }

    private boolean handleAccesskey() {
        if (this.m_tabTitle == null || this.m_accesskey == null) {
            return false;
        }
        int pos = this.m_tabTitle.toLowerCase().indexOf(this.m_accesskey.toLowerCase());
        if (pos > -1) {
            this.m_tabTitle = this.m_tabTitle.substring(0, pos) + "<span class='accesskey'>" + this.m_tabTitle.charAt(pos) + "</span>" + this.m_tabTitle.substring(pos + 1);
        }
        return true;
    }

    @Override
    public int doWikiStartTag() throws JspTagException {
        TabbedSectionTag parent = (TabbedSectionTag)TabTag.findAncestorWithClass((Tag)this, TabbedSectionTag.class);
        if (this.getId() == null) {
            throw new JspTagException("Tab Tag without \"id\" attribute");
        }
        if (this.m_tabTitle == null) {
            throw new JspTagException("Tab Tag without \"tabTitle\" attribute");
        }
        if (parent == null) {
            throw new JspTagException("Tab Tag without parent \"TabbedSection\" Tag");
        }
        if (!parent.isStateGenerateTabBody()) {
            return 0;
        }
        StringBuilder sb = new StringBuilder(32);
        sb.append("<div id=\"").append(this.getId()).append("\"");
        if (!parent.validateDefaultTab(this.getId())) {
            sb.append(" class=\"hidetab\"");
        }
        sb.append(" >\n");
        try {
            this.pageContext.getOut().write(sb.toString());
        }
        catch (IOException e) {
            throw new JspTagException("IO Error: " + e.getMessage());
        }
        return 1;
    }

    @Override
    public int doEndTag() throws JspTagException {
        TabbedSectionTag parent = (TabbedSectionTag)TabTag.findAncestorWithClass((Tag)this, TabbedSectionTag.class);
        StringBuilder sb = new StringBuilder();
        if (parent.isStateFindDefaultTab()) {
            parent.validateDefaultTab(this.getId());
        } else if (parent.isStateGenerateTabBody()) {
            sb.append("</div>\n");
        } else if (parent.isStateGenerateTabMenu()) {
            sb.append("<a");
            if (parent.validateDefaultTab(this.getId())) {
                sb.append(" class=\"activetab\"");
            }
            sb.append(" id=\"menu-").append(this.getId()).append("\"");
            if (this.m_url != null) {
                sb.append(" href='").append(this.m_url).append("'");
            }
            if (this.handleAccesskey()) {
                sb.append(" accesskey=\"").append(this.m_accesskey).append("\"");
            }
            sb.append(" >");
            sb.append(this.m_tabTitle);
            sb.append("</a>");
        }
        try {
            this.pageContext.getOut().write(sb.toString());
        }
        catch (IOException e) {
            throw new JspTagException("IO Error: " + e.getMessage());
        }
        return 6;
    }
}

