/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.tags.WikiLinkTag;

public class DiffLinkTag
extends WikiLinkTag {
    private static final long serialVersionUID = 0L;
    public static final String VER_LATEST = "latest";
    public static final String VER_PREVIOUS = "previous";
    public static final String VER_CURRENT = "current";
    private String m_version = "latest";
    private String m_newVersion = "latest";

    @Override
    public void initTag() {
        super.initTag();
        this.m_newVersion = VER_LATEST;
        this.m_version = VER_LATEST;
    }

    public final String getVersion() {
        return this.m_version;
    }

    public void setVersion(String arg) {
        this.m_version = arg;
    }

    public final String getNewVersion() {
        return this.m_newVersion;
    }

    public void setNewVersion(String arg) {
        this.m_newVersion = arg;
    }

    @Override
    public final int doWikiStartTag() throws IOException {
        int r2;
        int r1;
        Page latest;
        Engine engine = this.m_wikiContext.getEngine();
        String pageName = this.m_pageName;
        if (this.m_pageName == null) {
            if (this.m_wikiContext.getPage() != null) {
                pageName = this.m_wikiContext.getPage().getName();
            } else {
                return 0;
            }
        }
        JspWriter out = this.pageContext.getOut();
        if (!((PageManager)engine.getManager(PageManager.class)).wikiPageExists(pageName)) {
            return 0;
        }
        if (VER_LATEST.equals(this.getVersion())) {
            latest = ((PageManager)engine.getManager(PageManager.class)).getPage(pageName, -1);
            if (latest == null) {
                return 0;
            }
            r1 = latest.getVersion();
        } else if (VER_PREVIOUS.equals(this.getVersion())) {
            r1 = this.m_wikiContext.getPage().getVersion() - 1;
            r1 = Math.max(r1, 1);
        } else {
            r1 = VER_CURRENT.equals(this.getVersion()) ? this.m_wikiContext.getPage().getVersion() : Integer.parseInt(this.getVersion());
        }
        if (VER_LATEST.equals(this.getNewVersion())) {
            latest = ((PageManager)engine.getManager(PageManager.class)).getPage(pageName, -1);
            r2 = latest.getVersion();
        } else if (VER_PREVIOUS.equals(this.getNewVersion())) {
            r2 = this.m_wikiContext.getPage().getVersion() - 1;
            r2 = Math.max(r2, 1);
        } else {
            r2 = VER_CURRENT.equals(this.getNewVersion()) ? this.m_wikiContext.getPage().getVersion() : Integer.parseInt(this.getNewVersion());
        }
        String url = this.m_wikiContext.getURL(ContextEnum.PAGE_DIFF.getRequestContext(), pageName, "r1=" + r1 + "&amp;r2=" + r2);
        switch (this.m_format) {
            case 0: {
                out.print("<a href=\"" + url + "\">");
                break;
            }
            case 1: {
                out.print(url);
            }
        }
        return 1;
    }
}

