/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WatchDog;
import org.apache.wiki.WikiBackgroundThread;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.search.SearchResult;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.search.SearchProvider;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.TextUtil;

public class LuceneSearchProvider
implements SearchProvider {
    protected static final Logger log = LogManager.getLogger(LuceneSearchProvider.class);
    private Engine m_engine;
    private Executor searchExecutor;
    public static final String PROP_LUCENE_ANALYZER = "jspwiki.lucene.analyzer";
    private static final String PROP_LUCENE_INDEXDELAY = "jspwiki.lucene.indexdelay";
    private static final String PROP_LUCENE_INITIALDELAY = "jspwiki.lucene.initialdelay";
    private String m_analyzerClass = "org.apache.lucene.analysis.standard.ClassicAnalyzer";
    private static final String LUCENE_DIR = "lucene";
    public static final String[] SEARCHABLE_FILE_SUFFIXES = new String[]{".txt", ".ini", ".xml", ".html", "htm", ".mm", ".htm", ".xhtml", ".java", ".c", ".cpp", ".php", ".asm", ".sh", ".properties", ".kml", ".gpx", ".loc", ".md", ".xml"};
    protected static final String LUCENE_ID = "id";
    protected static final String LUCENE_PAGE_CONTENTS = "contents";
    protected static final String LUCENE_AUTHOR = "author";
    protected static final String LUCENE_ATTACHMENTS = "attachment";
    protected static final String LUCENE_PAGE_NAME = "name";
    protected static final String LUCENE_PAGE_KEYWORDS = "keywords";
    private String m_luceneDirectory;
    protected final List<Object[]> m_updates = Collections.synchronizedList(new ArrayList());
    private static final int MAX_FRAGMENTS = 3;
    public static final int MAX_SEARCH_HITS = 99999;
    private static final String PUNCTUATION_TO_SPACES = StringUtils.repeat((String)" ", (int)" ()&+,-=._$".length());
    public static final int FLAG_CONTEXTS = 1;

    public void initialize(Engine engine, Properties props) throws NoRequiredPropertyException, IOException {
        this.m_engine = engine;
        this.searchExecutor = Executors.newCachedThreadPool();
        this.m_luceneDirectory = engine.getWorkDir() + File.separator + LUCENE_DIR;
        int initialDelay = TextUtil.getIntegerProperty((Properties)props, (String)PROP_LUCENE_INITIALDELAY, (int)60);
        int indexDelay = TextUtil.getIntegerProperty((Properties)props, (String)PROP_LUCENE_INDEXDELAY, (int)5);
        this.m_analyzerClass = TextUtil.getStringProperty((Properties)props, (String)PROP_LUCENE_ANALYZER, (String)this.m_analyzerClass);
        File dir = new File(this.m_luceneDirectory);
        log.info("Lucene enabled, cache will be in: " + dir.getAbsolutePath());
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(dir.exists() && dir.canWrite() && dir.canRead())) {
                log.error("Cannot write to Lucene directory, disabling Lucene: " + dir.getAbsolutePath());
                throw new IOException("Invalid Lucene directory.");
            }
            String[] filelist = dir.list();
            if (filelist == null) {
                throw new IOException("Invalid Lucene directory: cannot produce listing: " + dir.getAbsolutePath());
            }
        }
        catch (IOException e) {
            log.error("Problem while creating Lucene index - not using Lucene.", (Throwable)e);
        }
        LuceneUpdater updater = new LuceneUpdater(this.m_engine, this, initialDelay, indexDelay);
        updater.start();
    }

    protected Engine getEngine() {
        return this.m_engine;
    }

    protected void doFullLuceneReindex() throws IOException {
        block25: {
            File dir = new File(this.m_luceneDirectory);
            String[] filelist = dir.list();
            if (filelist == null) {
                throw new IOException("Invalid Lucene directory: cannot produce listing: " + dir.getAbsolutePath());
            }
            try {
                if (filelist.length == 0) {
                    Date start = new Date();
                    log.info("Starting Lucene reindexing, this can take a couple of minutes...");
                    NIOFSDirectory luceneDir = new NIOFSDirectory(dir.toPath());
                    try (IndexWriter writer = this.getIndexWriter((Directory)luceneDir);){
                        Collection<Page> allPages = ((PageManager)this.m_engine.getManager(PageManager.class)).getAllPages();
                        for (Page page : allPages) {
                            try {
                                String text = ((PageManager)this.m_engine.getManager(PageManager.class)).getPageText(page.getName(), -1);
                                this.luceneIndexPage(page, text, writer);
                            }
                            catch (IOException e) {
                                log.warn("Unable to index page " + page.getName() + ", continuing to next ", (Throwable)e);
                            }
                        }
                        Collection<Attachment> allAttachments = ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).getAllAttachments();
                        for (Attachment att : allAttachments) {
                            try {
                                String text = this.getAttachmentContent(att.getName(), -1);
                                this.luceneIndexPage((Page)att, text, writer);
                            }
                            catch (IOException e) {
                                log.warn("Unable to index attachment " + att.getName() + ", continuing to next", (Throwable)e);
                            }
                        }
                    }
                    Date end = new Date();
                    log.info("Full Lucene index finished in " + (end.getTime() - start.getTime()) + " milliseconds.");
                    break block25;
                }
                log.info("Files found in Lucene directory, not reindexing.");
            }
            catch (IOException e) {
                log.error("Problem while creating Lucene index - not using Lucene.", (Throwable)e);
            }
            catch (ProviderException e) {
                log.error("Problem reading pages while creating Lucene index (JSPWiki won't start.)", (Throwable)e);
                throw new IllegalArgumentException("unable to create Lucene index");
            }
            catch (Exception e) {
                log.error("Unable to start lucene", (Throwable)e);
            }
        }
    }

    protected String getAttachmentContent(String attachmentName, int version) {
        AttachmentManager mgr = (AttachmentManager)this.m_engine.getManager(AttachmentManager.class);
        try {
            Attachment att = mgr.getAttachmentInfo(attachmentName, version);
            if (att != null) {
                return this.getAttachmentContent(att);
            }
        }
        catch (ProviderException e) {
            log.error("Attachment cannot be loaded", (Throwable)e);
        }
        return null;
    }

    protected String getAttachmentContent(Attachment att) {
        AttachmentManager mgr = (AttachmentManager)this.m_engine.getManager(AttachmentManager.class);
        String filename = att.getFileName();
        boolean searchSuffix = false;
        for (String suffix : SEARCHABLE_FILE_SUFFIXES) {
            if (!filename.endsWith(suffix)) continue;
            searchSuffix = true;
            break;
        }
        String out = filename;
        if (searchSuffix) {
            try (InputStream attStream = mgr.getAttachmentStream(att);
                 StringWriter sout = new StringWriter();){
                FileUtil.copyContents((Reader)new InputStreamReader(attStream), (Writer)sout);
                out = out + " " + sout;
            }
            catch (IOException | ProviderException e) {
                log.error("Attachment cannot be loaded", e);
            }
        }
        return out;
    }

    protected synchronized void updateLuceneIndex(Page page, String text) {
        log.debug("Updating Lucene index for page '" + page.getName() + "'...");
        this.pageRemoved(page);
        try (NIOFSDirectory luceneDir = new NIOFSDirectory(new File(this.m_luceneDirectory).toPath());
             IndexWriter writer = this.getIndexWriter((Directory)luceneDir);){
            this.luceneIndexPage(page, text, writer);
        }
        catch (IOException e) {
            log.error("Unable to update page '" + page.getName() + "' from Lucene index", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Unexpected Lucene exception - please check configuration!", (Throwable)e);
        }
        log.debug("Done updating Lucene index for page '" + page.getName() + "'.");
    }

    private Analyzer getLuceneAnalyzer() throws ProviderException {
        try {
            Class clazz = ClassUtil.findClass((String)"", (String)this.m_analyzerClass);
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return (Analyzer)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            String msg = "Could not get LuceneAnalyzer class " + this.m_analyzerClass + ", reason: ";
            log.error(msg, (Throwable)e);
            throw new ProviderException(msg + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document luceneIndexPage(Page page, String text, IndexWriter writer) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Indexing " + page.getName() + "...");
        }
        Document doc = new Document();
        if (text == null) {
            return doc;
        }
        String indexedText = text.replace("__", " ");
        Field field = new Field(LUCENE_ID, (CharSequence)page.getName(), (IndexableFieldType)StringField.TYPE_STORED);
        doc.add((IndexableField)field);
        field = new Field(LUCENE_PAGE_CONTENTS, (CharSequence)indexedText, (IndexableFieldType)TextField.TYPE_STORED);
        doc.add((IndexableField)field);
        String unTokenizedTitle = StringUtils.replaceChars((String)page.getName(), (String)" ()&+,-=._$", (String)PUNCTUATION_TO_SPACES);
        field = new Field(LUCENE_PAGE_NAME, (CharSequence)(TextUtil.beautifyString((String)page.getName()) + " " + unTokenizedTitle), (IndexableFieldType)TextField.TYPE_STORED);
        doc.add((IndexableField)field);
        if (page.getAuthor() != null) {
            field = new Field(LUCENE_AUTHOR, (CharSequence)page.getAuthor(), (IndexableFieldType)TextField.TYPE_STORED);
            doc.add((IndexableField)field);
        }
        try {
            List<Attachment> attachments = ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).listAttachments(page);
            StringBuilder attachmentNames = new StringBuilder();
            for (Attachment att : attachments) {
                attachmentNames.append(att.getName()).append(";");
            }
            field = new Field(LUCENE_ATTACHMENTS, (CharSequence)attachmentNames.toString(), (IndexableFieldType)TextField.TYPE_STORED);
            doc.add((IndexableField)field);
        }
        catch (ProviderException e) {
            log.error("Failed to get attachments for page", (Throwable)e);
        }
        if (page.getAttribute(LUCENE_PAGE_KEYWORDS) != null) {
            field = new Field(LUCENE_PAGE_KEYWORDS, (CharSequence)page.getAttribute(LUCENE_PAGE_KEYWORDS).toString(), (IndexableFieldType)TextField.TYPE_STORED);
            doc.add((IndexableField)field);
        }
        IndexWriter indexWriter = writer;
        synchronized (indexWriter) {
            writer.addDocument((Iterable)doc);
        }
        return doc;
    }

    @Override
    public synchronized void pageRemoved(Page page) {
        try (NIOFSDirectory luceneDir = new NIOFSDirectory(new File(this.m_luceneDirectory).toPath());
             IndexWriter writer = this.getIndexWriter((Directory)luceneDir);){
            TermQuery query = new TermQuery(new Term(LUCENE_ID, page.getName()));
            writer.deleteDocuments(new Query[]{query});
        }
        catch (Exception e) {
            log.error("Unable to remove page '" + page.getName() + "' from Lucene index", (Throwable)e);
        }
    }

    IndexWriter getIndexWriter(Directory luceneDir) throws IOException, ProviderException {
        IndexWriterConfig writerConfig = new IndexWriterConfig(this.getLuceneAnalyzer());
        writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        return new IndexWriter(luceneDir, writerConfig);
    }

    @Override
    public void reindexPage(Page page) {
        String text;
        if (page != null && (text = page instanceof Attachment ? this.getAttachmentContent((Attachment)page) : ((PageManager)this.m_engine.getManager(PageManager.class)).getPureText(page)) != null) {
            Object[] pair = new Object[]{page, text};
            this.m_updates.add(pair);
            log.debug("Scheduling page " + page.getName() + " for index update");
        }
    }

    @Override
    public Collection<SearchResult> findPages(String query, Context wikiContext) throws ProviderException {
        return this.findPages(query, 1, wikiContext);
    }

    public Collection<SearchResult> findPages(String query, int flags, Context wikiContext) throws ProviderException {
        ArrayList<SearchResultImpl> list = null;
        Highlighter highlighter = null;
        try (NIOFSDirectory luceneDir = new NIOFSDirectory(new File(this.m_luceneDirectory).toPath());
             DirectoryReader reader = DirectoryReader.open((Directory)luceneDir);){
            String[] queryfields = new String[]{LUCENE_PAGE_CONTENTS, LUCENE_PAGE_NAME, LUCENE_AUTHOR, LUCENE_ATTACHMENTS, LUCENE_PAGE_KEYWORDS};
            MultiFieldQueryParser qp = new MultiFieldQueryParser(queryfields, this.getLuceneAnalyzer());
            Query luceneQuery = qp.parse(query);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader, this.searchExecutor);
            if ((flags & 1) != 0) {
                highlighter = new Highlighter((Formatter)new SimpleHTMLFormatter("<span class=\"searchmatch\">", "</span>"), (Encoder)new SimpleHTMLEncoder(), (Scorer)new QueryScorer(luceneQuery));
            }
            ScoreDoc[] hits = searcher.search((Query)luceneQuery, (int)99999).scoreDocs;
            AuthorizationManager mgr = (AuthorizationManager)this.m_engine.getManager(AuthorizationManager.class);
            list = new ArrayList<SearchResultImpl>(hits.length);
            for (ScoreDoc hit : hits) {
                int docID = hit.doc;
                Document doc = searcher.doc(docID);
                String pageName = doc.get(LUCENE_ID);
                Page page = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pageName, -1);
                if (page != null) {
                    PagePermission pp = new PagePermission(page, "view");
                    if (!mgr.checkPermission(wikiContext.getWikiSession(), pp)) continue;
                    int score = (int)(hit.score * 100.0f);
                    String text = doc.get(LUCENE_PAGE_CONTENTS);
                    String[] fragments = new String[]{};
                    if (text != null && highlighter != null) {
                        TokenStream tokenStream = this.getLuceneAnalyzer().tokenStream(LUCENE_PAGE_CONTENTS, (Reader)new StringReader(text));
                        fragments = highlighter.getBestFragments(tokenStream, text, 3);
                    }
                    SearchResultImpl result = new SearchResultImpl(page, score, fragments);
                    list.add(result);
                    continue;
                }
                log.error("Lucene found a result page '" + pageName + "' that could not be loaded, removing from Lucene cache");
                this.pageRemoved(Wiki.contents().page(this.m_engine, pageName));
            }
        }
        catch (IOException e) {
            log.error("Failed during lucene search", (Throwable)e);
        }
        catch (ParseException e) {
            log.info("Broken query; cannot parse query: " + query, (Throwable)e);
            throw new ProviderException("You have entered a query Lucene cannot process [" + query + "]: " + e.getMessage());
        }
        catch (InvalidTokenOffsetsException e) {
            log.error("Tokens are incompatible with provided text ", (Throwable)e);
        }
        return list;
    }

    public String getProviderInfo() {
        return "LuceneSearchProvider";
    }

    private static class SearchResultImpl
    implements SearchResult {
        private final Page m_page;
        private final int m_score;
        private final String[] m_contexts;

        public SearchResultImpl(Page page, int score, String[] contexts) {
            this.m_page = page;
            this.m_score = score;
            this.m_contexts = contexts != null ? (String[])contexts.clone() : null;
        }

        public Page getPage() {
            return this.m_page;
        }

        public int getScore() {
            return this.m_score;
        }

        public String[] getContexts() {
            return this.m_contexts;
        }
    }

    private static final class LuceneUpdater
    extends WikiBackgroundThread {
        static final int INDEX_DELAY = 5;
        static final int INITIAL_DELAY = 60;
        private final LuceneSearchProvider m_provider;
        private final int m_initialDelay;
        private WatchDog m_watchdog;

        private LuceneUpdater(Engine engine, LuceneSearchProvider provider, int initialDelay, int indexDelay) {
            super(engine, indexDelay);
            this.m_provider = provider;
            this.m_initialDelay = initialDelay;
            this.setName("JSPWiki Lucene Indexer");
        }

        @Override
        public void startupTask() throws Exception {
            this.m_watchdog = WatchDog.getCurrentWatchDog(this.getEngine());
            try {
                Thread.sleep((long)this.m_initialDelay * 1000L);
            }
            catch (InterruptedException e) {
                throw new InternalWikiException("Interrupted while waiting to start.", e);
            }
            this.m_watchdog.enterState("Full reindex");
            this.m_provider.doFullLuceneReindex();
            this.m_watchdog.exitState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void backgroundTask() {
            this.m_watchdog.enterState("Emptying index queue", 60);
            List<Object[]> list = this.m_provider.m_updates;
            synchronized (list) {
                while (this.m_provider.m_updates.size() > 0) {
                    Object[] pair = this.m_provider.m_updates.remove(0);
                    Page page = (Page)pair[0];
                    String text = (String)pair[1];
                    this.m_provider.updateLuceneIndex(page, text);
                }
            }
            this.m_watchdog.exitState();
        }
    }
}

