/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rss;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.diff.DifferenceManager;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.pages.PageTimeComparator;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.rss.AtomFeed;
import org.apache.wiki.rss.Entry;
import org.apache.wiki.rss.Feed;
import org.apache.wiki.rss.RSS10Feed;
import org.apache.wiki.rss.RSS20Feed;
import org.apache.wiki.rss.RSSGenerator;
import org.apache.wiki.rss.RSSThread;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.variables.VariableManager;

public class DefaultRSSGenerator
implements RSSGenerator {
    private static final Logger log = LogManager.getLogger(DefaultRSSGenerator.class);
    private final Engine m_engine;
    private final String m_rssFile;
    private String m_channelDescription = "";
    private String m_channelLanguage = "en-us";
    private boolean m_enabled = true;
    private static final int MAX_CHARACTERS = 0x7FFFFFFE;

    public DefaultRSSGenerator(Engine engine, Properties properties) {
        this.m_engine = engine;
        this.m_channelDescription = properties.getProperty("jspwiki.rss.channelDescription", this.m_channelDescription);
        this.m_channelLanguage = properties.getProperty("jspwiki.rss.channelLanguage", this.m_channelLanguage);
        this.m_rssFile = TextUtil.getStringProperty((Properties)properties, (String)"jspwiki.rss.fileName", (String)"rss.rdf");
    }

    public void initialize(Engine engine, Properties properties) {
        File rssFile = this.m_rssFile.startsWith(File.separator) ? new File(this.m_rssFile) : new File(engine.getRootPath(), this.m_rssFile);
        int rssInterval = TextUtil.getIntegerProperty((Properties)properties, (String)"jspwiki.rss.interval", (int)3600);
        RSSThread rssThread = new RSSThread(engine, rssFile, rssInterval);
        rssThread.start();
    }

    private String getAuthor(Page page) {
        String author = page.getAuthor();
        if (author == null) {
            author = "An unknown author";
        }
        return author;
    }

    private String getAttachmentDescription(Attachment att) {
        String author = this.getAuthor((Page)att);
        StringBuilder sb = new StringBuilder();
        if (att.getVersion() != 1) {
            sb.append(author).append(" uploaded a new version of this attachment on ").append(att.getLastModified());
        } else {
            sb.append(author).append(" created this attachment on ").append(att.getLastModified());
        }
        sb.append("<br /><hr /><br />").append("Parent page: <a href=\"").append(this.m_engine.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), att.getParentName(), null)).append("\">").append(att.getParentName()).append("</a><br />").append("Info page: <a href=\"").append(this.m_engine.getURL(ContextEnum.PAGE_INFO.getRequestContext(), att.getName(), null)).append("\">").append(att.getName()).append("</a>");
        return sb.toString();
    }

    private String getPageDescription(Page page) {
        StringBuilder buf = new StringBuilder();
        String author = this.getAuthor(page);
        Context ctx = Wiki.context().create(this.m_engine, page);
        if (page.getVersion() > 1) {
            String diff = ((DifferenceManager)this.m_engine.getManager(DifferenceManager.class)).getDiff(ctx, page.getVersion() - 1, page.getVersion());
            buf.append(author).append(" changed this page on ").append(page.getLastModified()).append(":<br /><hr /><br />");
            buf.append(diff);
        } else {
            buf.append(author).append(" created this page on ").append(page.getLastModified()).append(":<br /><hr /><br />");
            buf.append(((RenderingManager)this.m_engine.getManager(RenderingManager.class)).getHTML(page.getName()));
        }
        return buf.toString();
    }

    private String getEntryDescription(Page page) {
        String res = page instanceof Attachment ? this.getAttachmentDescription((Attachment)page) : this.getPageDescription(page);
        return res;
    }

    private String getEntryTitle(Page page) {
        return page.getName() + ", version " + page.getVersion();
    }

    @Override
    public String generate() {
        Context context = Wiki.context().create(this.m_engine, Wiki.contents().page(this.m_engine, "__DUMMY"));
        context.setRequestContext(ContextEnum.PAGE_RSS.getRequestContext());
        RSS10Feed feed = new RSS10Feed(context);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + this.generateFullWikiRSS(context, feed);
    }

    @Override
    public String generateFeed(Context wikiContext, List<Page> changed, String mode, String type) throws IllegalArgumentException {
        String res;
        Feed feed = "atom".equals(type) ? new AtomFeed(wikiContext) : ("rss20".equals(type) ? new RSS20Feed(wikiContext) : new RSS10Feed(wikiContext));
        feed.setMode(mode);
        if ("blog".equals(mode)) {
            res = this.generateBlogRSS(wikiContext, changed, feed);
        } else if ("full".equals(mode)) {
            res = this.generateFullWikiRSS(wikiContext, feed);
        } else if ("wiki".equals(mode)) {
            res = this.generateWikiPageRSS(wikiContext, changed, feed);
        } else {
            throw new IllegalArgumentException("Invalid value for feed mode: " + mode);
        }
        return res;
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public synchronized void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    @Override
    public String getRssFile() {
        return this.m_rssFile;
    }

    @Override
    public String generateFullWikiRSS(Context wikiContext, Feed feed) {
        feed.setChannelTitle(this.m_engine.getApplicationName());
        feed.setFeedURL(this.m_engine.getBaseURL());
        feed.setChannelLanguage(this.m_channelLanguage);
        feed.setChannelDescription(this.m_channelDescription);
        Set<Page> changed = ((PageManager)this.m_engine.getManager(PageManager.class)).getRecentChanges();
        Session session = Wiki.session().guest(this.m_engine);
        Iterator<Page> i = changed.iterator();
        for (int items = 0; i.hasNext() && items < 15; ++items) {
            Page page = i.next();
            if (!((AuthorizationManager)this.m_engine.getManager(AuthorizationManager.class)).checkPermission(session, new PagePermission(page, "view"))) continue;
            String url = page instanceof Attachment ? this.m_engine.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), page.getName(), null) : this.m_engine.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), page.getName(), null);
            Entry e = new Entry();
            e.setPage(page);
            e.setURL(url);
            e.setTitle(page.getName());
            e.setContent(this.getEntryDescription(page));
            e.setAuthor(this.getAuthor(page));
            feed.addEntry(e);
        }
        return feed.getString();
    }

    @Override
    public String generateWikiPageRSS(Context wikiContext, List<Page> changed, Feed feed) {
        feed.setChannelTitle(this.m_engine.getApplicationName() + ": " + wikiContext.getPage().getName());
        feed.setFeedURL(wikiContext.getViewURL(wikiContext.getPage().getName()));
        String language = ((VariableManager)this.m_engine.getManager(VariableManager.class)).getVariable(wikiContext, "jspwiki.rss.channelLanguage");
        if (language != null) {
            feed.setChannelLanguage(language);
        } else {
            feed.setChannelLanguage(this.m_channelLanguage);
        }
        String channelDescription = ((VariableManager)this.m_engine.getManager(VariableManager.class)).getVariable(wikiContext, "jspwiki.rss.channelDescription");
        if (channelDescription != null) {
            feed.setChannelDescription(channelDescription);
        }
        changed.sort(new PageTimeComparator());
        Iterator<Page> i = changed.iterator();
        for (int items = 0; i.hasNext() && items < 15; ++items) {
            Page page = i.next();
            Entry e = new Entry();
            e.setPage(page);
            String url = page instanceof Attachment ? this.m_engine.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), page.getName(), "version=" + page.getVersion()) : this.m_engine.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), page.getName(), "version=" + page.getVersion());
            url = TextUtil.replaceString((String)url, (String)"&amp;", (String)"&");
            e.setURL(url);
            e.setTitle(this.getEntryTitle(page));
            e.setContent(this.getEntryDescription(page));
            e.setAuthor(this.getAuthor(page));
            feed.addEntry(e);
        }
        return feed.getString();
    }

    @Override
    public String generateBlogRSS(Context wikiContext, List<Page> changed, Feed feed) {
        String ctitle;
        if (log.isDebugEnabled()) {
            log.debug("Generating RSS for blog, size=" + changed.size());
        }
        if ((ctitle = ((VariableManager)this.m_engine.getManager(VariableManager.class)).getVariable(wikiContext, "jspwiki.rss.channelTitle")) != null) {
            feed.setChannelTitle(ctitle);
        } else {
            feed.setChannelTitle(this.m_engine.getApplicationName() + ":" + wikiContext.getPage().getName());
        }
        feed.setFeedURL(wikiContext.getViewURL(wikiContext.getPage().getName()));
        String language = ((VariableManager)this.m_engine.getManager(VariableManager.class)).getVariable(wikiContext, "jspwiki.rss.channelLanguage");
        if (language != null) {
            feed.setChannelLanguage(language);
        } else {
            feed.setChannelLanguage(this.m_channelLanguage);
        }
        String channelDescription = ((VariableManager)this.m_engine.getManager(VariableManager.class)).getVariable(wikiContext, "jspwiki.rss.channelDescription");
        if (channelDescription != null) {
            feed.setChannelDescription(channelDescription);
        }
        changed.sort(new PageTimeComparator());
        Iterator<Page> i = changed.iterator();
        for (int items = 0; i.hasNext() && items < 15; ++items) {
            Page page = i.next();
            Entry e = new Entry();
            e.setPage(page);
            String url = page instanceof Attachment ? this.m_engine.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), page.getName(), null) : this.m_engine.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), page.getName(), null);
            e.setURL(url);
            String pageText = ((PageManager)this.m_engine.getManager(PageManager.class)).getPureText(page.getName(), -1);
            String title = "";
            int firstLine = pageText.indexOf(10);
            if (firstLine > 0) {
                title = pageText.substring(0, firstLine).trim();
            }
            if (title.isEmpty()) {
                title = page.getName();
            }
            while (title.startsWith("!")) {
                title = title.substring(1);
            }
            e.setTitle(title);
            if (firstLine > 0) {
                int maxlen = pageText.length();
                if (maxlen > 0x7FFFFFFE) {
                    maxlen = 0x7FFFFFFE;
                }
                pageText = ((RenderingManager)this.m_engine.getManager(RenderingManager.class)).textToHTML(wikiContext, pageText.substring(firstLine + 1, maxlen).trim());
                if (maxlen == 0x7FFFFFFE) {
                    pageText = pageText + "...";
                }
                e.setContent(pageText);
            } else {
                e.setContent(title);
            }
            e.setAuthor(this.getAuthor(page));
            feed.addEntry(e);
        }
        return feed.getString();
    }
}

