/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.pages.PageLock;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.plugin.WeblogPlugin;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.TextUtil;

public class WeblogEntryPlugin
implements Plugin {
    private static final Logger log = LogManager.getLogger(WeblogEntryPlugin.class);
    private static final int MAX_BLOG_ENTRIES = 10000;
    public static final String PARAM_ENTRYTEXT = "entrytext";
    public static final String PARAM_BLOGNAME = "page";

    public String getNewEntryPage(Engine engine, String blogName) throws ProviderException {
        SimpleDateFormat fmt = new SimpleDateFormat("ddMMyy");
        String today = fmt.format(new Date());
        int entryNum = this.findFreeEntry(engine, blogName, today);
        return WeblogPlugin.makeEntryPage(blogName, today, "" + entryNum);
    }

    public String execute(Context context, Map<String, String> params) throws PluginException {
        String entryText;
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        Engine engine = context.getEngine();
        String weblogName = params.get(PARAM_BLOGNAME);
        if (weblogName == null) {
            weblogName = context.getPage().getName();
        }
        if ((entryText = TextUtil.replaceEntities((String)params.get(PARAM_ENTRYTEXT))) == null) {
            entryText = rb.getString("weblogentryplugin.newentry");
        }
        String url = context.getURL(ContextEnum.PAGE_NONE.getRequestContext(), "NewBlogEntry.jsp", "page=" + engine.encodeName(weblogName));
        return "<a href=\"" + url + "\">" + entryText + "</a>";
    }

    private int findFreeEntry(Engine engine, String baseName, String date) throws ProviderException {
        int idx;
        Collection<Page> everyone = ((PageManager)engine.getManager(PageManager.class)).getAllPages();
        String startString = WeblogPlugin.makeEntryPage(baseName, date, "");
        int max = 0;
        for (Page p : everyone) {
            if (!p.getName().startsWith(startString)) continue;
            try {
                String probableId = p.getName().substring(startString.length());
                int id = Integer.parseInt(probableId);
                if (id <= max) continue;
                max = id;
            }
            catch (NumberFormatException e) {
                log.debug("Was not a log entry: " + p.getName());
            }
        }
        for (idx = max + 1; idx < 10000; ++idx) {
            Page page = Wiki.contents().page(engine, WeblogPlugin.makeEntryPage(baseName, date, Integer.toString(idx)));
            PageLock lock = ((PageManager)engine.getManager(PageManager.class)).getCurrentLock(page);
            if (lock == null) break;
        }
        return idx;
    }
}

