/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.ajax.WikiAjaxDispatcherServlet;
import org.apache.wiki.ajax.WikiAjaxServlet;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.InitializablePlugin;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.modules.BaseModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.plugin.PluginManager;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.XHTML;
import org.apache.wiki.util.XhtmlUtil;
import org.apache.wiki.util.XmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class DefaultPluginManager
extends BaseModuleManager
implements PluginManager {
    private static final String PLUGIN_INSERT_PATTERN = "\\{?(INSERT)?\\s*([\\w\\._]+)[ \\t]*(WHERE)?[ \\t]*";
    private static final Logger log = LogManager.getLogger(DefaultPluginManager.class);
    private static final String DEFAULT_FORMS_PACKAGE = "org.apache.wiki.forms";
    private final ArrayList<String> m_searchPath = new ArrayList();
    private final ArrayList<String> m_externalJars = new ArrayList();
    private final Pattern m_pluginPattern;
    private boolean m_pluginsEnabled = true;
    private final Map<String, WikiPluginInfo> m_pluginClassMap = new HashMap<String, WikiPluginInfo>();

    public DefaultPluginManager(Engine engine, Properties props) {
        super(engine);
        String externalJars;
        String packageNames = props.getProperty("jspwiki.plugin.searchPath");
        if (packageNames != null) {
            StringTokenizer tok = new StringTokenizer(packageNames, ",");
            while (tok.hasMoreTokens()) {
                this.m_searchPath.add(tok.nextToken().trim());
            }
        }
        if ((externalJars = props.getProperty("jspwiki.plugin.externalJars")) != null) {
            StringTokenizer tok = new StringTokenizer(externalJars, ",");
            while (tok.hasMoreTokens()) {
                this.m_externalJars.add(tok.nextToken().trim());
            }
        }
        this.registerPlugins();
        this.m_searchPath.add("org.apache.wiki.plugin");
        this.m_searchPath.add(DEFAULT_FORMS_PACKAGE);
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.m_pluginPattern = compiler.compile(PLUGIN_INSERT_PATTERN);
        }
        catch (MalformedPatternException e) {
            log.fatal("Internal error: someone messed with pluginmanager patterns.", (Throwable)e);
            throw new InternalWikiException("PluginManager patterns are broken", e);
        }
    }

    @Override
    public void enablePlugins(boolean enabled) {
        this.m_pluginsEnabled = enabled;
    }

    @Override
    public boolean pluginsEnabled() {
        return this.m_pluginsEnabled;
    }

    @Override
    public Pattern getPluginPattern() {
        return this.m_pluginPattern;
    }

    private Class<?> findPluginClass(String classname) throws ClassNotFoundException {
        return ClassUtil.findClass(this.m_searchPath, this.m_externalJars, (String)classname);
    }

    private String stackTrace(Map<String, String> params, Throwable t) {
        Element div = XhtmlUtil.element((XHTML)XHTML.div, (String)"Plugin execution failed, stack trace follows:");
        div.setAttribute("class", "debug");
        StringWriter out = new StringWriter();
        t.printStackTrace(new PrintWriter(out));
        div.addContent((Content)XhtmlUtil.element((XHTML)XHTML.pre, (String)out.toString()));
        div.addContent((Content)XhtmlUtil.element((XHTML)XHTML.b, (String)"Parameters to the plugin"));
        Element list = XhtmlUtil.element((XHTML)XHTML.ul);
        for (Map.Entry<String, String> e : params.entrySet()) {
            String key = e.getKey();
            list.addContent((Content)XhtmlUtil.element((XHTML)XHTML.li, (String)(key + "'='" + e.getValue())));
        }
        div.addContent((Content)list);
        return XhtmlUtil.serialize((Element)div);
    }

    @Override
    public String execute(Context context, String classname, Map<String, String> params) throws PluginException {
        if (!this.m_pluginsEnabled) {
            return "";
        }
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        boolean debug = TextUtil.isPositive((String)params.get("debug"));
        try {
            Plugin plugin = this.newWikiPlugin(classname, rb);
            if (plugin == null) {
                return "Plugin '" + classname + "' not compatible with this version of JSPWiki";
            }
            try {
                return plugin.execute(context, params);
            }
            catch (PluginException e) {
                if (debug) {
                    return this.stackTrace(params, e);
                }
                throw (PluginException)e.fillInStackTrace();
            }
            catch (Throwable t) {
                log.info("Plugin failed while executing:", t);
                if (debug) {
                    return this.stackTrace(params, t);
                }
                throw new PluginException(rb.getString("plugin.error.failed"), t);
            }
        }
        catch (ClassCastException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.notawikiplugin"), classname), (Throwable)e);
        }
    }

    @Override
    public Map<String, String> parseArgs(String argstring) throws IOException {
        HashMap<String, String> arglist = new HashMap<String, String>();
        if (argstring == null) {
            return arglist;
        }
        arglist.put("_cmdline", argstring);
        StringReader in = new StringReader(argstring);
        StreamTokenizer tok = new StreamTokenizer(in);
        tok.eolIsSignificant(true);
        String param = null;
        boolean potentialEmptyLine = false;
        boolean quit = false;
        while (!quit) {
            String s;
            int type = tok.nextToken();
            switch (type) {
                case -1: {
                    quit = true;
                    s = null;
                    break;
                }
                case -3: {
                    s = tok.sval;
                    potentialEmptyLine = false;
                    break;
                }
                case 10: {
                    quit = potentialEmptyLine;
                    potentialEmptyLine = true;
                    s = null;
                    break;
                }
                case -2: {
                    s = Integer.toString((int)tok.nval);
                    potentialEmptyLine = false;
                    break;
                }
                case 39: {
                    s = tok.sval;
                    break;
                }
                default: {
                    s = null;
                }
            }
            if (s == null) continue;
            if (param == null) {
                param = s;
                continue;
            }
            String value = s;
            arglist.put(param, value);
            param = null;
        }
        if (potentialEmptyLine) {
            StringWriter out = new StringWriter();
            FileUtil.copyContents((Reader)in, (Writer)out);
            String bodyContent = out.toString();
            if (bodyContent != null) {
                arglist.put("_body", bodyContent);
            }
        }
        return arglist;
    }

    @Override
    public String execute(Context context, String commandline) throws PluginException {
        if (!this.m_pluginsEnabled) {
            return "";
        }
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        Perl5Matcher matcher = new Perl5Matcher();
        try {
            if (matcher.contains(commandline, this.m_pluginPattern)) {
                MatchResult res = matcher.getMatch();
                String plugin = res.group(2);
                int endIndex = commandline.length() - (commandline.charAt(commandline.length() - 1) == '}' ? 1 : 0);
                String args = commandline.substring(res.endOffset(0), endIndex);
                Map<String, String> arglist = this.parseArgs(args);
                return this.execute(context, plugin, arglist);
            }
        }
        catch (NoSuchElementException e) {
            String msg = "Missing parameter in plugin definition: " + commandline;
            log.warn(msg, (Throwable)e);
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.missingparameter"), commandline));
        }
        catch (IOException e) {
            String msg = "Zyrf.  Problems with parsing arguments: " + commandline;
            log.warn(msg, (Throwable)e);
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.parsingarguments"), commandline));
        }
        return commandline;
    }

    private void registerPlugin(WikiPluginInfo pluginClass) {
        String name = pluginClass.getName();
        if (name != null) {
            log.debug("Registering plugin [name]: " + name);
            this.m_pluginClassMap.put(name, pluginClass);
        }
        if ((name = pluginClass.getAlias()) != null) {
            log.debug("Registering plugin [shortName]: " + name);
            this.m_pluginClassMap.put(name, pluginClass);
        }
        if ((name = pluginClass.getClassName()) != null) {
            log.debug("Registering plugin [className]: " + name);
            this.m_pluginClassMap.put(name, pluginClass);
        }
        pluginClass.initializePlugin(pluginClass, this.m_engine, this.m_searchPath, this.m_externalJars);
    }

    private void registerPlugins() {
        log.info("Registering plugins");
        List plugins = XmlUtil.parse((String)"ini/jspwiki_module.xml", (String)"/modules/plugin");
        for (Element pluginEl : plugins) {
            String className = pluginEl.getAttributeValue("class");
            WikiPluginInfo pluginInfo = WikiPluginInfo.newInstance(className, pluginEl, this.m_searchPath, this.m_externalJars);
            if (pluginInfo == null) continue;
            this.registerPlugin(pluginInfo);
        }
    }

    @Override
    public Collection<WikiModuleInfo> modules() {
        return this.modules(this.m_pluginClassMap.values().iterator());
    }

    @Override
    public WikiPluginInfo getModuleInfo(String moduleName) {
        return this.m_pluginClassMap.get(moduleName);
    }

    @Override
    public Plugin newWikiPlugin(String pluginName, ResourceBundle rb) throws PluginException {
        Plugin plugin = null;
        WikiPluginInfo pluginInfo = this.m_pluginClassMap.get(pluginName);
        try {
            if (pluginInfo == null) {
                pluginInfo = WikiPluginInfo.newInstance(this.findPluginClass(pluginName));
                this.registerPlugin(pluginInfo);
            }
            if (!this.checkCompatibility(pluginInfo)) {
                String msg = "Plugin '" + pluginInfo.getName() + "' not compatible with this version of JSPWiki";
                log.info(msg);
            } else {
                plugin = pluginInfo.newPluginInstance(this.m_searchPath, this.m_externalJars);
            }
        }
        catch (ClassNotFoundException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.couldnotfind"), pluginName), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.cannotinstantiate"), pluginName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.notallowed"), pluginName), (Throwable)e);
        }
        catch (Exception e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.instantationfailed"), pluginName), (Throwable)e);
        }
        return plugin;
    }

    public static final class WikiPluginInfo
    extends WikiModuleInfo {
        private String m_className;
        private String m_alias;
        private String m_ajaxAlias;
        private Class<?> m_clazz;
        private boolean m_initialized;

        static WikiPluginInfo newInstance(String className, Element el, List<String> searchPath, List<String> externalJars) {
            if (className == null || className.isEmpty()) {
                return null;
            }
            WikiPluginInfo info = new WikiPluginInfo(className);
            info.initializeFromXML(el);
            return info;
        }

        void initializePlugin(WikiPluginInfo info, Engine engine, List<String> searchPath, List<String> externalJars) {
            if (!this.m_initialized) {
                this.m_initialized = true;
                try {
                    Plugin p = this.newPluginInstance(searchPath, externalJars);
                    if (p instanceof InitializablePlugin) {
                        ((InitializablePlugin)p).initialize(engine);
                    }
                    if (p instanceof WikiAjaxServlet) {
                        WikiAjaxDispatcherServlet.registerServlet((WikiAjaxServlet)p);
                        String ajaxAlias = info.getAjaxAlias();
                        if (StringUtils.isNotBlank((CharSequence)ajaxAlias)) {
                            WikiAjaxDispatcherServlet.registerServlet(info.getAjaxAlias(), (WikiAjaxServlet)p);
                        }
                    }
                }
                catch (Exception e) {
                    log.info("Cannot initialize plugin " + this.m_className, (Throwable)e);
                }
            }
        }

        @Override
        protected void initializeFromXML(Element el) {
            super.initializeFromXML(el);
            this.m_alias = el.getChildText("alias");
            this.m_ajaxAlias = el.getChildText("ajaxAlias");
        }

        static WikiPluginInfo newInstance(Class<?> clazz) {
            return new WikiPluginInfo(clazz.getName());
        }

        private WikiPluginInfo(String className) {
            super(className);
            this.setClassName(className);
        }

        private void setClassName(String fullClassName) {
            this.m_name = ClassUtils.getShortClassName((String)fullClassName);
            this.m_className = fullClassName;
        }

        public String getClassName() {
            return this.m_className;
        }

        public String getAlias() {
            return this.m_alias;
        }

        public String getAjaxAlias() {
            return this.m_ajaxAlias;
        }

        public Plugin newPluginInstance(List<String> searchPath, List<String> externalJars) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            if (this.m_clazz == null) {
                this.m_clazz = ClassUtil.findClass(searchPath, externalJars, (String)this.m_className);
            }
            return (Plugin)this.m_clazz.newInstance();
        }

        public String getIncludeText(String type) {
            try {
                if ("script".equals(type)) {
                    return this.getScriptText();
                }
                if ("stylesheet".equals(type)) {
                    return this.getStylesheetText();
                }
            }
            catch (Exception ex) {
                return ex.getMessage();
            }
            return null;
        }

        private String getScriptText() throws IOException {
            if (this.m_scriptText != null) {
                return this.m_scriptText;
            }
            if (this.m_scriptLocation == null) {
                return "";
            }
            try {
                this.m_scriptText = this.getTextResource(this.m_scriptLocation);
            }
            catch (IOException ex) {
                this.m_scriptText = "";
                throw ex;
            }
            return this.m_scriptText;
        }

        private String getStylesheetText() throws IOException {
            if (this.m_stylesheetText != null) {
                return this.m_stylesheetText;
            }
            if (this.m_stylesheetLocation == null) {
                return "";
            }
            try {
                this.m_stylesheetText = this.getTextResource(this.m_stylesheetLocation);
            }
            catch (IOException ex) {
                this.m_stylesheetText = "";
                throw ex;
            }
            return this.m_stylesheetText;
        }

        public String toString() {
            return "Plugin :[name=" + this.m_name + "][className=" + this.m_className + "]";
        }
    }
}

