/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Principal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.exceptions.RedirectException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.preferences.Preferences;

public class BugReportHandler
implements Plugin {
    private static final Logger log = LogManager.getLogger(BugReportHandler.class);
    private static final String DEFAULT_DATEFORMAT = "dd-MMM-yyyy HH:mm:ss zzz";
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_DESCRIPTION = "description";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_MAPPINGS = "map";
    public static final String PARAM_PAGE = "page";

    public String execute(Context context, Map<String, String> params) throws PluginException {
        String title = params.get(PARAM_TITLE);
        String description = params.get(PARAM_DESCRIPTION);
        String version = params.get(PARAM_VERSION);
        String submitter = null;
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATEFORMAT);
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        Principal wup = context.getCurrentUser();
        if (wup != null) {
            submitter = wup.getName();
        }
        if (title == null) {
            throw new PluginException(rb.getString("bugreporthandler.titlerequired"));
        }
        if (title.isEmpty()) {
            return "";
        }
        if (description == null) {
            description = "";
        }
        if (version == null) {
            version = "unknown";
        }
        Properties mappings = this.parseMappings(params.get(PARAM_MAPPINGS));
        try {
            StringWriter str = new StringWriter();
            PrintWriter out = new PrintWriter(str);
            Date d = new Date();
            out.println("|" + mappings.getProperty(PARAM_TITLE, "Title") + "|" + title);
            out.println("|" + mappings.getProperty("date", "Date") + "|" + format.format(d));
            out.println("|" + mappings.getProperty(PARAM_VERSION, "Version") + "|" + version);
            if (submitter != null) {
                out.println("|" + mappings.getProperty("submitter", "Submitter") + "|" + submitter);
            }
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String head;
                if (entry.getKey().equals(PARAM_TITLE) || entry.getKey().equals(PARAM_DESCRIPTION) || entry.getKey().equals(PARAM_VERSION) || entry.getKey().equals(PARAM_MAPPINGS) || entry.getKey().equals(PARAM_PAGE) || entry.getKey().startsWith("_") || (head = mappings.getProperty(entry.getKey(), entry.getKey())).isEmpty()) continue;
                out.println("|" + head + "|" + entry.getValue());
            }
            out.println();
            out.println(description);
            out.close();
            String pageName = this.findNextPage(context, title, params.get(PARAM_PAGE));
            Page newPage = Wiki.contents().page(context.getEngine(), pageName);
            Context newContext = context.clone();
            newContext.setPage(newPage);
            ((PageManager)context.getEngine().getManager(PageManager.class)).saveText(newContext, str.toString());
            MessageFormat formatter = new MessageFormat("");
            formatter.applyPattern(rb.getString("bugreporthandler.new"));
            String[] args = new String[]{"<a href=\"" + context.getViewURL(pageName) + "\">" + pageName + "</a>"};
            return formatter.format(args);
        }
        catch (RedirectException e) {
            log.info("Saving not allowed, reason: '" + e.getMessage() + "', can't redirect to " + e.getRedirect());
            throw new PluginException("Saving not allowed, reason: " + e.getMessage());
        }
        catch (WikiException e) {
            log.error("Unable to save page!", (Throwable)e);
            return rb.getString("bugreporthandler.unable");
        }
    }

    private synchronized String findNextPage(Context context, String title, String baseName) {
        String basicPageName = (baseName != null ? baseName : "Bug") + MarkupParser.cleanLink(title);
        Engine engine = context.getEngine();
        String pageName = basicPageName;
        long lastbug = 2L;
        while (((PageManager)engine.getManager(PageManager.class)).wikiPageExists(pageName)) {
            pageName = basicPageName + lastbug++;
        }
        return pageName;
    }

    private Properties parseMappings(String mappings) {
        Properties props = new Properties();
        if (mappings == null) {
            return props;
        }
        StringTokenizer tok = new StringTokenizer(mappings, ";");
        while (tok.hasMoreTokens()) {
            String value;
            String key;
            String t = tok.nextToken();
            int colon = t.indexOf("=");
            if (colon > 0) {
                key = t.substring(0, colon);
                value = t.substring(colon + 1);
            } else {
                key = t;
                value = "";
            }
            props.setProperty(key, value);
        }
        return props;
    }
}

