/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.IOException;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.wiki.StringTransmutator;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.pages.PageSorter;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.comparators.CollatorComparator;
import org.apache.wiki.util.comparators.HumanComparator;
import org.apache.wiki.util.comparators.JavaNaturalComparator;
import org.apache.wiki.util.comparators.LocaleComparator;

public abstract class AbstractReferralPlugin
implements Plugin {
    private static final Logger log = LogManager.getLogger(AbstractReferralPlugin.class);
    public static final int ALL_ITEMS = -1;
    public static final String PARAM_MAXWIDTH = "maxwidth";
    public static final String PARAM_SEPARATOR = "separator";
    public static final String PARAM_AFTER = "after";
    public static final String PARAM_BEFORE = "before";
    public static final String PARAM_EXCLUDE = "exclude";
    public static final String PARAM_INCLUDE = "include";
    public static final String PARAM_SHOW = "show";
    public static final String PARAM_SHOW_VALUE_PAGES = "pages";
    public static final String PARAM_SHOW_VALUE_COUNT = "count";
    public static final String PARAM_LASTMODIFIED = "showLastModified";
    public static final String PARAM_COLUMNS = "columns";
    protected static final String PARAM_SORTORDER = "sortOrder";
    protected static final String PARAM_SORTORDER_HUMAN = "human";
    protected static final String PARAM_SORTORDER_JAVA = "java";
    protected static final String PARAM_SORTORDER_LOCALE = "locale";
    protected int m_maxwidth = Integer.MAX_VALUE;
    protected String m_before = "";
    protected String m_separator = "";
    protected String m_after = "\\\\";
    protected int items = 0;
    protected Pattern[] m_exclude;
    protected Pattern[] m_include;
    protected PageSorter m_sorter;
    protected String m_show = "pages";
    protected boolean m_lastModified;
    protected Date m_dateLastModified = new Date(0L);
    protected SimpleDateFormat m_dateFormat;
    protected Engine m_engine;

    public void initialize(Context context, Map<String, String> params) throws PluginException {
        int i;
        String[] ptrns;
        GlobCompiler pc;
        String s;
        this.m_dateFormat = Preferences.getDateFormat(context, Preferences.TimeFormat.DATETIME);
        this.m_engine = context.getEngine();
        this.m_maxwidth = TextUtil.parseIntParameter((String)params.get(PARAM_MAXWIDTH), (int)Integer.MAX_VALUE);
        if (this.m_maxwidth < 0) {
            this.m_maxwidth = 0;
        }
        if ((s = params.get(PARAM_SEPARATOR)) != null) {
            this.m_separator = TextUtil.replaceEntities((String)s);
            this.m_after = "";
        }
        if ((s = params.get(PARAM_BEFORE)) != null) {
            this.m_before = s;
        }
        if ((s = params.get(PARAM_AFTER)) != null) {
            this.m_after = s;
        }
        if ((s = params.get(PARAM_COLUMNS)) != null) {
            this.items = TextUtil.parseIntParameter((String)s, (int)0);
        }
        if ((s = params.get(PARAM_EXCLUDE)) != null) {
            try {
                pc = new GlobCompiler();
                ptrns = StringUtils.split((String)s, (String)",");
                this.m_exclude = new Pattern[ptrns.length];
                for (i = 0; i < ptrns.length; ++i) {
                    this.m_exclude[i] = pc.compile(ptrns[i]);
                }
            }
            catch (MalformedPatternException e) {
                throw new PluginException("Exclude-parameter has a malformed pattern: " + e.getMessage());
            }
        }
        if ((s = params.get(PARAM_INCLUDE)) != null) {
            try {
                pc = new GlobCompiler();
                ptrns = StringUtils.split((String)s, (String)",");
                this.m_include = new Pattern[ptrns.length];
                for (i = 0; i < ptrns.length; ++i) {
                    this.m_include[i] = pc.compile(ptrns[i]);
                }
            }
            catch (MalformedPatternException e) {
                throw new PluginException("Include-parameter has a malformed pattern: " + e.getMessage());
            }
        }
        if ((s = params.get(PARAM_SHOW)) != null && s.equalsIgnoreCase(PARAM_SHOW_VALUE_COUNT)) {
            this.m_show = PARAM_SHOW_VALUE_COUNT;
        }
        if ((s = params.get(PARAM_LASTMODIFIED)) != null && s.equalsIgnoreCase("true")) {
            if (this.m_show.equals(PARAM_SHOW_VALUE_COUNT)) {
                this.m_lastModified = true;
            } else {
                throw new PluginException("showLastModified=true is only valid if show=count is also specified");
            }
        }
        this.initSorter(context, params);
    }

    protected List<Page> filterWikiPageCollection(Collection<Page> pages) {
        List<String> pageNames = this.filterCollection(pages.stream().map(Page::getName).collect(Collectors.toList()));
        return pages.stream().filter(wikiPage -> pageNames.contains(wikiPage.getName())).collect(Collectors.toList());
    }

    protected List<String> filterCollection(Collection<String> c) {
        ArrayList<String> result = new ArrayList<String>();
        Perl5Matcher pm = new Perl5Matcher();
        for (String pageName : c) {
            Page page;
            boolean includeThis;
            boolean bl = includeThis = this.m_include == null;
            if (this.m_include != null) {
                for (Pattern pattern : this.m_include) {
                    if (!pm.matches(pageName, pattern)) continue;
                    includeThis = true;
                    break;
                }
            }
            if (this.m_exclude != null) {
                for (Pattern pattern : this.m_exclude) {
                    if (!pm.matches(pageName, pattern)) continue;
                    includeThis = false;
                    break;
                }
            }
            if (!includeThis) continue;
            result.add(pageName);
            if (!this.m_lastModified || (page = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pageName)) == null) continue;
            Date lastModPage = page.getLastModified();
            if (log.isDebugEnabled()) {
                log.debug("lastModified Date of page " + pageName + " : " + this.m_dateLastModified);
            }
            if (!lastModPage.after(this.m_dateLastModified)) continue;
            this.m_dateLastModified = lastModPage;
        }
        return result;
    }

    protected List<String> filterAndSortCollection(Collection<String> c) {
        List<String> result = this.filterCollection(c);
        result.sort(this.m_sorter);
        return result;
    }

    protected String wikitizeCollection(Collection<String> links, String separator, int numItems) {
        int count;
        if (links == null || links.isEmpty()) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        Iterator<String> it = links.iterator();
        for (count = 0; it.hasNext() && (count < numItems || numItems == -1); ++count) {
            String value = it.next();
            if (count > 0) {
                output.append(this.m_after);
                output.append(separator);
            }
            output.append(this.m_before);
            output.append("[").append(((RenderingManager)this.m_engine.getManager(RenderingManager.class)).beautifyTitle(value)).append("|").append(value).append("]");
        }
        if (count > 0) {
            output.append(this.m_after);
        }
        return output.toString();
    }

    protected String makeHTML(Context context, String wikitext) {
        String result = "";
        RenderingManager mgr = (RenderingManager)this.m_engine.getManager(RenderingManager.class);
        try {
            MarkupParser parser = mgr.getParser(context, wikitext);
            parser.addLinkTransmutator(new CutMutator(this.m_maxwidth));
            parser.enableImageInlining(false);
            WikiDocument doc = parser.parse();
            result = mgr.getHTML(context, doc);
        }
        catch (IOException e) {
            log.error("Failed to convert page data to HTML", (Throwable)e);
        }
        return result;
    }

    protected String applyColumnsStyle(String result) {
        if (this.items > 1) {
            return "<div style=\"columns:" + this.items + ";-moz-columns:" + this.items + ";-webkit-columns:" + this.items + ";\">" + result + "</div>";
        }
        return result;
    }

    private void initSorter(Context context, Map<String, String> params) {
        String order = params.get(PARAM_SORTORDER);
        if (order == null || order.isEmpty()) {
            this.m_sorter = ((PageManager)context.getEngine().getManager(PageManager.class)).getPageSorter();
        } else if (order.equalsIgnoreCase(PARAM_SORTORDER_JAVA)) {
            this.m_sorter = new PageSorter(JavaNaturalComparator.DEFAULT_JAVA_COMPARATOR);
        } else if (order.equalsIgnoreCase(PARAM_SORTORDER_LOCALE)) {
            this.m_sorter = new PageSorter(LocaleComparator.DEFAULT_LOCALE_COMPARATOR);
        } else if (order.equalsIgnoreCase(PARAM_SORTORDER_HUMAN)) {
            this.m_sorter = new PageSorter(HumanComparator.DEFAULT_HUMAN_COMPARATOR);
        } else {
            try {
                RuleBasedCollator collator = new RuleBasedCollator(order);
                collator.setStrength(0);
                this.m_sorter = new PageSorter((Comparator<String>)new CollatorComparator((Collator)collator));
            }
            catch (ParseException pe) {
                log.info("Failed to parse requested collator - using default ordering", (Throwable)pe);
                this.m_sorter = ((PageManager)context.getEngine().getManager(PageManager.class)).getPageSorter();
            }
        }
    }

    private static class CutMutator
    implements StringTransmutator {
        private final int m_length;

        public CutMutator(int length) {
            this.m_length = length;
        }

        @Override
        public String mutate(Context context, String text) {
            if (text.length() > this.m_length) {
                return text.substring(0, this.m_length) + "...";
            }
            return text;
        }
    }
}

