/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.parser;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.exceptions.ProviderException;

public class LinkParsingOperations {
    private static final Logger log = LogManager.getLogger(LinkParsingOperations.class);
    private final Context wikiContext;
    static final String[] EXTERNAL_LINKS = new String[]{"http:", "ftp:", "https:", "mailto:", "news:", "file:", "rtsp:", "mms:", "ldap:", "gopher:", "nntp:", "telnet:", "wais:", "prospero:", "z39.50s", "z39.50r", "vemmi:", "imap:", "nfs:", "acap:", "tip:", "pop:", "dav:", "opaquelocktoken:", "sip:", "sips:", "tel:", "fax:", "modem:", "soap.beep:", "soap.beeps", "xmlrpc.beep", "xmlrpc.beeps", "urn:", "go:", "h323:", "ipp:", "tftp:", "mupdate:", "pres:", "im:", "mtqp", "smb:"};

    public LinkParsingOperations(Context wikiContext) {
        this.wikiContext = wikiContext;
    }

    public boolean isAccessRule(String link) {
        return link.startsWith("{ALLOW") || link.startsWith("{DENY");
    }

    public boolean isPluginLink(String link) {
        return link.startsWith("{INSERT") || link.startsWith("{") && !link.startsWith("{$");
    }

    public boolean isMetadata(String link) {
        return link.startsWith("{SET");
    }

    public boolean isVariableLink(String link) {
        return link.startsWith("{$");
    }

    public boolean isInterWikiLink(String page) {
        return this.interWikiLinkAt(page) != -1;
    }

    public int interWikiLinkAt(String page) {
        return page.indexOf(58);
    }

    public boolean isExternalLink(String page) {
        int idx = Arrays.binarySearch(EXTERNAL_LINKS, page, new StartingComparator());
        return idx >= 0 && page.startsWith(EXTERNAL_LINKS[idx]);
    }

    public boolean isImageLink(String link, boolean isImageInlining, List<Pattern> inlineImagePatterns) {
        if (isImageInlining) {
            link = link.toLowerCase();
            for (Pattern p : inlineImagePatterns) {
                if (!new Perl5Matcher().matches(link, p)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean linkExists(String page) {
        if (page == null || page.isEmpty()) {
            return false;
        }
        try {
            return this.wikiContext.getEngine().getFinalPageName(page) != null;
        }
        catch (ProviderException e) {
            log.warn("TranslatorReader got a faulty page name [" + page + "]!", (Throwable)e);
            return false;
        }
    }

    public String linkIfExists(String page) {
        if (page == null || page.isEmpty()) {
            return null;
        }
        try {
            return this.wikiContext.getEngine().getFinalPageName(page);
        }
        catch (ProviderException e) {
            log.warn("TranslatorReader got a faulty page name [" + page + "]!", (Throwable)e);
            return null;
        }
    }

    static {
        Arrays.sort(EXTERNAL_LINKS);
    }

    private static class StartingComparator
    implements Comparator<String> {
        private StartingComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1.length() > s2.length() ? s1.startsWith(s2) && s2.length() > 1 : s2.startsWith(s1) && s1.length() > 1) {
                return 0;
            }
            return s1.compareTo(s2);
        }
    }
}

