/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.wiki.htmltowiki.WhitespaceTrimWriter;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.apache.wiki.util.XmlUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.xpath.XPathFactory;

public class XHtmlElementToWikiTranslator {
    private final XHtmlToWikiConfig config;
    private final WhitespaceTrimWriter outTrimmer = new WhitespaceTrimWriter();
    private final PrintWriter out = new PrintWriter(this.outTrimmer);
    private final Stack<String> liStack = new Stack();
    private final Stack<String> preStack = new PreStack();

    public XHtmlElementToWikiTranslator(Element base) throws JDOMException {
        this(base, new XHtmlToWikiConfig());
    }

    public XHtmlElementToWikiTranslator(Element base, XHtmlToWikiConfig config) throws JDOMException {
        this.config = config;
        this.translate((Content)base);
    }

    public String getWikiString() {
        return this.outTrimmer.toString();
    }

    private void translate(Content element) throws JDOMException {
        if (element instanceof Text) {
            this.decorateMarkupForText((Text)element);
        } else if (element instanceof Element) {
            Element base = (Element)element;
            if ("imageplugin".equals(base.getAttributeValue("class"))) {
                this.translateImage(base);
            } else if ("wikiform".equals(base.getAttributeValue("class"))) {
                this.translateChildren(base);
            } else {
                ElementDecoratorData dto = this.buildElementDecoratorDataFrom(base);
                this.decorateMarkupForElementWith(dto);
            }
        }
    }

    void decorateMarkupForString(String s) {
        this.out.print(StringEscapeUtils.unescapeHtml4((String)s));
    }

    void decorateMarkupForText(Text text) {
        String s = text.getText();
        if (this.preStack.isEmpty()) {
            s = s.replaceAll("[\\r\\n\\f\\u0085\\u2028\\u2029]", "");
        }
        this.out.print(s);
    }

    ElementDecoratorData buildElementDecoratorDataFrom(Element base) {
        String n = base.getName().toLowerCase();
        boolean bold = false;
        boolean italic = false;
        boolean monospace = false;
        String cssSpecial = null;
        String cssClass = base.getAttributeValue("class");
        boolean ignoredCssClass = cssClass != null && cssClass.matches("wikipage|createpage|external|interwiki|attachment|inline-code");
        Map<Object, Object> styleProps = null;
        if (!n.equals("a")) {
            styleProps = this.getStylePropertiesLowerCase(base);
        }
        if ("inline-code".equals(cssClass)) {
            monospace = true;
        }
        if (styleProps != null) {
            String weight = (String)styleProps.remove("font-weight");
            String style = (String)styleProps.remove("font-style");
            if (n.equals("p")) {
                n = "div";
            }
            italic = "oblique".equals(style) || "italic".equals(style);
            boolean bl = bold = "bold".equals(weight) || "bolder".equals(weight);
            if (!styleProps.isEmpty()) {
                cssSpecial = this.propsToStyleString(styleProps);
            }
        }
        ElementDecoratorData dto = new ElementDecoratorData();
        dto.base = base;
        dto.bold = bold;
        dto.cssClass = cssClass;
        dto.cssSpecial = cssSpecial;
        dto.htmlBase = n;
        dto.ignoredCssClass = ignoredCssClass;
        dto.italic = italic;
        dto.monospace = monospace;
        return dto;
    }

    private Map<Object, Object> getStylePropertiesLowerCase(Element base) {
        String align;
        String n = base.getName().toLowerCase();
        String style = base.getAttributeValue("style");
        if (style == null) {
            style = "";
        }
        if ((n.equals("p") || n.equals("div")) && (align = base.getAttributeValue("align")) != null && !style.contains("text-align")) {
            style = style + ";text-align:" + align + ";";
        }
        if (n.equals("font")) {
            String color = base.getAttributeValue("color");
            String face = base.getAttributeValue("face");
            String size = base.getAttributeValue("size");
            if (color != null) {
                style = style + "color:" + color + ";";
            }
            if (face != null) {
                style = style + "font-family:" + face + ";";
            }
            if (size != null) {
                switch (size) {
                    case "1": {
                        style = style + "font-size:xx-small;";
                        break;
                    }
                    case "2": {
                        style = style + "font-size:x-small;";
                        break;
                    }
                    case "3": {
                        style = style + "font-size:small;";
                        break;
                    }
                    case "4": {
                        style = style + "font-size:medium;";
                        break;
                    }
                    case "5": {
                        style = style + "font-size:large;";
                        break;
                    }
                    case "6": {
                        style = style + "font-size:x-large;";
                        break;
                    }
                    case "7": {
                        style = style + "font-size:xx-large;";
                    }
                }
            }
        }
        if (style.equals("")) {
            return null;
        }
        LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
        Arrays.stream(style.toLowerCase().split(";")).filter(StringUtils::isNotEmpty).forEach(prop -> m.put(prop.split(":")[0].trim(), prop.split(":")[1].trim()));
        return m;
    }

    private String propsToStyleString(Map<Object, Object> styleProps) {
        StringBuilder style = new StringBuilder();
        for (Map.Entry<Object, Object> entry : styleProps.entrySet()) {
            style.append(" ").append(entry.getKey()).append(": ").append(entry.getValue()).append(";");
        }
        return style.toString();
    }

    void decorateMarkupForElementWith(ElementDecoratorData dto) throws JDOMException {
        this.decorateMarkupForCssClass(dto);
    }

    void decorateMarkupForCssClass(ElementDecoratorData dto) throws JDOMException {
        if (dto.cssClass != null && !dto.ignoredCssClass) {
            if (dto.htmlBase.equals("div")) {
                this.out.print("\n%%" + dto.cssClass + " \n");
            } else if (dto.htmlBase.equals("span")) {
                this.out.print("%%" + dto.cssClass + " ");
            }
        }
        this.decorateMarkupForBold(dto);
        if (dto.cssClass != null && !dto.ignoredCssClass) {
            if (dto.htmlBase.equals("div")) {
                this.out.print("\n/%\n");
            } else if (dto.htmlBase.equals("span")) {
                this.out.print("/%");
            }
        }
    }

    void decorateMarkupForBold(ElementDecoratorData dto) throws JDOMException {
        if (dto.bold) {
            this.out.print("__");
        }
        this.decorateMarkupForItalic(dto);
        if (dto.bold) {
            this.out.print("__");
        }
    }

    void decorateMarkupForItalic(ElementDecoratorData dto) throws JDOMException {
        if (dto.italic) {
            this.out.print("''");
        }
        this.decorateMarkupForMonospace(dto);
        if (dto.italic) {
            this.out.print("''");
        }
    }

    void decorateMarkupForMonospace(ElementDecoratorData dto) throws JDOMException {
        if (dto.monospace) {
            this.out.print("{{{");
            this.preStack.push("{{{");
        }
        this.decorateMarkupForCssSpecial(dto);
        if (dto.monospace) {
            this.preStack.pop();
            this.out.print("}}}");
        }
    }

    void decorateMarkupForCssSpecial(ElementDecoratorData dto) throws JDOMException {
        if (dto.cssSpecial != null) {
            if (dto.htmlBase.equals("div")) {
                this.out.print("\n%%(" + dto.cssSpecial + " )\n");
            } else {
                this.out.print("%%(" + dto.cssSpecial + " )");
            }
        }
        this.translateChildren(dto.base);
        if (dto.cssSpecial != null) {
            if (dto.htmlBase.equals("div")) {
                this.out.print("\n/%\n");
            } else {
                this.out.print("/%");
            }
        }
    }

    private void translateChildren(Element base) throws JDOMException {
        for (Content c : base.getContent()) {
            if (c instanceof Element) {
                String n;
                Element e = (Element)c;
                switch (n = e.getName().toLowerCase()) {
                    case "h1": {
                        this.decorateMarkupForH1(e);
                        break;
                    }
                    case "h2": {
                        this.decorateMarkupForH2(e);
                        break;
                    }
                    case "h3": {
                        this.decorateMarkupForH3(e);
                        break;
                    }
                    case "h4": {
                        this.decorateMarkupForH4(e);
                        break;
                    }
                    case "p": {
                        this.decorateMarkupForP(e);
                        break;
                    }
                    case "br": {
                        this.decorateMarkupForBR(base, e);
                        break;
                    }
                    case "hr": {
                        this.decorateMarkupForHR(e);
                        break;
                    }
                    case "table": {
                        this.decorateMarkupForTable(e);
                        break;
                    }
                    case "tr": {
                        this.decorateMarkupForTR(e);
                        break;
                    }
                    case "td": {
                        this.decorateMarkupForTD(e);
                        break;
                    }
                    case "th": {
                        this.decorateMarkupForTH(e);
                        break;
                    }
                    case "a": {
                        this.decorateMarkupForA(e);
                        break;
                    }
                    case "b": 
                    case "strong": {
                        this.decorateMarkupForStrong(e);
                        break;
                    }
                    case "i": 
                    case "em": 
                    case "address": {
                        this.decorateMarkupForEM(e);
                        break;
                    }
                    case "u": {
                        this.decorateMarkupForUnderline(e);
                        break;
                    }
                    case "strike": {
                        this.decorateMarkupForStrike(e);
                        break;
                    }
                    case "sup": {
                        this.decorateMarkupForSup(e);
                        break;
                    }
                    case "sub": {
                        this.decorateMarkupForSub(e);
                        break;
                    }
                    case "dl": {
                        this.decorateMarkupForDL(e);
                        break;
                    }
                    case "dt": {
                        this.decorateMarkupForDT(e);
                        break;
                    }
                    case "dd": {
                        this.decorateMarkupForDD(e);
                        break;
                    }
                    case "ul": {
                        this.decorateMarkupForUL(e);
                        break;
                    }
                    case "ol": {
                        this.decorateMarkupForOL(e);
                        break;
                    }
                    case "li": {
                        this.decorateMarkupForLI(base, e);
                        break;
                    }
                    case "pre": {
                        this.decorateMarkupForPre(e);
                        break;
                    }
                    case "code": 
                    case "tt": {
                        this.decorateMarkupForCode(e);
                        break;
                    }
                    case "img": {
                        this.decorateMarkupForImg(e);
                        break;
                    }
                    case "form": {
                        this.decorateMarkupForForm(e);
                        break;
                    }
                    case "input": {
                        this.decorateMarkupForInput(e);
                        break;
                    }
                    case "textarea": {
                        this.decorateMarkupForTextarea(e);
                        break;
                    }
                    case "select": {
                        this.decorateMarkupForSelect(e);
                        break;
                    }
                    case "option": {
                        this.decorateMarkupForOption(base, e);
                        break;
                    }
                    default: {
                        this.translate((Content)e);
                        break;
                    }
                }
                continue;
            }
            this.translate(c);
        }
    }

    void decorateMarkupForH1(Element e) throws JDOMException {
        this.out.print("\n!!! ");
        this.translate((Content)e);
        this.out.println();
    }

    void decorateMarkupForH2(Element e) throws JDOMException {
        this.out.print("\n!!! ");
        this.translate((Content)e);
        this.out.println();
    }

    void decorateMarkupForH3(Element e) throws JDOMException {
        this.out.print("\n!! ");
        this.translate((Content)e);
        this.out.println();
    }

    void decorateMarkupForH4(Element e) throws JDOMException {
        this.out.print("\n! ");
        this.translate((Content)e);
        this.out.println();
    }

    void decorateMarkupForP(Element e) throws JDOMException {
        if (e.getContentSize() != 0) {
            this.out.println();
            this.translate((Content)e);
            this.out.println();
        }
    }

    void decorateMarkupForHR(Element e) throws JDOMException {
        this.out.println();
        this.decorateMarkupForString("----");
        this.translate((Content)e);
        this.out.println();
    }

    void decorateMarkupForBR(Element base, Element e) throws JDOMException {
        if (!this.preStack.isEmpty()) {
            this.out.println();
        } else {
            String parentElementName = base.getName().toLowerCase();
            if (parentElementName.matches("p|div") && !base.getText().matches("(?s).*\\[\\{.*\\}\\].*")) {
                this.out.print(" \\\\\n");
            } else {
                this.out.print(" \\\\");
            }
        }
        this.translate((Content)e);
    }

    void decorateMarkupForTable(Element e) throws JDOMException {
        if (!this.outTrimmer.isCurrentlyOnLineBegin()) {
            this.out.println();
        }
        this.translate((Content)e);
    }

    void decorateMarkupForTR(Element e) throws JDOMException {
        this.translate((Content)e);
        this.out.println();
    }

    void decorateMarkupForTD(Element e) throws JDOMException {
        this.out.print("| ");
        this.translate((Content)e);
        if (this.preStack.isEmpty()) {
            this.decorateMarkupForString(" ");
        }
    }

    void decorateMarkupForTH(Element e) throws JDOMException {
        this.out.print("|| ");
        this.translate((Content)e);
        if (this.preStack.isEmpty()) {
            this.decorateMarkupForString(" ");
        }
    }

    void decorateMarkupForA(Element e) throws JDOMException {
        if (this.isNotIgnorableWikiMarkupLink(e)) {
            if (e.getChild("IMG") != null) {
                this.translateImage(e);
            } else {
                String ref = e.getAttributeValue("href");
                if (ref == null) {
                    if (this.isUndefinedPageLink(e)) {
                        this.out.print("[");
                        this.translate((Content)e);
                        this.out.print("]");
                    } else {
                        this.translate((Content)e);
                    }
                } else if ((ref = this.trimLink(ref)) != null) {
                    if (ref.startsWith("#")) {
                        String textValue;
                        String href = ref.replaceFirst("#ref-.+-(\\d+)", "$1");
                        if (href.equals(textValue = e.getValue().substring(1, e.getValue().length() - 1))) {
                            this.translate((Content)e);
                        } else {
                            this.out.print("[" + textValue + "|" + href + "]");
                        }
                    } else {
                        Map<String, String> augmentedWikiLinkAttributes = this.getAugmentedWikiLinkAttributes(e);
                        this.out.print("[");
                        this.translate((Content)e);
                        if (!e.getTextTrim().equalsIgnoreCase(ref)) {
                            this.out.print("|");
                            this.decorateMarkupForString(ref);
                            if (!augmentedWikiLinkAttributes.isEmpty()) {
                                this.out.print("|");
                                String augmentedWikiLink = this.augmentedWikiLinkMapToString(augmentedWikiLinkAttributes);
                                this.out.print(augmentedWikiLink);
                            }
                        } else if (!augmentedWikiLinkAttributes.isEmpty()) {
                            this.out.print("|" + ref + "|");
                            String augmentedWikiLink = this.augmentedWikiLinkMapToString(augmentedWikiLinkAttributes);
                            this.out.print(augmentedWikiLink);
                        }
                        this.out.print("]");
                    }
                }
            }
        }
    }

    private boolean isUndefinedPageLink(Element a) {
        String classVal = a.getAttributeValue("class");
        return "createpage".equals(classVal);
    }

    private Map<String, String> getAugmentedWikiLinkAttributes(Element a) {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        String cssClass = a.getAttributeValue("class");
        if (StringUtils.isNotEmpty((CharSequence)cssClass) && !cssClass.matches("wikipage|createpage|external|interwiki|attachment")) {
            attributesMap.put("class", cssClass.replace("'", "\""));
        }
        this.addAttributeIfPresent(a, attributesMap, "accesskey");
        this.addAttributeIfPresent(a, attributesMap, "charset");
        this.addAttributeIfPresent(a, attributesMap, "dir");
        this.addAttributeIfPresent(a, attributesMap, "hreflang");
        this.addAttributeIfPresent(a, attributesMap, "id");
        this.addAttributeIfPresent(a, attributesMap, "lang");
        this.addAttributeIfPresent(a, attributesMap, "rel");
        this.addAttributeIfPresent(a, attributesMap, "rev");
        this.addAttributeIfPresent(a, attributesMap, "style");
        this.addAttributeIfPresent(a, attributesMap, "tabindex");
        this.addAttributeIfPresent(a, attributesMap, "target");
        this.addAttributeIfPresent(a, attributesMap, "title");
        this.addAttributeIfPresent(a, attributesMap, "type");
        return attributesMap;
    }

    private void addAttributeIfPresent(Element a, Map<String, String> attributesMap, String attribute) {
        String attr = a.getAttributeValue(attribute);
        if (StringUtils.isNotEmpty((CharSequence)attr)) {
            attributesMap.put(attribute, attr.replace("'", "\""));
        }
    }

    private String augmentedWikiLinkMapToString(Map<String, String> attributesMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            String attributeName = entry.getKey();
            String attributeValue = entry.getValue();
            sb.append(" ").append(attributeName).append("='").append(attributeValue).append("'");
        }
        return sb.toString().trim();
    }

    void decorateMarkupForStrong(Element e) throws JDOMException {
        this.out.print("__");
        this.translate((Content)e);
        this.out.print("__");
    }

    void decorateMarkupForEM(Element e) throws JDOMException {
        this.out.print("''");
        this.translate((Content)e);
        this.out.print("''");
    }

    void decorateMarkupForUnderline(Element e) throws JDOMException {
        this.out.print("%%( text-decoration:underline; )");
        this.translate((Content)e);
        this.out.print("/%");
    }

    void decorateMarkupForStrike(Element e) throws JDOMException {
        this.out.print("%%strike ");
        this.translate((Content)e);
        this.out.print("/%");
    }

    void decorateMarkupForSup(Element e) throws JDOMException {
        this.out.print("%%sup ");
        this.translate((Content)e);
        this.out.print("/%");
    }

    void decorateMarkupForSub(Element e) throws JDOMException {
        this.out.print("%%sub ");
        this.translate((Content)e);
        this.out.print("/%");
    }

    void decorateMarkupForDL(Element e) throws JDOMException {
        this.out.print("\n");
        this.translate((Content)e);
        this.out.print("\n");
    }

    void decorateMarkupForDT(Element e) throws JDOMException {
        this.out.print(";");
        this.translate((Content)e);
    }

    void decorateMarkupForDD(Element e) throws JDOMException {
        this.out.print(":");
        this.translate((Content)e);
    }

    void decorateMarkupForUL(Element e) throws JDOMException {
        this.out.println();
        this.liStack.push("*");
        this.translate((Content)e);
        this.liStack.pop();
    }

    void decorateMarkupForOL(Element e) throws JDOMException {
        this.out.println();
        this.liStack.push("#");
        this.translate((Content)e);
        this.liStack.pop();
    }

    void decorateMarkupForLI(Element base, Element e) throws JDOMException {
        boolean sublistItem;
        this.out.print(String.join((CharSequence)"", this.liStack) + " ");
        this.translate((Content)e);
        boolean lastListItem = base.indexOf((Content)e) == base.getContentSize() - 2;
        boolean bl = sublistItem = this.liStack.size() > 1;
        if (!sublistItem || !lastListItem) {
            this.out.println();
        }
    }

    void decorateMarkupForPre(Element e) throws JDOMException {
        this.out.print("\n{{{");
        this.preStack.push("\n{{{");
        this.translate((Content)e);
        this.preStack.pop();
        this.out.print("}}}\n");
    }

    void decorateMarkupForCode(Element e) throws JDOMException {
        this.out.print("{{");
        this.preStack.push("{{");
        this.translate((Content)e);
        this.preStack.pop();
        this.out.print("}}");
    }

    void decorateMarkupForImg(Element e) {
        if (this.isNotIgnorableWikiMarkupLink(e)) {
            this.out.print("[");
            this.decorateMarkupForString(this.trimLink(e.getAttributeValue("src")));
            this.out.print("]");
        }
    }

    void decorateMarkupForForm(Element e) throws JDOMException {
        Element formName = XmlUtil.getXPathElement((Element)e, (String)"INPUT[@name='formname']");
        if (formName != null) {
            formName.detach();
        }
        String name = e.getAttributeValue("name");
        this.out.print("\n[{FormOpen");
        if (name != null) {
            this.out.print(" form='" + name + "'");
        }
        this.out.print("}]\n");
        this.translate((Content)e);
        this.out.print("\n[{FormClose}]\n");
    }

    void decorateMarkupForInput(Element e) throws JDOMException {
        String type = e.getAttributeValue("type");
        String name = e.getAttributeValue("name");
        String value = e.getAttributeValue("value");
        String checked = e.getAttributeValue("checked");
        this.out.print("[{FormInput");
        if (type != null) {
            this.out.print(" type='" + type + "'");
        }
        if (name != null) {
            if (name.startsWith("nbf_")) {
                name = name.substring(4);
            }
            this.out.print(" name='" + name + "'");
        }
        if (value != null && !value.equals("")) {
            this.out.print(" value='" + value + "'");
        }
        if (checked != null) {
            this.out.print(" checked='" + checked + "'");
        }
        this.out.print("}]");
        this.translate((Content)e);
    }

    void decorateMarkupForTextarea(Element e) throws JDOMException {
        String name = e.getAttributeValue("name");
        String rows = e.getAttributeValue("rows");
        String cols = e.getAttributeValue("cols");
        this.out.print("[{FormTextarea");
        if (name != null) {
            if (name.startsWith("nbf_")) {
                name = name.substring(4);
            }
            this.out.print(" name='" + name + "'");
        }
        if (rows != null) {
            this.out.print(" rows='" + rows + "'");
        }
        if (cols != null) {
            this.out.print(" cols='" + cols + "'");
        }
        this.out.print("}]");
        this.translate((Content)e);
    }

    void decorateMarkupForSelect(Element e) throws JDOMException {
        String name = e.getAttributeValue("name");
        this.out.print("[{FormSelect");
        if (name != null) {
            if (name.startsWith("nbf_")) {
                name = name.substring(4);
            }
            this.out.print(" name='" + name + "'");
        }
        this.out.print(" value='");
        this.translate((Content)e);
        this.out.print("'}]");
    }

    void decorateMarkupForOption(Element base, Element e) throws JDOMException {
        String value;
        Attribute selected;
        if (base.indexOf((Content)e) != 1) {
            this.out.print(";");
        }
        if ((selected = e.getAttribute("selected")) != null) {
            this.out.print("*");
        }
        if ((value = e.getAttributeValue("value")) != null) {
            this.out.print(value);
        } else {
            this.translate((Content)e);
        }
    }

    private void translateImage(Element base) {
        String href;
        Element img;
        Element child = XmlUtil.getXPathElement((Element)base, (String)"TBODY/TR/TD/*");
        if (child == null) {
            child = base;
        }
        if (child.getName().equals("A")) {
            img = child.getChild("IMG");
            href = child.getAttributeValue("href");
        } else {
            img = child;
            href = null;
        }
        if (img == null) {
            return;
        }
        String src = this.trimLink(img.getAttributeValue("src"));
        if (src == null) {
            return;
        }
        LinkedHashMap<String, Object> imageAttrs = new LinkedHashMap<String, Object>();
        this.putIfNotEmpty(imageAttrs, "align", base.getAttributeValue("align"));
        this.putIfNotEmpty(imageAttrs, "height", img.getAttributeValue("height"));
        this.putIfNotEmpty(imageAttrs, "width", img.getAttributeValue("width"));
        this.putIfNotEmpty(imageAttrs, "alt", img.getAttributeValue("alt"));
        this.putIfNotEmpty(imageAttrs, "caption", this.emptyToNull((Element)XPathFactory.instance().compile("CAPTION").evaluateFirst((Object)base)));
        this.putIfNotEmpty(imageAttrs, "link", href);
        this.putIfNotEmpty(imageAttrs, "border", img.getAttributeValue("border"));
        this.putIfNotEmpty(imageAttrs, "style", base.getAttributeValue("style"));
        this.decorateMarkupforImage(src, imageAttrs);
    }

    private void putIfNotEmpty(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private String emptyToNull(Element e) {
        if (e == null) {
            return null;
        }
        String s = e.getText();
        return s == null ? null : (s.replaceAll("\\s", "").isEmpty() ? null : s);
    }

    void decorateMarkupforImage(String src, Map<String, Object> imageAttrs) {
        if (imageAttrs.isEmpty()) {
            this.out.print("[" + src + "]");
        } else {
            this.out.print("[{Image src='" + src + "'");
            for (Map.Entry<String, Object> objectObjectEntry : imageAttrs.entrySet()) {
                if (objectObjectEntry.getValue().equals("")) continue;
                this.out.print(" " + objectObjectEntry.getKey() + "='" + objectObjectEntry.getValue() + "'");
            }
            this.out.print("}]");
        }
    }

    private boolean isNotIgnorableWikiMarkupLink(Element a) {
        String ref = a.getAttributeValue("href");
        String clazz = a.getAttributeValue("class");
        return !(ref != null && ref.startsWith(this.config.getPageInfoJsp()) || clazz != null && clazz.trim().equalsIgnoreCase(this.config.getOutlink()));
    }

    private String trimLink(String ref) {
        if (ref == null) {
            return null;
        }
        try {
            ref = URLDecoder.decode(ref, StandardCharsets.UTF_8.name());
            ref = ref.trim();
            if (ref.startsWith(this.config.getAttachPage())) {
                ref = ref.substring(this.config.getAttachPage().length());
            }
            if (ref.startsWith(this.config.getWikiJspPage())) {
                ref = ref.substring(this.config.getWikiJspPage().length());
                ref = ref.replaceFirst(".+#section-(.+)-(.+)", "$1#$2");
            }
            if (ref.startsWith(this.config.getEditJspPage())) {
                ref = ref.substring(this.config.getEditJspPage().length());
            }
            if (this.config.getPageName() != null && ref.startsWith(this.config.getPageName())) {
                ref = ref.substring(this.config.getPageName().length());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ref;
    }

    static class ElementDecoratorData {
        Element base;
        String htmlBase;
        String cssClass;
        String cssSpecial;
        boolean monospace;
        boolean bold;
        boolean italic;
        boolean ignoredCssClass;

        ElementDecoratorData() {
        }
    }

    private class PreStack
    extends Stack<String> {
        private PreStack() {
        }

        @Override
        public String push(String item) {
            String push = super.push(item);
            XHtmlElementToWikiTranslator.this.outTrimmer.setWhitespaceTrimMode(this.isEmpty());
            return push;
        }

        @Override
        public synchronized String pop() {
            String pop = (String)super.pop();
            XHtmlElementToWikiTranslator.this.outTrimmer.setWhitespaceTrimMode(this.isEmpty());
            return pop;
        }
    }
}

