/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.filters;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.filters.BasePageFilter;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.XmlRpcClient;

public class PingWeblogsComFilter
extends BasePageFilter {
    private static final Logger log = LogManager.getLogger(PingWeblogsComFilter.class);
    private String m_pingURL;
    public static final String PROP_PINGURL = "pingurl";

    public void initialize(Engine engine, Properties props) {
        this.m_pingURL = props.getProperty(PROP_PINGURL, "http://rpc.weblogs.com/RPC2");
    }

    public void postSave(Context context, String pagecontent) {
        String blogName = context.getPage().getName();
        Engine engine = context.getEngine();
        int blogentryTxt = blogName.indexOf("_blogentry_");
        if (blogentryTxt == -1) {
            return;
        }
        if ((blogName = blogName.substring(0, blogentryTxt)).equals(engine.getFrontPage())) {
            blogName = null;
        }
        try {
            XmlRpcClient xmlrpc = new XmlRpcClient(this.m_pingURL);
            Vector<String> params = new Vector<String>();
            params.addElement("The Butt Ugly Weblog");
            params.addElement(engine.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), blogName, null));
            if (log.isDebugEnabled()) {
                log.debug("Pinging weblogs.com with URL: " + engine.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), blogName, null));
            }
            xmlrpc.executeAsync("weblogUpdates.ping", params, new AsyncCallback(){

                public void handleError(Exception ex, URL url, String method) {
                    log.error("Unable to execute weblogs.com ping to URL: " + url.toString(), (Throwable)ex);
                }

                public void handleResult(Object result, URL url, String method) {
                    Hashtable res = (Hashtable)result;
                    Boolean flerror = (Boolean)res.get("flerror");
                    String msg = (String)res.get("message");
                    if (flerror.booleanValue()) {
                        log.error("Failed to ping: " + msg);
                    }
                    log.info("Weblogs.com has been pinged.");
                }
            });
        }
        catch (MalformedURLException e) {
            log.error("Malformed URL", (Throwable)e);
        }
    }
}

