/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.filters;

import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.FilterException;
import org.apache.wiki.api.filters.BasePageFilter;
import org.apache.wiki.parser.CreoleToJSPWikiTranslator;

public class CreoleFilter
extends BasePageFilter {
    private static final Logger log = LogManager.getLogger(CreoleFilter.class);

    public void initialize(Engine engine, Properties props) throws FilterException {
        super.initialize(engine, props);
    }

    public String preSave(Context wikiContext, String content) {
        try {
            String username = wikiContext.getCurrentUser().getName();
            Properties prop = this.m_engine.getWikiProperties();
            return new CreoleToJSPWikiTranslator().translateSignature(prop, content, username);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
    }

    public String preTranslate(Context wikiContext, String content) {
        try {
            Properties prop = this.m_engine.getWikiProperties();
            return new CreoleToJSPWikiTranslator().translate(prop, content);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return content + "\n \n %%error \n[CreoleFilterError]: This page was not translated by the CreoleFilter due to the following error: " + e.getMessage() + "\n \n%%\n \n";
        }
    }
}

