/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.util.comparators.PrincipalComparator;

public class SessionMonitor
implements HttpSessionListener {
    private static final Logger log = LogManager.getLogger(SessionMonitor.class);
    private static final ConcurrentHashMap<Engine, SessionMonitor> c_monitors = new ConcurrentHashMap();
    private final Map<String, Session> m_sessions = new WeakHashMap<String, Session>();
    private Engine m_engine;
    private final PrincipalComparator m_comparator = new PrincipalComparator();

    public static SessionMonitor getInstance(Engine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Engine cannot be null.");
        }
        SessionMonitor monitor = c_monitors.get(engine);
        if (monitor == null) {
            monitor = new SessionMonitor(engine);
            c_monitors.put(engine, monitor);
        }
        return monitor;
    }

    public SessionMonitor() {
    }

    private SessionMonitor(Engine engine) {
        this.m_engine = engine;
    }

    private Session findSession(HttpSession session) {
        String sid = session == null ? "(null)" : session.getId();
        return this.findSession(sid);
    }

    private Session findSession(String sessionId) {
        Session wikiSession = null;
        String sid = sessionId == null ? "(null)" : sessionId;
        Session storedSession = this.m_sessions.get(sid);
        if (storedSession != null) {
            if (log.isDebugEnabled()) {
                log.debug("Looking up WikiSession for session ID=" + sid + "... found it");
            }
            wikiSession = storedSession;
        }
        return wikiSession;
    }

    public final Session find(HttpSession session) {
        String sid;
        Session wikiSession = this.findSession(session);
        String string = sid = session == null ? "(null)" : session.getId();
        if (wikiSession == null) {
            return this.createGuestSessionFor(sid);
        }
        return wikiSession;
    }

    public final Session find(String sessionId) {
        Session wikiSession = this.findSession(sessionId);
        if (wikiSession == null) {
            return this.createGuestSessionFor(sessionId);
        }
        return wikiSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session createGuestSessionFor(String sessionId) {
        if (log.isDebugEnabled()) {
            log.debug("Session for session ID=" + sessionId + "... not found. Creating guestSession()");
        }
        Session wikiSession = Wiki.session().guest(this.m_engine);
        Map<String, Session> map = this.m_sessions;
        synchronized (map) {
            this.m_sessions.put(sessionId, wikiSession);
        }
        return wikiSession;
    }

    public final void remove(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null.");
        }
        this.remove(request.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(HttpSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null.");
        }
        Map<String, Session> map = this.m_sessions;
        synchronized (map) {
            this.m_sessions.remove(session.getId());
        }
    }

    public final int sessions() {
        return this.userPrincipals().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Principal[] userPrincipals() {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        Map<String, Session> map = this.m_sessions;
        synchronized (map) {
            for (Session session : this.m_sessions.values()) {
                principals.add(session.getUserPrincipal());
            }
        }
        Principal[] p = principals.toArray(new Principal[0]);
        Arrays.sort(p, this.m_comparator);
        return p;
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener((Object)this, (WikiEventListener)listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener((Object)this, (WikiEventListener)listener);
    }

    protected final void fireEvent(int type, Principal principal, Session session) {
        if (WikiEventManager.isListening((Object)this)) {
            WikiEventManager.fireEvent((Object)this, (WikiEvent)new WikiSecurityEvent((Object)this, type, principal, (Object)session));
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        log.debug("Created session: " + session.getId() + ".");
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        for (SessionMonitor monitor : c_monitors.values()) {
            Session storedSession = monitor.findSession(session);
            monitor.remove(session);
            log.debug("Removed session " + session.getId() + ".");
            if (storedSession == null) continue;
            this.fireEvent(45, storedSession.getLoginPrincipal(), storedSession);
        }
    }
}

