/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.attachment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.RedirectException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.ui.progress.ProgressItem;
import org.apache.wiki.ui.progress.ProgressManager;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.TextUtil;

public class AttachmentServlet
extends HttpServlet {
    private static final int BUFFER_SIZE = 8192;
    private static final long serialVersionUID = 3257282552187531320L;
    private Engine m_engine;
    private static final Logger log = LogManager.getLogger(AttachmentServlet.class);
    private static final String HDR_VERSION = "version";
    protected static final long DEFAULT_EXPIRY = 86400000L;
    private int m_maxSize = Integer.MAX_VALUE;
    private String[] m_allowedPatterns;
    private String[] m_forbiddenPatterns;

    public void init(ServletConfig config) throws ServletException {
        this.m_engine = Wiki.engine().find(config);
        Properties props = this.m_engine.getWikiProperties();
        String tmpDir = this.m_engine.getWorkDir() + File.separator + "attach-tmp";
        String allowed = TextUtil.getStringProperty((Properties)props, (String)"jspwiki.attachment.allowed", null);
        this.m_maxSize = TextUtil.getIntegerProperty((Properties)props, (String)"jspwiki.attachment.maxsize", (int)Integer.MAX_VALUE);
        this.m_allowedPatterns = allowed != null && !allowed.isEmpty() ? allowed.toLowerCase().split("\\s") : new String[0];
        String forbidden = TextUtil.getStringProperty((Properties)props, (String)"jspwiki.attachment.forbidden", null);
        this.m_forbiddenPatterns = forbidden != null && !forbidden.isEmpty() ? forbidden.toLowerCase().split("\\s") : new String[0];
        File f = new File(tmpDir);
        if (!f.exists()) {
            f.mkdirs();
        } else if (!f.isDirectory()) {
            log.fatal("A file already exists where the temporary dir is supposed to be: " + tmpDir + ".  Please remove it.");
        }
        log.debug("UploadServlet initialized. Using " + tmpDir + " for temporary storage.");
    }

    private boolean isTypeAllowed(String name) {
        int i;
        if (name == null || name.isEmpty()) {
            return false;
        }
        name = name.toLowerCase();
        for (i = 0; i < this.m_forbiddenPatterns.length; ++i) {
            if (!name.endsWith(this.m_forbiddenPatterns[i]) || this.m_forbiddenPatterns[i].isEmpty()) continue;
            return false;
        }
        for (i = 0; i < this.m_allowedPatterns.length; ++i) {
            if (!name.endsWith(this.m_allowedPatterns[i]) || this.m_allowedPatterns[i].isEmpty()) continue;
            return true;
        }
        return this.m_allowedPatterns.length == 0;
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) {
        res.setHeader("Allow", "GET, PUT, POST, OPTIONS, PROPFIND, PROPPATCH, MOVE, COPY, DELETE");
        res.setStatus(200);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        block46: {
            Context context = Wiki.context().create(this.m_engine, req, ContextEnum.PAGE_ATTACH.getRequestContext());
            AttachmentManager mgr = (AttachmentManager)this.m_engine.getManager(AttachmentManager.class);
            AuthorizationManager authmgr = (AuthorizationManager)this.m_engine.getManager(AuthorizationManager.class);
            String version = req.getParameter(HDR_VERSION);
            String nextPage = req.getParameter("nextpage");
            String page = context.getPage().getName();
            int ver = -1;
            if (page == null) {
                log.info("Invalid attachment name.");
                res.sendError(400);
                return;
            }
            try (ServletOutputStream out = res.getOutputStream();){
                org.apache.wiki.api.core.Attachment att;
                log.debug("Attempting to download att " + page + ", version " + version);
                if (version != null) {
                    ver = Integer.parseInt(version);
                }
                if ((att = mgr.getAttachmentInfo(page, ver)) != null) {
                    PagePermission permission = PermissionFactory.getPagePermission((Page)att, "view");
                    if (!authmgr.checkPermission(context.getWikiSession(), permission)) {
                        log.debug("User does not have permission for this");
                        res.sendError(403);
                        return;
                    }
                    if (HttpUtil.checkFor304((HttpServletRequest)req, (String)att.getName(), (Date)att.getLastModified())) {
                        log.debug("Client has latest version already, sending 304...");
                        res.sendError(304);
                        return;
                    }
                    String mimetype = AttachmentServlet.getMimeType(context, att.getFileName());
                    res.setContentType(mimetype);
                    res.addHeader("Content-Disposition", "inline; filename=\"" + att.getFileName() + "\";");
                    res.addDateHeader("Last-Modified", att.getLastModified().getTime());
                    if (!att.isCacheable()) {
                        res.addHeader("Pragma", "no-cache");
                        res.addHeader("Cache-control", "no-cache");
                    }
                    if (att.getSize() >= 0L) {
                        res.setContentLength((int)att.getSize());
                    }
                    try (InputStream in = mgr.getAttachmentStream(context, att);){
                        int read;
                        byte[] buffer = new byte[8192];
                        while ((read = in.read(buffer)) > -1) {
                            out.write(buffer, 0, read);
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Attachment " + att.getFileName() + " sent to " + req.getRemoteUser() + " on " + HttpUtil.getRemoteAddress((HttpServletRequest)req));
                    }
                    if (nextPage != null) {
                        res.sendRedirect(this.validateNextPage(TextUtil.urlEncodeUTF8((String)nextPage), this.m_engine.getURL(ContextEnum.WIKI_ERROR.getRequestContext(), "", null)));
                    }
                    break block46;
                }
                String msg = "Attachment '" + page + "', version " + ver + " does not exist.";
                log.info(msg);
                res.sendError(404, msg);
            }
            catch (ProviderException pe) {
                log.debug("Provider failed while reading", (Throwable)pe);
                this.sendError(res, "Provider error: " + pe.getMessage());
            }
            catch (NumberFormatException nfe) {
                log.warn("Invalid version number: " + version);
                res.sendError(400, "Invalid version number");
            }
            catch (SocketException se) {
                log.debug("I/O exception during download", (Throwable)se);
            }
            catch (IOException ioe) {
                log.debug("I/O exception during download", (Throwable)ioe);
                this.sendError(res, "Error: " + ioe.getMessage());
            }
        }
    }

    void sendError(HttpServletResponse res, String message) throws IOException {
        try {
            res.sendError(500, message);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static String getMimeType(Context ctx, String fileName) {
        ServletContext s;
        String mimetype = null;
        HttpServletRequest req = ctx.getHttpRequest();
        if (req != null && (s = req.getSession().getServletContext()) != null) {
            mimetype = s.getMimeType(fileName.toLowerCase());
        }
        if (mimetype == null) {
            mimetype = "application/binary";
        }
        return mimetype;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try {
            String nextPage = this.upload(req);
            req.getSession().removeAttribute("msg");
            res.sendRedirect(nextPage);
        }
        catch (RedirectException e) {
            Session session = Wiki.session().find(this.m_engine, req);
            session.addMessage(e.getMessage());
            req.getSession().setAttribute("msg", (Object)e.getMessage());
            res.sendRedirect(e.getRedirect());
        }
    }

    private String validateNextPage(String nextPage, String errorPage) {
        if (nextPage.contains("://") && !nextPage.startsWith(this.m_engine.getBaseURL())) {
            log.warn("Detected phishing attempt by redirecting to an unsecure location: " + nextPage);
            nextPage = errorPage;
        }
        return nextPage;
    }

    protected String upload(HttpServletRequest req) throws RedirectException, IOException {
        String errorPage;
        String attName = "(unknown)";
        String nextPage = errorPage = this.m_engine.getURL(ContextEnum.WIKI_ERROR.getRequestContext(), "", null);
        String progressId = req.getParameter("progressid");
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            throw new RedirectException("Not a file upload", errorPage);
        }
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            Context context = Wiki.context().create(this.m_engine, req, ContextEnum.PAGE_ATTACH.getRequestContext());
            UploadListener pl = new UploadListener();
            ((ProgressManager)this.m_engine.getManager(ProgressManager.class)).startProgress(pl, progressId);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setHeaderEncoding(StandardCharsets.UTF_8.name());
            if (!context.hasAdminPermissions()) {
                upload.setFileSizeMax((long)this.m_maxSize);
            }
            upload.setProgressListener((ProgressListener)pl);
            List items = upload.parseRequest(req);
            String wikipage = null;
            String changeNote = null;
            ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
            for (FileItem item : items) {
                if (item.isFormField()) {
                    switch (item.getFieldName()) {
                        case "page": {
                            wikipage = item.getString(StandardCharsets.UTF_8.name());
                            int x = wikipage.indexOf("/");
                            if (x == -1) break;
                            wikipage = wikipage.substring(0, x);
                            break;
                        }
                        case "changenote": {
                            changeNote = item.getString(StandardCharsets.UTF_8.name());
                            if (changeNote == null) break;
                            changeNote = TextUtil.replaceEntities((String)changeNote);
                            break;
                        }
                        case "nextpage": {
                            nextPage = this.validateNextPage(item.getString(StandardCharsets.UTF_8.name()), errorPage);
                        }
                    }
                    continue;
                }
                fileItems.add(item);
            }
            if (fileItems.size() == 0) {
                throw new RedirectException("Broken file upload", errorPage);
            }
            for (FileItem actualFile : fileItems) {
                String filename = actualFile.getName();
                long fileSize = actualFile.getSize();
                InputStream in = actualFile.getInputStream();
                Throwable throwable = null;
                try {
                    this.executeUpload(context, in, filename, nextPage, wikipage, changeNote, fileSize);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (ProviderException e) {
            String msg = "Upload failed because the provider failed: " + e.getMessage();
            log.warn(msg + " (attachment: " + "(unknown)" + ")", (Throwable)e);
            throw new IOException(msg);
        }
        catch (IOException e) {
            String msg = "Upload failure: " + e.getMessage();
            log.warn(msg + " (attachment: " + "(unknown)" + ")", (Throwable)e);
            throw e;
        }
        catch (FileUploadException e) {
            String msg = "Upload failure: " + e.getMessage();
            log.warn(msg + " (attachment: " + "(unknown)" + ")", (Throwable)e);
            throw new IOException(msg, e);
        }
        finally {
            ((ProgressManager)this.m_engine.getManager(ProgressManager.class)).stopProgress(progressId);
        }
        return nextPage;
    }

    protected boolean executeUpload(Context context, InputStream data, String filename, String errorPage, String parentPage, String changenote, long contentLength) throws RedirectException, IOException, ProviderException {
        boolean created = false;
        try {
            filename = AttachmentManager.validateFileName(filename);
        }
        catch (WikiException e) {
            throw new RedirectException(Preferences.getBundle(context, "CoreResources").getString(e.getMessage()), errorPage);
        }
        if (!context.hasAdminPermissions()) {
            if (contentLength > (long)this.m_maxSize) {
                throw new RedirectException("File exceeds maximum size (" + this.m_maxSize + " bytes)", errorPage);
            }
            if (!this.isTypeAllowed(filename)) {
                throw new RedirectException("Files of this type may not be uploaded to this wiki", errorPage);
            }
        }
        Principal user = context.getCurrentUser();
        AttachmentManager mgr = (AttachmentManager)this.m_engine.getManager(AttachmentManager.class);
        log.debug("file=" + filename);
        if (data == null) {
            log.error("File could not be opened.");
            throw new RedirectException("File could not be opened.", errorPage);
        }
        org.apache.wiki.api.core.Attachment att = mgr.getAttachmentInfo(context.getPage().getName());
        if (att == null) {
            att = new Attachment(this.m_engine, parentPage, filename);
            created = true;
        }
        att.setSize(contentLength);
        PagePermission permission = PermissionFactory.getPagePermission((Page)att, "upload");
        if (((AuthorizationManager)this.m_engine.getManager(AuthorizationManager.class)).checkPermission(context.getWikiSession(), permission)) {
            if (user != null) {
                att.setAuthor(user.getName());
            }
            if (changenote != null && !changenote.isEmpty()) {
                att.setAttribute("changenote", (Object)changenote);
            }
            try {
                ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).storeAttachment(att, data);
            }
            catch (ProviderException pe) {
                throw new ProviderException(Preferences.getBundle(context, "CoreResources").getString(pe.getMessage()));
            }
        } else {
            throw new RedirectException("No permission to upload a file", errorPage);
        }
        log.info("User " + user + " uploaded attachment to " + parentPage + " called " + filename + ", size " + att.getSize());
        return created;
    }

    private static class UploadListener
    extends ProgressItem
    implements ProgressListener {
        public long m_currentBytes;
        public long m_totalBytes;

        private UploadListener() {
        }

        public void update(long recvdBytes, long totalBytes, int item) {
            this.m_currentBytes = recvdBytes;
            this.m_totalBytes = totalBytes;
        }

        @Override
        public int getProgress() {
            return (int)((double)((float)this.m_currentBytes / (float)this.m_totalBytes * 100.0f) + 0.5);
        }
    }
}

