/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.util.TextUtil;

public final class MailUtil {
    private static final String JAVA_COMP_ENV = "java:comp/env";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static boolean c_useJndi = true;
    private static final String PROP_MAIL_AUTH = "mail.smtp.auth";
    static final Logger log = LogManager.getLogger(MailUtil.class);
    static final String DEFAULT_MAIL_JNDI_NAME = "mail/Session";
    static final String DEFAULT_MAIL_HOST = "localhost";
    static final String DEFAULT_MAIL_PORT = "25";
    static final String DEFAULT_MAIL_TIMEOUT = "5000";
    static final String DEFAULT_MAIL_CONN_TIMEOUT = "5000";
    static final String DEFAULT_SENDER = "jspwiki@localhost";
    static final String PROP_MAIL_JNDI_NAME = "jspwiki.mail.jndiname";
    static final String PROP_MAIL_HOST = "mail.smtp.host";
    static final String PROP_MAIL_PORT = "mail.smtp.port";
    static final String PROP_MAIL_ACCOUNT = "mail.smtp.account";
    static final String PROP_MAIL_PASSWORD = "mail.smtp.password";
    static final String PROP_MAIL_TIMEOUT = "mail.smtp.timeout";
    static final String PROP_MAIL_CONNECTION_TIMEOUT = "mail.smtp.connectiontimeout";
    static final String PROP_MAIL_TRANSPORT = "smtp";
    static final String PROP_MAIL_SENDER = "mail.from";
    static final String PROP_MAIL_STARTTLS = "mail.smtp.starttls.enable";
    private static String c_fromAddress;

    private MailUtil() {
    }

    public static void sendMessage(Properties props, String to, String subject, String content) throws AddressException, MessagingException {
        Session session = MailUtil.getMailSession(props);
        MailUtil.getSenderEmailAddress(session, props);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(c_fromAddress));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
            msg.setSubject(subject, StandardCharsets.UTF_8.name());
            msg.setText(content, StandardCharsets.UTF_8.name());
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            if (log.isInfoEnabled()) {
                log.info("Sent e-mail to=" + to + ", subject=\"" + subject + "\", used " + (c_useJndi ? "JNDI" : "standalone") + " mail session.");
            }
        }
        catch (MessagingException e) {
            log.error((Object)e);
            throw e;
        }
    }

    static String getSenderEmailAddress(Session pSession, Properties pProperties) {
        if (c_fromAddress == null) {
            if (pSession != null && c_useJndi) {
                c_fromAddress = pSession.getProperty(PROP_MAIL_SENDER);
            }
            if (c_fromAddress == null) {
                c_fromAddress = pProperties.getProperty(PROP_MAIL_SENDER, DEFAULT_SENDER).trim();
                if (log.isDebugEnabled()) {
                    log.debug("Attempt to get the sender's mail address from the JNDI mail session failed, will use \"" + c_fromAddress + "\" (configured via jspwiki.properties or the internal default).");
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Attempt to get the sender's mail address from the JNDI mail session was successful (" + c_fromAddress + ").");
            }
        }
        return c_fromAddress;
    }

    private static Session getMailSession(Properties props) {
        Session result;
        block6: {
            result = null;
            String jndiName = props.getProperty(PROP_MAIL_JNDI_NAME, DEFAULT_MAIL_JNDI_NAME).trim();
            if (c_useJndi) {
                if (log.isDebugEnabled()) {
                    log.debug("Try getting a mail session via JNDI name \"" + jndiName + "\".");
                }
                try {
                    result = MailUtil.getJNDIMailSession(jndiName);
                }
                catch (NamingException e) {
                    c_useJndi = false;
                    if (!log.isInfoEnabled()) break block6;
                    log.info("Unable to get a mail session via JNDI, will use custom settings at least until next startup.");
                }
            }
        }
        if (result == null) {
            if (log.isDebugEnabled()) {
                log.debug("Getting a standalone mail session configured by jspwiki.properties and/or internal default values.");
            }
            result = MailUtil.getStandaloneMailSession(props);
        }
        return result;
    }

    static Session getStandaloneMailSession(Properties props) {
        String host = props.getProperty(PROP_MAIL_HOST, DEFAULT_MAIL_HOST);
        String port = props.getProperty(PROP_MAIL_PORT, DEFAULT_MAIL_PORT);
        String account = props.getProperty(PROP_MAIL_ACCOUNT);
        String password = props.getProperty(PROP_MAIL_PASSWORD);
        String timeout = props.getProperty(PROP_MAIL_TIMEOUT, "5000");
        String conntimeout = props.getProperty(PROP_MAIL_CONNECTION_TIMEOUT, "5000");
        boolean starttls = TextUtil.getBooleanProperty(props, PROP_MAIL_STARTTLS, true);
        boolean useAuthentication = account != null && !account.isEmpty();
        Properties mailProps = new Properties();
        mailProps.put(PROP_MAIL_HOST, host);
        mailProps.put(PROP_MAIL_PORT, port);
        mailProps.put(PROP_MAIL_TIMEOUT, timeout);
        mailProps.put(PROP_MAIL_CONNECTION_TIMEOUT, conntimeout);
        mailProps.put(PROP_MAIL_STARTTLS, starttls ? TRUE : FALSE);
        Session session = null;
        if (useAuthentication) {
            mailProps.put(PROP_MAIL_AUTH, TRUE);
            SmtpAuthenticator auth = new SmtpAuthenticator(account, password);
            session = Session.getInstance((Properties)mailProps, (Authenticator)auth);
        } else {
            session = Session.getInstance((Properties)mailProps);
        }
        if (log.isDebugEnabled()) {
            String mailServer = host + ":" + port + ", account=" + account + ", password not displayed, timeout=" + timeout + ", connectiontimeout=" + conntimeout + ", starttls.enable=" + starttls + ", use authentication=" + (useAuthentication ? TRUE : FALSE);
            log.debug("JavaMail session obtained from standalone mail factory: " + mailServer);
        }
        return session;
    }

    static Session getJNDIMailSession(String jndiName) throws NamingException {
        Session session = null;
        try {
            InitialContext initCtx = new InitialContext();
            Context ctx = (Context)initCtx.lookup(JAVA_COMP_ENV);
            session = (Session)ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            log.warn("JNDI mail session initialization error: " + e.getMessage());
            throw e;
        }
        if (log.isDebugEnabled()) {
            log.debug("mail session obtained from JNDI mail factory: " + jndiName);
        }
        return session;
    }

    protected static class SmtpAuthenticator
    extends Authenticator {
        private static final String BLANK = "";
        private final String m_pass;
        private final String m_login;

        public SmtpAuthenticator(String login, String pass) {
            this.m_login = login == null ? BLANK : login;
            this.m_pass = pass == null ? BLANK : pass;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            if (BLANK.equals(this.m_pass)) {
                return null;
            }
            return new PasswordAuthentication(this.m_login, this.m_pass);
        }
    }
}

