/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.renderer;

import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import java.util.HashSet;
import java.util.Set;
import org.apache.wiki.markdown.nodes.JSPWikiLink;

public class JSPWikiLinkRenderer
implements NodeRenderer {
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(JSPWikiLink.class, (NodeRenderingHandler.CustomNodeRenderer)new NodeRenderingHandler.CustomNodeRenderer<JSPWikiLink>(){

            public void render(JSPWikiLink node, NodeRendererContext context, HtmlWriter html) {
                if (context.isDoNotRenderLinks()) {
                    context.renderChildren((Node)node);
                } else {
                    ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)node.getUrl().unescape(), null);
                    html.attr((CharSequence)"href", (CharSequence)resolvedLink.getUrl());
                    if (node.getTitle().isNotNull()) {
                        html.attr((CharSequence)"title", (CharSequence)node.getTitle().unescape());
                    }
                    html.srcPos(node.getChars()).withAttr(resolvedLink).tag((CharSequence)"a");
                    context.renderChildren((Node)node);
                    html.tag((CharSequence)"/a");
                }
            }
        }));
        return set;
    }
}

