/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor;

import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorStateCommonOperations;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.parser.LinkParsingOperations;

public class ImageLinkNodePostProcessorState
implements NodePostProcessorState<JSPWikiLink> {
    private final boolean isLinkFromText;
    private final String urlRef;
    private final LinkParsingOperations linkOperations;

    public ImageLinkNodePostProcessorState(Context wikiContext, String urlRef, boolean isLinkFromText) {
        this.isLinkFromText = isLinkFromText;
        this.urlRef = urlRef;
        this.linkOperations = new LinkParsingOperations(wikiContext);
    }

    @Override
    public void process(NodeTracker state, JSPWikiLink link) {
        HtmlInline img = new HtmlInline((BasedSequence)CharSubSequence.of((CharSequence)("<img class=\"inline\" src=\"" + this.urlRef + "\" alt=\"" + link.getText().toString() + "\" />")));
        if (this.isLinkFromText && this.linkOperations.isExternalLink(link.getText().toString()) || this.isLinkFromText && this.linkOperations.linkExists(link.getText().toString())) {
            link.setUrl((BasedSequence)CharSubSequence.of((CharSequence)this.urlRef));
            link.removeChildren();
            link.appendChild((Node)img);
            state.nodeAdded((Node)img);
        } else {
            NodePostProcessorStateCommonOperations.addContent(state, (Node)link, (Node)img);
        }
    }
}

