/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.BaseValidation;

public class UniqueItemsValidation
implements ValidationExtension {
    @Override
    public Optional<Function<JsonValue, Stream<ValidationResult.ValidationError>>> create(ValidationContext model) {
        return Optional.ofNullable(model.getSchema().get((Object)"uniqueItems")).filter(it -> it.getValueType() == JsonValue.ValueType.TRUE).map(max -> new Impl(model.toPointer(), (Function)model.getValueProvider()));
    }

    private static class Impl
    extends BaseValidation {
        private Impl(String pointer, Function<JsonValue, JsonValue> extractor) {
            super(pointer, extractor, JsonValue.ValueType.ARRAY);
        }

        @Override
        protected Stream<ValidationResult.ValidationError> onArray(JsonArray array) {
            HashSet uniques = new HashSet(array);
            if (array.size() != uniques.size()) {
                ArrayList duplicated = new ArrayList(array);
                duplicated.removeAll(uniques);
                return Stream.of(new ValidationResult.ValidationError(this.pointer, "duplicated items: " + duplicated));
            }
            return Stream.empty();
        }

        public String toString() {
            return "UniqueItems{pointer='" + this.pointer + '\'' + '}';
        }
    }
}

