/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.filter_functions;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.UnitsConversionException;
import org.apache.jena.geosparql.implementation.index.GeometryLiteralIndex;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase3;
import org.apache.jena.sparql.util.FmtUtils;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class DistanceFF
extends FunctionBase3 {
    @Override
    public NodeValue exec(NodeValue v1, NodeValue v2, NodeValue v3) {
        try {
            GeometryWrapper geometry1 = GeometryWrapper.extract(v1, GeometryLiteralIndex.GeometryIndex.PRIMARY);
            GeometryWrapper geometry2 = GeometryWrapper.extract(v2, GeometryLiteralIndex.GeometryIndex.SECONDARY);
            if (!v3.isIRI() && !v3.isString()) {
                throw new ExprEvalException("Not an IRI or String: " + FmtUtils.stringForNode(v3.asNode()));
            }
            String unitsURI = v3.isIRI() ? v3.asNode().getURI() : v3.asString();
            double distance = geometry1.distance(geometry2, unitsURI);
            return NodeValue.makeDouble(distance);
        }
        catch (DatatypeFormatException | UnitsConversionException | MismatchedDimensionException | TransformException | FactoryException ex) {
            throw new ExprEvalException(ex.getMessage(), ex);
        }
    }
}

