/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryCollectionIterator;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class PointLocator {
    private BoundaryNodeRule boundaryRule = BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE;
    private boolean isIn;
    private int numBoundaries;

    public PointLocator() {
    }

    public PointLocator(BoundaryNodeRule boundaryRule) {
        if (boundaryRule == null) {
            throw new IllegalArgumentException("Rule must be non-null");
        }
        this.boundaryRule = boundaryRule;
    }

    public boolean intersects(Coordinate p, Geometry geom) {
        return this.locate(p, geom) != 2;
    }

    public int locate(Coordinate p, Geometry geom) {
        if (geom.isEmpty()) {
            return 2;
        }
        if (geom instanceof LineString) {
            return this.locateOnLineString(p, (LineString)geom);
        }
        if (geom instanceof Polygon) {
            return this.locateInPolygon(p, (Polygon)geom);
        }
        this.isIn = false;
        this.numBoundaries = 0;
        this.computeLocation(p, geom);
        if (this.boundaryRule.isInBoundary(this.numBoundaries)) {
            return 1;
        }
        if (this.numBoundaries > 0 || this.isIn) {
            return 0;
        }
        return 2;
    }

    private void computeLocation(Coordinate p, Geometry geom) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (geom.isEmpty()) {
                                return;
                            }
                            if (geom instanceof Point) {
                                this.updateLocationInfo(this.locateOnPoint(p, (Point)geom));
                            }
                            if (!(geom instanceof LineString)) break block5;
                            this.updateLocationInfo(this.locateOnLineString(p, (LineString)geom));
                            break block6;
                        }
                        if (!(geom instanceof Polygon)) break block7;
                        this.updateLocationInfo(this.locateInPolygon(p, (Polygon)geom));
                        break block6;
                    }
                    if (!(geom instanceof MultiLineString)) break block8;
                    MultiLineString ml = (MultiLineString)geom;
                    for (int i = 0; i < ml.getNumGeometries(); ++i) {
                        LineString l = (LineString)ml.getGeometryN(i);
                        this.updateLocationInfo(this.locateOnLineString(p, l));
                    }
                    break block6;
                }
                if (!(geom instanceof MultiPolygon)) break block9;
                MultiPolygon mpoly = (MultiPolygon)geom;
                for (int i = 0; i < mpoly.getNumGeometries(); ++i) {
                    Polygon poly = (Polygon)mpoly.getGeometryN(i);
                    this.updateLocationInfo(this.locateInPolygon(p, poly));
                }
                break block6;
            }
            if (!(geom instanceof GeometryCollection)) break block6;
            GeometryCollectionIterator geomi = new GeometryCollectionIterator((GeometryCollection)geom);
            while (geomi.hasNext()) {
                Geometry g2 = (Geometry)geomi.next();
                if (g2 == geom) continue;
                this.computeLocation(p, g2);
            }
        }
    }

    private void updateLocationInfo(int loc) {
        if (loc == 0) {
            this.isIn = true;
        }
        if (loc == 1) {
            ++this.numBoundaries;
        }
    }

    private int locateOnPoint(Coordinate p, Point pt) {
        Coordinate ptCoord = pt.getCoordinate();
        if (ptCoord.equals2D(p)) {
            return 0;
        }
        return 2;
    }

    private int locateOnLineString(Coordinate p, LineString l) {
        if (!l.getEnvelopeInternal().intersects(p)) {
            return 2;
        }
        CoordinateSequence seq2 = l.getCoordinateSequence();
        if (p.equals(seq2.getCoordinate(0)) || p.equals(seq2.getCoordinate(seq2.size() - 1))) {
            int boundaryCount = l.isClosed() ? 2 : 1;
            int loc = this.boundaryRule.isInBoundary(boundaryCount) ? 1 : 0;
            return loc;
        }
        if (PointLocation.isOnLine(p, seq2)) {
            return 0;
        }
        return 2;
    }

    private int locateInPolygonRing(Coordinate p, LinearRing ring) {
        if (!ring.getEnvelopeInternal().intersects(p)) {
            return 2;
        }
        return PointLocation.locateInRing(p, ring.getCoordinates());
    }

    private int locateInPolygon(Coordinate p, Polygon poly) {
        if (poly.isEmpty()) {
            return 2;
        }
        LinearRing shell = poly.getExteriorRing();
        int shellLoc = this.locateInPolygonRing(p, shell);
        if (shellLoc == 2) {
            return 2;
        }
        if (shellLoc == 1) {
            return 1;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            LinearRing hole = poly.getInteriorRingN(i);
            int holeLoc = this.locateInPolygonRing(p, hole);
            if (holeLoc == 0) {
                return 2;
            }
            if (holeLoc != 1) continue;
            return 1;
        }
        return 0;
    }
}

