/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.util;

import jakarta.xml.bind.annotation.XmlTransient;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Set;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.quality.DefaultAbsoluteExternalPositionalAccuracy;
import org.apache.sis.metadata.iso.quality.DefaultConformanceResult;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;

@XmlTransient
public final class PositionalAccuracyConstant
extends DefaultAbsoluteExternalPositionalAccuracy {
    private static final long serialVersionUID = -2554090935254116470L;
    public static final double UNKNOWN_ACCURACY = 3000.0;
    private static final double DATUM_SHIFT_ACCURACY = 25.0;
    public static final double INDIRECT_SHIFT_ACCURACY = 100.0;
    public static final PositionalAccuracy DATUM_SHIFT_APPLIED;
    public static final PositionalAccuracy DATUM_SHIFT_OMITTED;
    public static final PositionalAccuracy INDIRECT_SHIFT_APPLIED;

    private PositionalAccuracyConstant(InternationalString measureDescription, InternationalString evaluationMethodDescription, boolean pass) {
        DefaultConformanceResult result = new DefaultConformanceResult(Citations.SIS, evaluationMethodDescription, pass);
        this.setResults(Set.of(result));
        this.setMeasureDescription(measureDescription);
        this.setEvaluationMethodDescription(evaluationMethodDescription);
        this.setEvaluationMethodType(EvaluationMethodType.DIRECT_INTERNAL);
        this.transitionTo(ModifiableMetadata.State.FINAL);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.equals(DATUM_SHIFT_APPLIED)) {
            return DATUM_SHIFT_APPLIED;
        }
        if (this.equals(DATUM_SHIFT_OMITTED)) {
            return DATUM_SHIFT_OMITTED;
        }
        if (this.equals(INDIRECT_SHIFT_APPLIED)) {
            return INDIRECT_SHIFT_APPLIED;
        }
        return this;
    }

    public static double getLinearAccuracy(CoordinateOperation operation) {
        double accuracy = Double.NaN;
        Collection<PositionalAccuracy> accuracies = operation.getCoordinateOperationAccuracy();
        for (PositionalAccuracy positionalAccuracy : accuracies) {
            for (Result result : positionalAccuracy.getResults()) {
                Unit<?> unit;
                QuantitativeResult quantity;
                Collection<? extends Record> records;
                if (!(result instanceof QuantitativeResult) || (records = (quantity = (QuantitativeResult)result).getValues()) == null || !Units.isLinear(unit = quantity.getValueUnit())) continue;
                Unit<Length> unitOfLength = unit.asType(Length.class);
                for (Record record : records) {
                    for (Object value : record.getAttributes().values()) {
                        if (!(value instanceof Number)) continue;
                        double v = ((Number)value).doubleValue();
                        v = unitOfLength.getConverterTo(Units.METRE).convert(v);
                        if (!(v >= 0.0) || v <= accuracy) continue;
                        accuracy = v;
                    }
                }
            }
        }
        if (Double.isNaN(accuracy)) {
            if (operation instanceof Conversion) {
                return 0.0;
            }
            if (operation instanceof Transformation) {
                for (PositionalAccuracy positionalAccuracy : accuracies) {
                    if (positionalAccuracy == DATUM_SHIFT_APPLIED) {
                        return 25.0;
                    }
                    if (positionalAccuracy == DATUM_SHIFT_OMITTED) {
                        return 3000.0;
                    }
                    if (positionalAccuracy != INDIRECT_SHIFT_APPLIED) continue;
                    return 100.0;
                }
            }
            if (operation instanceof ConcatenatedOperation) {
                for (CoordinateOperation coordinateOperation : ((ConcatenatedOperation)operation).getOperations()) {
                    double candidate = Math.abs(PositionalAccuracyConstant.getLinearAccuracy(coordinateOperation));
                    if (Double.isNaN(candidate)) continue;
                    if (Double.isNaN(accuracy)) {
                        accuracy = candidate;
                        continue;
                    }
                    accuracy += candidate;
                }
            }
        }
        return accuracy;
    }

    static {
        InternationalString desc = Vocabulary.formatInternational((short)200);
        InternationalString eval2 = Resources.formatInternational((short)11);
        DATUM_SHIFT_APPLIED = new PositionalAccuracyConstant(desc, eval2, true);
        DATUM_SHIFT_OMITTED = new PositionalAccuracyConstant(desc, eval2, false);
        INDIRECT_SHIFT_APPLIED = new PositionalAccuracyConstant(desc, eval2, true);
    }
}

