/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractDerivedCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.util.WKTUtilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;

final class ExplicitParameters
extends FormattableObject {
    private final Conversion conversion;
    private final Ellipsoid ellipsoid;
    private final String keyword;

    ExplicitParameters(AbstractDerivedCRS<?> crs, String keyword) {
        this.conversion = crs.getConversionFromBase();
        Datum datum = crs.getDatum();
        this.ellipsoid = datum instanceof GeodeticDatum ? ((GeodeticDatum)datum).getEllipsoid() : null;
        this.keyword = keyword;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendName(this.conversion, formatter, null);
        formatter.newLine();
        this.append(formatter);
        return this.keyword;
    }

    void append(Formatter formatter) {
        formatter.append(DefaultOperationMethod.castOrCopy(this.conversion.getMethod()));
        formatter.newLine();
        for (GeneralParameterValue param : this.conversion.getParameterValues().values()) {
            block6: {
                String name;
                block7: {
                    GeneralParameterDescriptor desc = param.getDescriptor();
                    if (this.ellipsoid == null) break block6;
                    name = "semi_major";
                    if (IdentifiedObjects.isHeuristicMatchForName(desc, "semi_major")) break block7;
                    name = "semi_minor";
                    if (!IdentifiedObjects.isHeuristicMatchForName(desc, "semi_minor")) break block6;
                }
                if (param instanceof ParameterValue) {
                    double expected;
                    double value;
                    try {
                        value = ((ParameterValue)param).doubleValue(this.ellipsoid.getAxisUnit());
                    }
                    catch (IllegalStateException e2) {
                        Logging.recoverableException(WKTUtilities.LOGGER, DefaultProjectedCRS.class, "formatTo", e2);
                        continue;
                    }
                    if (Double.isNaN(value)) continue;
                    double d = expected = name == "semi_minor" ? this.ellipsoid.getSemiMinorAxis() : this.ellipsoid.getSemiMajorAxis();
                    if (value == expected) continue;
                }
            }
            WKTUtilities.append(param, formatter);
        }
    }
}

