/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.ArrayList;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterLateral;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.pfunction.PropFuncArg;

public class Substitute {
    public static Op inject(Op opInput, Binding binding) {
        Set<Var> injectVars = binding.varsMentioned();
        QueryIterLateral.TransformInject transform = new QueryIterLateral.TransformInject(injectVars, binding);
        Op opOutput = Transformer.transform(transform, opInput);
        return opOutput;
    }

    public static Op substitute(Op op, Binding binding) {
        if (Substitute.isNotNeeded(binding)) {
            return op;
        }
        return Transformer.transform(new OpSubstituteWorker(binding), op);
    }

    public static Op substitute(Op op, Var var, Node node) {
        Binding b = BindingFactory.binding(var, node);
        return Substitute.substitute(op, b);
    }

    public static BasicPattern substitute(BasicPattern bgp, Binding binding) {
        if (Substitute.isNotNeeded(binding)) {
            return bgp;
        }
        BasicPattern bgp2 = new BasicPattern();
        for (Triple triple : bgp) {
            Triple t = Substitute.substitute(triple, binding);
            bgp2.add(t);
        }
        return bgp2;
    }

    public static Triple substitute(Triple triple, Binding binding) {
        if (Substitute.isNotNeeded(binding)) {
            return triple;
        }
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        Node s1 = Substitute.substitute(s, binding);
        Node p1 = Substitute.substitute(p, binding);
        Node o1 = Substitute.substitute(o, binding);
        Triple t = triple;
        if (s1 != s || p1 != p || o1 != o) {
            t = Triple.create(s1, p1, o1);
        }
        return t;
    }

    public static TriplePath substitute(TriplePath triplePath, Binding binding) {
        if (Substitute.isNotNeeded(binding)) {
            return triplePath;
        }
        if (triplePath.isTriple()) {
            return new TriplePath(Substitute.substitute(triplePath.asTriple(), binding));
        }
        Node s = triplePath.getSubject();
        Node o = triplePath.getObject();
        Node s1 = Substitute.substitute(s, binding);
        Node o1 = Substitute.substitute(o, binding);
        TriplePath tp = triplePath;
        if (s1 != s || o1 != o) {
            tp = new TriplePath(s1, triplePath.getPath(), o1);
        }
        return tp;
    }

    public static Quad substitute(Quad quad, Binding binding) {
        if (Substitute.isNotNeeded(binding)) {
            return quad;
        }
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g1 = Substitute.substitute(g, binding);
        Node s1 = Substitute.substitute(s, binding);
        Node p1 = Substitute.substitute(p, binding);
        Node o1 = Substitute.substitute(o, binding);
        Quad q = quad;
        if (s1 != s || p1 != p || o1 != o || g1 != g) {
            q = new Quad(g1, s1, p1, o1);
        }
        return q;
    }

    public static Node substitute(Node n, Binding binding) {
        if (n == null) {
            return null;
        }
        if (Substitute.isNotNeeded(binding)) {
            return n;
        }
        if (!n.isTripleTerm()) {
            return Var.lookup(binding::get, n);
        }
        if (n.isConcrete()) {
            return n;
        }
        Triple triple = n.getTriple();
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        Node s1 = Substitute.subTripleTermNode(s, binding);
        Node p1 = Substitute.subTripleTermNode(p, binding);
        Node o1 = Substitute.subTripleTermNode(o, binding);
        if (s1 == s && o1 == o && p1 == p) {
            return n;
        }
        return NodeFactory.createTripleTerm(s1, p1, o1);
    }

    private static Node subTripleTermNode(Node n, Binding binding) {
        if (n.isTripleTerm()) {
            if (!n.isConcrete()) {
                n = Substitute.substitute(n, binding);
            }
        } else if (Var.isVar(n)) {
            Var var = Var.alloc(n);
            n = Var.lookup(binding::get, n);
        }
        return n;
    }

    public static PropFuncArg substitute(PropFuncArg propFuncArg, Binding binding) {
        if (Substitute.isNotNeeded(binding)) {
            return propFuncArg;
        }
        if (propFuncArg.isNode()) {
            Node n = propFuncArg.getArg();
            if (!Var.isVar(n)) {
                return propFuncArg;
            }
            return new PropFuncArg(Substitute.substitute(propFuncArg.getArg(), binding));
        }
        ArrayList<Node> newArgList = new ArrayList<Node>();
        for (Node n : propFuncArg.getArgList()) {
            newArgList.add(Substitute.substitute(n, binding));
        }
        return new PropFuncArg(newArgList);
    }

    public static Expr substitute(Expr expr, Binding binding) {
        if (Substitute.isNotNeeded(binding)) {
            return expr;
        }
        return expr.copySubstitute(binding);
    }

    public static ExprList substitute(ExprList exprList, Binding binding) {
        if (Substitute.isNotNeeded(binding)) {
            return exprList;
        }
        return exprList.copySubstitute(binding);
    }

    private static boolean isNotNeeded(Binding b) {
        return b == null || b.isEmpty();
    }

    private static class OpSubstituteWorker
    extends TransformCopy {
        private Binding binding;

        public OpSubstituteWorker(Binding binding) {
            super(true);
            this.binding = binding;
        }

        @Override
        public Op transform(OpBGP opBGP) {
            BasicPattern bgp = opBGP.getPattern();
            bgp = Substitute.substitute(bgp, this.binding);
            return new OpBGP(bgp);
        }

        @Override
        public Op transform(OpQuadPattern quadPattern) {
            Node gNode = quadPattern.getGraphNode();
            Node g = Substitute.substitute(gNode, this.binding);
            BasicPattern triples = new BasicPattern();
            for (Triple triple : quadPattern.getBasicPattern()) {
                Node s = Substitute.substitute(triple.getSubject(), this.binding);
                Node p = Substitute.substitute(triple.getPredicate(), this.binding);
                Node o = Substitute.substitute(triple.getObject(), this.binding);
                Triple t = Triple.create(s, p, o);
                triples.add(t);
            }
            return new OpQuadPattern(g, triples);
        }

        @Override
        public Op transform(OpPath opPath) {
            return new OpPath(Substitute.substitute(opPath.getTriplePath(), this.binding));
        }

        @Override
        public Op transform(OpPropFunc opPropFunc, Op subOp) {
            PropFuncArg sArgs = opPropFunc.getSubjectArgs();
            PropFuncArg oArgs = opPropFunc.getObjectArgs();
            PropFuncArg sArgs2 = Substitute.substitute(sArgs, this.binding);
            PropFuncArg oArgs2 = Substitute.substitute(oArgs, this.binding);
            if (sArgs2 == sArgs && oArgs2 == oArgs && opPropFunc.getSubOp() == subOp) {
                return super.transform(opPropFunc, subOp);
            }
            return new OpPropFunc(opPropFunc.getProperty(), sArgs2, oArgs2, subOp);
        }

        @Override
        public Op transform(OpFilter filter, Op op) {
            ExprList exprs = filter.getExprs().copySubstitute(this.binding);
            if (exprs == filter.getExprs()) {
                return filter;
            }
            return OpFilter.filterBy(exprs, op);
        }

        @Override
        public Op transform(OpAssign opAssign, Op subOp) {
            VarExprList varExprList2 = this.transformVarExprList(opAssign.getVarExprList());
            if (varExprList2.isEmpty()) {
                return subOp;
            }
            return OpAssign.assign(subOp, varExprList2);
        }

        @Override
        public Op transform(OpExtend opExtend, Op subOp) {
            VarExprList varExprList2 = this.transformVarExprList(opExtend.getVarExprList());
            if (varExprList2.isEmpty()) {
                return subOp;
            }
            return OpExtend.create(subOp, varExprList2);
        }

        private VarExprList transformVarExprList(VarExprList varExprList) {
            VarExprList varExprList2 = new VarExprList();
            for (Var v : varExprList.getVars()) {
                Expr expr = varExprList.getExpr(v);
                expr = expr.copySubstitute(this.binding);
                varExprList2.add(v, expr);
            }
            return varExprList2;
        }

        @Override
        public Op transform(OpGraph op, Op sub) {
            Node n = Substitute.substitute(op.getNode(), this.binding);
            return new OpGraph(n, sub);
        }

        @Override
        public Op transform(OpService op, Op sub) {
            Node n = Substitute.substitute(op.getService(), this.binding);
            return new OpService(n, sub, op.getSilent());
        }
    }
}

