/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.access;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.geosparql.implementation.vocabulary.SpatialExtension;
import org.apache.jena.geosparql.spatial.ConvertLatLon;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.system.G;
import org.apache.jena.system.RDFDataException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessWGS84 {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static boolean containsGeoLiteralProperties(Graph graph) {
        return AccessWGS84.containsGeoLiteralProperties(graph, null);
    }

    public static boolean hasGeoLiteralProperties(Graph graph, Node feature) {
        Objects.requireNonNull(feature);
        return AccessWGS84.containsGeoLiteralProperties(graph, feature);
    }

    public static ExtendedIterator<Triple> findGeoLiteralsAsTriples(Graph graph, Node s) {
        return AccessWGS84.findGeoLiteralsAsTriples(graph, s, Geo.HAS_GEOMETRY_NODE);
    }

    public static ExtendedIterator<Triple> findGeoLiteralsAsTriples(Graph graph, Node s, Node p) {
        return AccessWGS84.findGeoLiterals(graph, s).mapWith(e2 -> Triple.create((Node)e2.getKey(), p, ((GeometryWrapper)e2.getValue()).asNode()));
    }

    public static ExtendedIterator<Map.Entry<Node, GeometryWrapper>> findGeoLiterals(Graph graph, Node s) {
        boolean enableWarnings = false;
        boolean[] loggedMultipleLatLons = new boolean[]{false};
        ExtendedIterator<Triple> latIt = graph.find(s, SpatialExtension.GEO_LAT_NODE, Node.ANY);
        ExtendedIterator<Map.Entry<Node, GeometryWrapper>> result = WrappedIterator.create(Iter.iter(latIt).flatMap(triple -> {
            Node feature = triple.getSubject();
            Node lat = triple.getObject();
            ExtendedIterator<Node> lons = G.iterSP(graph, feature, SpatialExtension.GEO_LON_NODE);
            int[] lonCounter = new int[]{0};
            ExtendedIterator<Map.Entry> r = lons.mapWith(lon -> {
                if (enableWarnings) {
                    if (lonCounter[0] == 1 && !loggedMultipleLatLons[0]) {
                        LOGGER.warn("Geo predicates: multiple longitudes detected on feature " + String.valueOf(feature) + ". Further warnings will be omitted.");
                        loggedMultipleLatLons[0] = true;
                    }
                    lonCounter[0] = lonCounter[0] + 1;
                }
                GeometryWrapper geometryWrapper = ConvertLatLon.toGeometryWrapper(lat, lon);
                return Map.entry(feature, geometryWrapper);
            });
            return r;
        }));
        return result;
    }

    public static Node getGeoLiteral(Graph graph, Node s) {
        Node lat = null;
        try {
            lat = G.getZeroOrOneSP(graph, s, SpatialExtension.GEO_LAT_NODE);
        }
        catch (RDFDataException ex) {
            throw new DatatypeFormatException(String.valueOf(s) + " has more than one geo:lat property.");
        }
        Node lon = null;
        try {
            lon = G.getZeroOrOneSP(graph, s, SpatialExtension.GEO_LON_NODE);
        }
        catch (RDFDataException ex) {
            throw new DatatypeFormatException(String.valueOf(s) + " has more than one geo:lon property.");
        }
        if (lat == null && lon == null) {
            return null;
        }
        if (lat == null) {
            throw new DatatypeFormatException(String.valueOf(s) + " has a geo:lon property but is missing geo:lat.");
        }
        if (lon == null) {
            throw new DatatypeFormatException(String.valueOf(s) + " has a geo:lat property but is missing geo:lon.");
        }
        Node geometryLiteral = ConvertLatLon.toNode(lat, lon);
        return geometryLiteral;
    }

    private static boolean containsGeoLiteralProperties(Graph graph, Node s) {
        boolean result = graph.contains(s, SpatialExtension.GEO_LAT_NODE, null) || graph.contains(s, SpatialExtension.GEO_LON_NODE, null);
        return result;
    }
}

