/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.aop;

import io.micrometer.common.lang.NonNullApi;
import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.WarnThenDebugLogger;
import io.micrometer.core.annotation.Counted;
import io.micrometer.core.aop.CountedMeterTagAnnotationHandler;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
@NonNullApi
public class CountedAspect {
    private static final WarnThenDebugLogger WARN_THEN_DEBUG_LOGGER = new WarnThenDebugLogger(CountedAspect.class);
    private static final Predicate<ProceedingJoinPoint> DONT_SKIP_ANYTHING = pjp -> false;
    public final String DEFAULT_EXCEPTION_TAG_VALUE = "none";
    public final String RESULT_TAG_FAILURE_VALUE = "failure";
    public final String RESULT_TAG_SUCCESS_VALUE = "success";
    private static final String RESULT_TAG = "result";
    private static final String EXCEPTION_TAG = "exception";
    private final MeterRegistry registry;
    private final Function<ProceedingJoinPoint, Iterable<Tag>> tagsBasedOnJoinPoint;
    private final Predicate<ProceedingJoinPoint> shouldSkip;
    private CountedMeterTagAnnotationHandler meterTagAnnotationHandler;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ CountedAspect ajc$perSingletonInstance;

    public CountedAspect() {
        this(Metrics.globalRegistry);
    }

    public CountedAspect(MeterRegistry registry) {
        this(registry, DONT_SKIP_ANYTHING);
    }

    public CountedAspect(MeterRegistry registry, Function<ProceedingJoinPoint, Iterable<Tag>> tagsBasedOnJoinPoint) {
        this(registry, tagsBasedOnJoinPoint, DONT_SKIP_ANYTHING);
    }

    public CountedAspect(MeterRegistry registry, Predicate<ProceedingJoinPoint> shouldSkip) {
        this(registry, pjp -> Tags.of("class", pjp.getStaticPart().getSignature().getDeclaringTypeName(), "method", pjp.getStaticPart().getSignature().getName()), shouldSkip);
    }

    public CountedAspect(MeterRegistry registry, Function<ProceedingJoinPoint, Iterable<Tag>> tagsBasedOnJoinPoint, Predicate<ProceedingJoinPoint> shouldSkip) {
        this.registry = registry;
        this.tagsBasedOnJoinPoint = this.makeSafe(tagsBasedOnJoinPoint);
        this.shouldSkip = shouldSkip;
    }

    private Function<ProceedingJoinPoint, Iterable<Tag>> makeSafe(Function<ProceedingJoinPoint, Iterable<Tag>> function) {
        return pjp -> {
            try {
                return (Iterable)function.apply((ProceedingJoinPoint)pjp);
            }
            catch (Throwable t) {
                WARN_THEN_DEBUG_LOGGER.log("Exception thrown from the tagsBasedOnJoinPoint function configured on CountedAspect.", t);
                return Tags.empty();
            }
        };
    }

    @Around(value="@within(io.micrometer.core.annotation.Counted) && !@annotation(io.micrometer.core.annotation.Counted) && execution(* *(..))")
    @Nullable
    public Object countedClass(ProceedingJoinPoint pjp) throws Throwable {
        if (this.shouldSkip.test(pjp)) {
            return pjp.proceed();
        }
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        Class<?> declaringClass = method.getDeclaringClass();
        if (!declaringClass.isAnnotationPresent(Counted.class)) {
            declaringClass = pjp.getTarget().getClass();
        }
        Counted counted = declaringClass.getAnnotation(Counted.class);
        return this.perform(pjp, counted);
    }

    @Around(value="@annotation(counted) && execution(* *(..))", argNames="pjp,counted")
    @Nullable
    public Object interceptAndRecord(ProceedingJoinPoint pjp, Counted counted) throws Throwable {
        if (this.shouldSkip.test(pjp)) {
            return pjp.proceed();
        }
        return this.perform(pjp, counted);
    }

    @Nullable
    private Object perform(ProceedingJoinPoint pjp, Counted counted) throws Throwable {
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        boolean stopWhenCompleted = CompletionStage.class.isAssignableFrom(method.getReturnType());
        if (stopWhenCompleted) {
            try {
                Object result = pjp.proceed();
                if (result == null) {
                    if (!counted.recordFailuresOnly()) {
                        this.record(pjp, result, counted, "none", "success");
                    }
                    return result;
                }
                CompletionStage stage = (CompletionStage)result;
                return stage.whenComplete((res, throwable) -> this.recordCompletionResult(pjp, result, counted, (Throwable)throwable));
            }
            catch (Throwable e2) {
                this.record(pjp, null, counted, e2.getClass().getSimpleName(), "failure");
                throw e2;
            }
        }
        try {
            Object result = pjp.proceed();
            if (!counted.recordFailuresOnly()) {
                this.record(pjp, result, counted, "none", "success");
            }
            return result;
        }
        catch (Throwable e3) {
            this.record(pjp, null, counted, e3.getClass().getSimpleName(), "failure");
            throw e3;
        }
    }

    private void recordCompletionResult(ProceedingJoinPoint pjp, @Nullable Object methodResult, Counted counted, Throwable throwable) {
        if (throwable != null) {
            String exceptionTagValue = throwable.getCause() == null ? throwable.getClass().getSimpleName() : throwable.getCause().getClass().getSimpleName();
            this.record(pjp, methodResult, counted, exceptionTagValue, "failure");
        } else if (!counted.recordFailuresOnly()) {
            this.record(pjp, methodResult, counted, "none", "success");
        }
    }

    private void record(ProceedingJoinPoint pjp, @Nullable Object methodResult, Counted counted, String exception, String result) {
        try {
            Counter.Builder builder = Counter.builder(counted.value()).description(counted.description().isEmpty() ? null : counted.description()).tags(counted.extraTags()).tag(EXCEPTION_TAG, exception).tag(RESULT_TAG, result).tags(this.tagsBasedOnJoinPoint.apply(pjp));
            if (this.meterTagAnnotationHandler != null) {
                this.meterTagAnnotationHandler.addAnnotatedParameters(builder, pjp);
                this.meterTagAnnotationHandler.addAnnotatedMethodResult(builder, pjp, methodResult);
            }
            builder.register(this.registry).increment();
        }
        catch (Throwable ex) {
            WARN_THEN_DEBUG_LOGGER.log("Failed to record.", ex);
        }
    }

    public void setMeterTagAnnotationHandler(CountedMeterTagAnnotationHandler meterTagAnnotationHandler) {
        this.meterTagAnnotationHandler = meterTagAnnotationHandler;
    }

    static {
        try {
            CountedAspect.ajc$perSingletonInstance = new CountedAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static CountedAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("io.micrometer.core.aop.CountedAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

