/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld;

import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.api.CompactionApi;
import com.apicatalog.jsonld.api.ExpansionApi;
import com.apicatalog.jsonld.api.FlatteningApi;
import com.apicatalog.jsonld.api.FramingApi;
import com.apicatalog.jsonld.api.FromRdfApi;
import com.apicatalog.jsonld.api.ToRdfApi;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.serialization.QuadsToJsonld;
import com.apicatalog.jsonld.uri.UriUtils;
import java.net.URI;

public final class JsonLd {
    private static final String DOCUMENT_LOCATION_PARAM_NAME = "documentLocation";
    private static final String DOCUMENT_URI_PARAM_NAME = "documentUri";
    private static final String DOCUMENT_PARAM_NAME = "document";
    private static final String CONTEXT_PARAM_NAME = "context";
    private static final String CONTEXT_LOCATION_PARAM_NAME = "contextLocation";
    private static final String CONTEXT_URI_PARAM_NAME = "contextUri";
    private static final String FRAME_LOCATION_PARAM_NAME = "frameLocation";
    private static final String FRAME_URI_PARAM_NAME = "frameUri";
    private static final String FRAME_PARAM_NAME = "frame";

    private JsonLd() {
    }

    public static final ExpansionApi expand(String documentLocation) {
        return new ExpansionApi(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME));
    }

    public static final ExpansionApi expand(URI documentUri) {
        return new ExpansionApi(JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME));
    }

    public static final ExpansionApi expand(Document document) {
        return new ExpansionApi(JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME));
    }

    public static final CompactionApi compact(String documentLocation, String contextLocation) {
        return JsonLd.compact(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME), JsonLd.assertLocation(contextLocation, CONTEXT_LOCATION_PARAM_NAME));
    }

    public static final CompactionApi compact(URI documentUri, URI contextUri) {
        return new CompactionApi(JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME), JsonLd.assertUri(contextUri, CONTEXT_URI_PARAM_NAME));
    }

    public static final CompactionApi compact(String documentLocation, Document context2) {
        return new CompactionApi(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME), JsonLd.assertJsonDocument(context2, CONTEXT_PARAM_NAME));
    }

    public static final CompactionApi compact(URI documentUri, Document context2) {
        return new CompactionApi(JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME), JsonLd.assertJsonDocument(context2, CONTEXT_PARAM_NAME));
    }

    public static final CompactionApi compact(Document document, Document context2) {
        return new CompactionApi(JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME), JsonLd.assertJsonDocument(context2, CONTEXT_PARAM_NAME));
    }

    public static final CompactionApi compact(Document document, String contextLocation) {
        return JsonLd.compact(JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME), JsonLd.assertLocation(contextLocation, CONTEXT_LOCATION_PARAM_NAME));
    }

    public static final CompactionApi compact(Document document, URI contextUri) {
        return new CompactionApi(JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME), JsonLd.assertUri(contextUri, CONTEXT_URI_PARAM_NAME));
    }

    public static final CompactionApi compact(String documentLocation, URI contextUri) {
        return new CompactionApi(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME), JsonLd.assertUri(contextUri, CONTEXT_URI_PARAM_NAME));
    }

    public static final CompactionApi compact(URI documentUri, String contextLocation) {
        return new CompactionApi(JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME), JsonLd.assertLocation(contextLocation, CONTEXT_LOCATION_PARAM_NAME));
    }

    public static final FlatteningApi flatten(String documentLocation) {
        return new FlatteningApi(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME));
    }

    public static final FlatteningApi flatten(URI documentUri) {
        return new FlatteningApi(JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME));
    }

    public static final FlatteningApi flatten(Document document) {
        return new FlatteningApi(JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME));
    }

    public static final FramingApi frame(URI documentUri, URI frameUri) {
        return new FramingApi(JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME), JsonLd.assertUri(frameUri, FRAME_URI_PARAM_NAME));
    }

    public static final FramingApi frame(String documentLocation, String frameLocation) {
        return new FramingApi(JsonLd.assertLocation(documentLocation, DOCUMENT_URI_PARAM_NAME), JsonLd.assertLocation(frameLocation, FRAME_LOCATION_PARAM_NAME));
    }

    public static final FramingApi frame(Document document, Document frame) {
        return new FramingApi(JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME), JsonLd.assertJsonDocument(frame, FRAME_PARAM_NAME));
    }

    public static final FramingApi frame(Document document, String frameLocation) {
        return new FramingApi(JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME), JsonLd.assertLocation(frameLocation, FRAME_LOCATION_PARAM_NAME));
    }

    public static final FramingApi frame(Document document, URI frameUri) {
        return new FramingApi(JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME), JsonLd.assertUri(frameUri, FRAME_URI_PARAM_NAME));
    }

    public static final FramingApi frame(String documentLocation, Document frame) {
        return new FramingApi(JsonLd.assertLocation(documentLocation, DOCUMENT_URI_PARAM_NAME), JsonLd.assertJsonDocument(frame, FRAME_PARAM_NAME));
    }

    public static final FramingApi frame(String documentLocation, URI frameUri) {
        return new FramingApi(JsonLd.assertLocation(documentLocation, DOCUMENT_URI_PARAM_NAME), JsonLd.assertUri(frameUri, FRAME_URI_PARAM_NAME));
    }

    public static final FramingApi frame(URI documentUri, Document frame) {
        return new FramingApi(JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME), JsonLd.assertJsonDocument(frame, FRAME_PARAM_NAME));
    }

    public static final FramingApi frame(URI documentUri, String frameLocation) {
        return new FramingApi(JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME), JsonLd.assertLocation(frameLocation, FRAME_LOCATION_PARAM_NAME));
    }

    public static final ToRdfApi toRdf(String documentLocation) {
        return new ToRdfApi(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME));
    }

    public static final ToRdfApi toRdf(URI documentUri) {
        return new ToRdfApi(JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME));
    }

    public static final ToRdfApi toRdf(Document document) {
        return new ToRdfApi(JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME));
    }

    public static final FromRdfApi fromRdf(String documentLocation) {
        return new FromRdfApi(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME));
    }

    public static final FromRdfApi fromRdf(URI documentUri) {
        return new FromRdfApi(JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME));
    }

    @Deprecated
    public static final FromRdfApi fromRdf(Document document) {
        return new FromRdfApi(JsonLd.assertRdfDocument(document, DOCUMENT_PARAM_NAME));
    }

    public static final QuadsToJsonld fromRdf() {
        return new QuadsToJsonld();
    }

    private static final URI assertLocation(String location, String param) {
        JsonLd.assertNotNull(location, param);
        if (StringUtils.isBlank(location)) {
            throw new IllegalArgumentException("'" + param + "' is blank string.");
        }
        URI uri = UriUtils.create(StringUtils.strip(location));
        if (uri == null || !uri.isAbsolute()) {
            throw new IllegalArgumentException("'" + param + "' is not an absolute URI [" + location + "].");
        }
        return uri;
    }

    private static final URI assertUri(URI uri, String param) {
        JsonLd.assertNotNull(uri, param);
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("'" + param + "' is not an absolute URI [" + String.valueOf(uri) + "].");
        }
        return uri;
    }

    private static final Document assertJsonDocument(Document document, String param) {
        JsonLd.assertNotNull(document, param);
        if (!document.getJsonContent().isPresent()) {
            throw new IllegalArgumentException("'" + param + "' is not not JSON document but [" + String.valueOf(document.getContentType()) + "].");
        }
        return document;
    }

    @Deprecated
    private static final Document assertRdfDocument(Document document, String param) {
        JsonLd.assertNotNull(document, param);
        if (!document.getRdfContent().isPresent()) {
            throw new IllegalArgumentException("'" + param + "' is not not RDF document but [" + String.valueOf(document.getContentType()) + "].");
        }
        return document;
    }

    private static final void assertNotNull(Object value, String param) {
        if (value == null) {
            throw new IllegalArgumentException("'" + param + "' is null.");
        }
    }
}

