/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.GeographicToTopocentric;
import org.apache.sis.referencing.operation.transform.EllipsoidToCentricTransform;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class GeocentricToTopocentric
extends AbstractProvider {
    private static final long serialVersionUID = 6064563343153407987L;
    private static final ParameterDescriptor<Double> ORIGIN_X;
    private static final ParameterDescriptor<Double> ORIGIN_Y;
    private static final ParameterDescriptor<Double> ORIGIN_Z;
    private static final ParameterDescriptorGroup PARAMETERS;

    public GeocentricToTopocentric() {
        super(Conversion.class, PARAMETERS, CartesianCS.class, true, CartesianCS.class, false);
    }

    @Override
    @Deprecated
    public Integer getSourceDimensions() {
        return 3;
    }

    @Override
    @Deprecated
    public Integer getTargetDimensions() {
        return 3;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        try {
            return GeocentricToTopocentric.create(factory, Parameters.castOrWrap(values), false);
        }
        catch (TransformException e2) {
            throw new FactoryException(e2);
        }
    }

    static MathTransform create(MathTransformFactory factory, Parameters values, boolean geographic) throws FactoryException, TransformException {
        double z;
        double y;
        double x;
        double \u03c6;
        double \u03bb;
        double[] origin;
        MathTransform toGeocentric;
        ParameterValue<?> ap = values.parameter("semi_major");
        Unit<Length> unit = ap.getUnit().asType(Length.class);
        double a = ap.doubleValue();
        double b = values.parameter("semi_minor").doubleValue(unit);
        if (geographic) {
            toGeocentric = EllipsoidToCentricTransform.createGeodeticConversion(factory, a, b, unit, true, EllipsoidToCentricTransform.TargetType.CARTESIAN);
            origin = new double[]{values.doubleValue(GeographicToTopocentric.ORIGIN_X), values.doubleValue(GeographicToTopocentric.ORIGIN_Y), values.doubleValue(GeographicToTopocentric.ORIGIN_Z)};
            \u03bb = Math.toRadians(origin[0]);
            \u03c6 = Math.toRadians(origin[1]);
            toGeocentric.transform(origin, 0, origin, 0, 1);
            x = origin[0];
            y = origin[1];
            z = origin[2];
        } else {
            toGeocentric = new EllipsoidToCentricTransform(a, b, unit, false, EllipsoidToCentricTransform.TargetType.CARTESIAN);
            double[] dArray = new double[3];
            x = values.doubleValue(ORIGIN_X, unit);
            dArray[0] = x / a;
            y = values.doubleValue(ORIGIN_Y, unit);
            dArray[1] = y / a;
            z = values.doubleValue(ORIGIN_Z, unit);
            dArray[2] = z / a;
            origin = dArray;
            toGeocentric.inverse().transform(origin, 0, origin, 0, 1);
            \u03bb = origin[0];
            \u03c6 = origin[1];
        }
        double sin\u03bb = Math.sin(\u03bb);
        double cos\u03bb = Math.cos(\u03bb);
        double sin\u03c6 = Math.sin(\u03c6);
        double cos\u03c6 = Math.cos(\u03c6);
        MathTransform mt = factory.createAffineTransform(new Matrix4(-sin\u03bb, -sin\u03c6 * cos\u03bb, cos\u03c6 * cos\u03bb, x, cos\u03bb, -sin\u03c6 * sin\u03bb, cos\u03c6 * sin\u03bb, y, 0.0, cos\u03c6, sin\u03c6, z, 0.0, 0.0, 0.0, 1.0)).inverse();
        if (geographic) {
            mt = factory.createConcatenatedTransform(toGeocentric, mt);
        }
        return mt;
    }

    static {
        ParameterBuilder builder = GeocentricToTopocentric.builder();
        ORIGIN_X = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8837")).addName("Geocentric X of topocentric origin")).create(Double.NaN, Units.METRE);
        ORIGIN_Y = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8838")).addName("Geocentric Y of topocentric origin")).create(Double.NaN, Units.METRE);
        ORIGIN_Z = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8839")).addName("Geocentric Z of topocentric origin")).create(Double.NaN, Units.METRE);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9836")).addName("Geocentric/topocentric conversions")).createGroupForMapProjection(ORIGIN_X, ORIGIN_Y, ORIGIN_Z);
    }
}

