/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.http.HttpLib;
import org.apache.jena.http.auth.AuthChallenge;
import org.apache.jena.http.auth.AuthEnv;
import org.apache.jena.http.auth.AuthException;
import org.apache.jena.http.auth.AuthRequestModifier;
import org.apache.jena.http.auth.DigestLib;
import org.apache.jena.http.auth.PasswordRecord;

public class AuthLib {
    public static <T> HttpResponse<T> authExecute(HttpClient httpClient, HttpRequest httpRequest, HttpResponse.BodyHandler<T> bodyHandler) {
        HttpResponse<T> httpResponse = HttpLib.executeJDK(httpClient, httpRequest, bodyHandler);
        if (httpResponse.statusCode() != 401) {
            return httpResponse;
        }
        HttpResponse<T> httpResponse2 = AuthLib.handle401(httpClient, httpRequest, bodyHandler, httpResponse);
        return httpResponse2;
    }

    private static <T> HttpResponse<T> handle401(HttpClient httpClient, HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler, HttpResponse<T> httpResponse401) {
        AuthRequestModifier authRequestModifier;
        AuthChallenge aHeader = AuthLib.wwwAuthenticateHeader(httpResponse401);
        if (aHeader == null) {
            return httpResponse401;
        }
        PasswordRecord passwordRecord = null;
        if ((aHeader.authScheme == AuthScheme.BASIC || aHeader.authScheme == AuthScheme.DIGEST) && (passwordRecord = AuthEnv.get().getUsernamePassword(request.uri())) == null) {
            throw new HttpException(401);
        }
        switch (aHeader.authScheme) {
            case BASIC: {
                authRequestModifier = AuthLib.basicAuthModifier(passwordRecord.getUsername(), passwordRecord.getPassword());
                break;
            }
            case DIGEST: {
                String requestTarget = HttpLib.requestTargetServer(request.uri());
                authRequestModifier = DigestLib.digestAuthModifier(aHeader, passwordRecord.getUsername(), passwordRecord.getPassword(), request.method(), requestTarget);
                break;
            }
            case BEARER: {
                String requestTarget = HttpLib.endpoint(request.uri().toString());
                authRequestModifier = AuthLib.bearerAuthModifier(requestTarget, aHeader);
                break;
            }
            case UNKNOWN: {
                return httpResponse401;
            }
            default: {
                throw new HttpException("Not an authentication scheme -- " + String.valueOf((Object)aHeader.authScheme));
            }
        }
        if (authRequestModifier == null) {
            return httpResponse401;
        }
        AuthEnv.get().registerAuthModifier(request.uri().toString(), authRequestModifier);
        HttpRequest.Builder request2builder = HttpLib.createBuilder(request);
        request2builder = authRequestModifier.addAuth(request2builder);
        HttpRequest httpRequest2 = request2builder.build();
        HttpResponse<T> httpResponse2 = HttpLib.executeJDK(httpClient, httpRequest2, bodyHandler);
        return httpResponse2;
    }

    private static AuthChallenge wwwAuthenticateHeader(HttpResponse<?> httpResponse) {
        List<String> headers = httpResponse.headers().allValues("WWW-Authenticate");
        if (headers.size() == 0) {
            return null;
        }
        AuthChallenge aHeader = null;
        Object result = null;
        block6: for (String headerValue : headers) {
            AuthChallenge aHeader2 = AuthChallenge.parse(headerValue);
            if (aHeader2 == null) {
                AuthEnv.LOG.warn("Bad authentication response - ignored: " + headerValue);
                return null;
            }
            AuthScheme authScheme = aHeader2.authScheme;
            switch (authScheme) {
                case DIGEST: {
                    return aHeader2;
                }
                case BASIC: {
                    if (aHeader != null) continue block6;
                    aHeader = aHeader2;
                    continue block6;
                }
                case BEARER: {
                    return aHeader2;
                }
                case UNKNOWN: {
                    AuthEnv.LOG.warn("Authentication required: " + String.valueOf((Object)authScheme));
                    continue block6;
                }
            }
            AuthEnv.LOG.warn("Unrecogized authentication response - ignored: " + headerValue);
        }
        return aHeader;
    }

    static AuthRequestModifier basicAuthModifier(String user, String password) {
        return req -> req.setHeader("Authorization", HttpLib.basicAuth(user, password));
    }

    private static AuthRequestModifier bearerAuthModifier(String remoteService, AuthChallenge aHeader) {
        String token = AuthEnv.get().getBearerToken(remoteService, aHeader);
        if (token == null) {
            return null;
        }
        if (token.contains(" ")) {
            throw new AuthException("Bad token - contains spaces");
        }
        return builder -> builder.setHeader("Authorization", "Bearer " + token);
    }

    public static Authenticator authenticator(final String user, final String password) {
        return new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, password.toCharArray());
            }
        };
    }

    public static PasswordAuthentication getPasswordAuthentication(Authenticator authenticator) {
        return authenticator.requestPasswordAuthenticationInstance(null, null, -1, null, null, null, null, null);
    }

    public static String base64enc(String x) {
        byte[] bytes = x.getBytes(StandardCharsets.UTF_8);
        String s = Base64.getEncoder().encodeToString(bytes);
        return s;
    }

    public static String base64dec(String x) {
        try {
            byte[] bytes = Base64.getDecoder().decode(x);
            return Bytes.bytes2string(bytes);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

