/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.index.v2;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.geosparql.configuration.GeoSPARQLOperations;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.implementation.registry.SRSRegistry;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexConstants;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.index.v2.STRtreePerGraph;
import org.apache.jena.geosparql.spatial.index.v2.STRtreeUtils;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexIoKryo;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexPerGraph;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexerComputation;
import org.apache.jena.geosparql.spatial.task.BasicTask;
import org.apache.jena.geosparql.spatial.task.TaskThread;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.NamedGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.system.AutoTxn;
import org.apache.jena.system.Txn;
import org.locationtech.jts.index.strtree.STRtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexLib {
    private static final Logger logger = LoggerFactory.getLogger(SpatialIndexLib.class);

    public static final String getPreferredSRS(Context context2) {
        return context2 == null ? null : context2.getAsString(SpatialIndexConstants.symSrsUri);
    }

    public static final void setPreferredSRS(Context context2, String srsUri) {
        context2.set(SpatialIndexConstants.symSrsUri, srsUri);
    }

    public static final void setSpatialIndex(Dataset dataset, SpatialIndex spatialIndex) {
        Context cxt = dataset.getContext();
        SpatialIndexLib.setSpatialIndex(cxt, spatialIndex);
    }

    public static final void setSpatialIndex(DatasetGraph datasetGraph, SpatialIndex spatialIndex) {
        Context cxt = datasetGraph.getContext();
        SpatialIndexLib.setSpatialIndex(cxt, spatialIndex);
    }

    public static final void setSpatialIndex(Context context2, SpatialIndex spatialIndex) {
        context2.set(SpatialIndexConstants.symSpatialIndex, spatialIndex);
    }

    public static final <T extends SpatialIndex> T getSpatialIndex(Context cxt) {
        return (T)(cxt == null ? null : (SpatialIndex)cxt.get(SpatialIndexConstants.symSpatialIndex));
    }

    public static final <T extends SpatialIndex> T getSpatialIndex(DatasetGraph dsg) {
        return SpatialIndexLib.getSpatialIndex(dsg.getContext());
    }

    public static final boolean isDefined(ExecutionContext execCxt) {
        Context context2 = execCxt.getContext();
        return context2.isDefined(SpatialIndexConstants.symSpatialIndex);
    }

    public static final SpatialIndex retrieve(ExecutionContext execCxt) throws SpatialIndexException {
        Context context2 = execCxt.getContext();
        SpatialIndex spatialIndex = context2.get(SpatialIndexConstants.symSpatialIndex, null);
        if (spatialIndex == null) {
            throw new SpatialIndexException("Dataset Context does not contain SpatialIndex.");
        }
        return spatialIndex;
    }

    public static final Dataset wrapModel(Model model, String srsURI) throws SpatialIndexException {
        Dataset dataset = DatasetFactory.createTxnMem();
        dataset.setDefaultModel(model);
        SpatialIndexLib.buildSpatialIndex(dataset.asDatasetGraph(), srsURI);
        return dataset;
    }

    public static final Dataset wrapModel(Model model) throws SpatialIndexException {
        Dataset dataset = DatasetFactory.createTxnMem();
        dataset.setDefaultModel(model);
        String srsURI = GeoSPARQLOperations.findModeSRS(dataset);
        SpatialIndexLib.buildSpatialIndex(dataset.asDatasetGraph(), srsURI);
        return dataset;
    }

    public static SpatialIndex buildSpatialIndex(DatasetGraph datasetGraph) throws SpatialIndexException {
        SpatialIndexPerGraph spatialIndex = SpatialIndexLib.buildSpatialIndex(datasetGraph, null);
        return spatialIndex;
    }

    public static SpatialIndexPerGraph buildSpatialIndex(DatasetGraph datasetGraph, String srsURI) throws SpatialIndexException {
        return SpatialIndexLib.buildSpatialIndexPerGraph(datasetGraph, srsURI);
    }

    public static SpatialIndexPerGraph buildSpatialIndexPerGraph(DatasetGraph datasetGraph, String srsURI) throws SpatialIndexException {
        STRtreePerGraph treePerGraph;
        Objects.requireNonNull(datasetGraph);
        if (srsURI == null) {
            Dataset dataset = DatasetFactory.wrap(datasetGraph);
            srsURI = GeoSPARQLOperations.findModeSRS(dataset);
        }
        logger.info("Building Spatial Index - Started");
        try (AutoTxn txn = Txn.autoTxn((Transactional)datasetGraph, TxnType.READ);){
            treePerGraph = STRtreeUtils.buildSpatialIndexTree(datasetGraph, srsURI);
            txn.commit();
        }
        logger.info("Building Spatial Index - Completed");
        SRSInfo srsInfo = SRSRegistry.getSRSInfo(srsURI);
        SpatialIndexPerGraph index = new SpatialIndexPerGraph(srsInfo, treePerGraph, null);
        SpatialIndexLib.setSpatialIndex(datasetGraph, (SpatialIndex)index);
        return index;
    }

    public static Node unwrapGraphName(Graph graph) {
        Node node;
        if (graph instanceof NamedGraph) {
            NamedGraph namedGraph = (NamedGraph)graph;
            node = namedGraph.getGraphName();
        } else {
            node = null;
        }
        Node graphNode = node;
        return graphNode;
    }

    public static BasicTask scheduleOnceIndexTask(DatasetGraph dsg, SpatialIndexerComputation indexComputation, Path targetFile, boolean isReplaceTask, BasicTask.TaskListener<BasicTask> taskListener) {
        Context cxt = dsg.getContext();
        BasicTask task = cxt.compute(SpatialIndexConstants.symSpatialIndexTask, (key, priorTaskObj) -> {
            BasicTask priorTask = (BasicTask)priorTaskObj;
            if (priorTask != null && !priorTask.isTerminated()) {
                throw new RuntimeException("A spatial indexing task is already active for this dataset. Wait for completion or abort it.");
            }
            TaskThread thread = SpatialIndexLib.createIndexerTask(dsg, null, indexComputation, taskListener, targetFile, isReplaceTask);
            thread.start();
            return thread;
        });
        return task;
    }

    public static TaskThread createIndexerTask(DatasetGraph dsg, final Predicate<Node> isAuthorizedGraph, final SpatialIndexerComputation indexComputation, BasicTask.TaskListener<BasicTask> taskListener, final Path targetFile, final boolean isReplaceTask) {
        final Context cxt = dsg.getContext();
        final long graphCount = indexComputation.getGraphNodes().size();
        final boolean isEffectiveUpdate = !isReplaceTask || isAuthorizedGraph != null;
        TaskThread thread = new TaskThread("Spatial Indexer Task", taskListener){

            @Override
            public void runActual() throws Exception {
                SpatialIndexPerGraph oldIndex;
                if (logger.isInfoEnabled()) {
                    String replaceMsg = isReplaceTask ? "The resulting index will REPLACE a prior index." : "A prior index will be UPDATED with the newly indexed graphs.";
                    logger.info("Indexing of {} graphs started. " + replaceMsg, (Object)graphCount);
                }
                SpatialIndexPerGraph rawOldIndex = (SpatialIndexPerGraph)SpatialIndexLib.getSpatialIndex(cxt);
                if (isEffectiveUpdate) {
                    String priorSrs = Optional.ofNullable(rawOldIndex).map(SpatialIndex::getSrsInfo).map(SRSInfo::getSrsURI).orElse(null);
                    String requestedSrs = indexComputation.getSrsURI();
                    if (priorSrs != null && !priorSrs.equals(requestedSrs)) {
                        throw new IllegalArgumentException("The SRS of the update request is inconistent with the SRS of the index: index SRS: " + priorSrs + ", requested SRS: " + requestedSrs);
                    }
                }
                SpatialIndexPerGraph newIndex = indexComputation.call();
                if (isEffectiveUpdate && (oldIndex = rawOldIndex) != null) {
                    Map<Node, STRtree> oldTreeMap = oldIndex.getIndex().getTreeMap();
                    oldTreeMap.forEach((name, tree) -> {
                        boolean isGraphNotSelectedForUpdate = !newIndex.getIndex().contains((Node)name);
                        boolean addGraph = false;
                        if (isReplaceTask) {
                            boolean isNonAuthorizedGraph;
                            boolean bl = isNonAuthorizedGraph = isAuthorizedGraph != null && !isAuthorizedGraph.test(name);
                            if (isNonAuthorizedGraph) {
                                addGraph = true;
                            }
                        } else {
                            addGraph = isGraphNotSelectedForUpdate;
                        }
                        if (addGraph) {
                            newIndex.getIndex().setTree((Node)name, (STRtree)tree);
                        }
                    });
                }
                SpatialIndexLib.setSpatialIndex(cxt, (SpatialIndex)newIndex);
                if (targetFile != null) {
                    newIndex.setLocation(targetFile);
                    logger.info("Writing spatial index of {} graphs to disk at path {}", (Object)graphCount, (Object)targetFile.toAbsolutePath());
                    SpatialIndexIoKryo.save(targetFile, newIndex);
                }
                String statusMsg = String.format("Updated spatial index with %d graphs.", graphCount);
                this.setStatusMessage(statusMsg);
                if (logger.isInfoEnabled()) {
                    logger.info("Indexing of {} graphs completed successfully.", (Object)graphCount);
                }
            }

            @Override
            public void requestCancel() {
                indexComputation.abort();
                super.requestCancel();
            }
        };
        return thread;
    }

    public static BasicTask scheduleOnceCleanTask(DatasetGraph dsg, BasicTask.TaskListener<BasicTask> taskListener) {
        Context cxt = dsg.getContext();
        BasicTask task = cxt.compute(SpatialIndexConstants.symSpatialIndexTask, (key, priorTaskObj) -> {
            BasicTask priorTask = (BasicTask)priorTaskObj;
            if (priorTask != null && !priorTask.isTerminated()) {
                throw new RuntimeException("A spatial indexing task is already active for this dataset. Wait for completion or abort it.");
            }
            TaskThread thread = SpatialIndexLib.createCleanTask(dsg, null, taskListener);
            thread.start();
            return thread;
        });
        return task;
    }

    public static TaskThread createCleanTask(final DatasetGraph dsg, final Predicate<Node> isAuthorizedGraph, BasicTask.TaskListener<BasicTask> taskListener) {
        final Context cxt = dsg.getContext();
        TaskThread thread = new TaskThread("Clean action", taskListener){

            @Override
            public void runActual() throws Exception {
                int finalGraphCount;
                int cleanCount;
                Object spatialIndexRaw = SpatialIndexLib.getSpatialIndex(cxt);
                if (spatialIndexRaw == null) {
                    throw new SpatialIndexException("No spatial index available on current dataset.");
                }
                if (spatialIndexRaw instanceof SpatialIndexPerGraph) {
                    SpatialIndexPerGraph spatialIndex = (SpatialIndexPerGraph)spatialIndexRaw;
                    Set physicalGraphs = Txn.calculateRead(dsg, () -> SpatialIndexLib.accGraphNodes(new LinkedHashSet(), dsg));
                    STRtreePerGraph perGraphIndex = spatialIndex.getIndex();
                    Map<Node, STRtree> treeMap = perGraphIndex.getTreeMap();
                    Set visibleGraphNodes = Txn.calculateRead(dsg, () -> SpatialIndexLib.accGraphNodes(new LinkedHashSet(), dsg));
                    if (physicalGraphs == null) {
                        physicalGraphs = visibleGraphNodes;
                        visibleGraphNodes = null;
                    }
                    ArrayList<Node> indexGraphNodes = new ArrayList<Node>(treeMap.keySet());
                    cleanCount = 0;
                    for (Node node : indexGraphNodes) {
                        if (node == null || Quad.isDefaultGraph(node) || physicalGraphs.contains(node) || isAuthorizedGraph != null && !isAuthorizedGraph.test(node)) continue;
                        perGraphIndex.removeTree(node);
                        ++cleanCount;
                    }
                    finalGraphCount = treeMap.keySet().size();
                    Path targetFile = spatialIndex.getLocation();
                    if (cleanCount > 0 && targetFile != null) {
                        logger.info("Writing spatial index of {} graphs (cleaned: {}) to disk at path {}", finalGraphCount, cleanCount, targetFile.toAbsolutePath());
                        SpatialIndexIoKryo.save(targetFile, spatialIndex);
                    }
                } else {
                    throw new SpatialIndexException("Unsupported spatial index type for cleaning.");
                }
                String statusMsg = String.format("Updated spatial index of %d graphs (cleaned: %d)", finalGraphCount, cleanCount);
                this.setStatusMessage(statusMsg);
                logger.info("Indexing of {} graphs completed successfully.", (Object)finalGraphCount);
            }
        };
        return thread;
    }

    public static <C extends Collection<Node>> C accGraphNodes(C accGraphs, DatasetGraph dsg) {
        try (Stream<Node> s = Iter.asStream(dsg.listGraphNodes());){
            s.forEach(accGraphs::add);
        }
        return accGraphs;
    }
}

