/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.geosparql.implementation.vocabulary.SpatialExtension;
import org.apache.jena.geosparql.spatial.ConvertLatLon;
import org.apache.jena.geosparql.spatial.SpatialIndexItem;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexFindUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static IteratorCloseable<SpatialIndexItem> findSpatialIndexItems(DatasetGraph datasetGraph, String srsURI) {
        Graph defaultGraph = datasetGraph.getDefaultGraph();
        IteratorCloseable<SpatialIndexItem> itemsIter = SpatialIndexFindUtils.findSpatialIndexItems(defaultGraph, srsURI);
        try {
            Iterator<Node> graphNodeIt = datasetGraph.listGraphNodes();
            Iter namedGraphItemsIt = Iter.iter(graphNodeIt).flatMap(graphNode -> {
                Graph namedGraph = datasetGraph.getGraph((Node)graphNode);
                IteratorCloseable<SpatialIndexItem> graphItems = SpatialIndexFindUtils.findSpatialIndexItems(namedGraph, srsURI);
                return graphItems;
            });
            itemsIter = Iter.iter(itemsIter).append(namedGraphItemsIt);
        }
        catch (Throwable t) {
            t.addSuppressed(new RuntimeException("Failure during findSpatialIndexItems.", t));
            Iter.close(itemsIter);
            throw t;
        }
        return itemsIter;
    }

    public static final IteratorCloseable<SpatialIndexItem> findSpatialIndexItems(Graph graph, String srsURI) {
        IteratorCloseable<SpatialIndexItem> result = graph.contains(null, Geo.HAS_GEOMETRY_NODE, null) ? SpatialIndexFindUtils.findGeometryIndexItems(graph, srsURI) : (graph.contains(null, SpatialExtension.GEO_LAT_NODE, null) ? SpatialIndexFindUtils.findGeoPredicateIndexItems(graph, srsURI) : Iter.empty());
        return result;
    }

    public static final void checkSpatialIndexItems(Graph graph) {
        if (graph.contains(null, Geo.HAS_GEOMETRY_NODE, null)) {
            LOGGER.info("Feature-hasGeometry-Geometry statements found.");
            if (graph.contains(null, SpatialExtension.GEO_LAT_NODE, null)) {
                LOGGER.warn("Lat/Lon Geo predicates also found but will not be added to index.");
            }
        } else if (graph.contains(null, SpatialExtension.GEO_LAT_NODE, null)) {
            LOGGER.info("Geo predicate statements found.");
        }
    }

    public static IteratorCloseable<SpatialIndexItem> findGeometryIndexItems(Graph graph, String srsURI) {
        ExtendedIterator<Triple> stmtIter = graph.find(null, Geo.HAS_GEOMETRY_NODE, null);
        Iter<SpatialIndexItem> result = Iter.iter(stmtIter).flatMap(stmt -> {
            Node feature = stmt.getSubject();
            Node geometry = stmt.getObject();
            Iterator<Node> nodeIter = G.iterSP(graph, geometry, Geo.HAS_SERIALIZATION_NODE);
            try {
                if (!nodeIter.hasNext()) {
                    ExtendedIterator<Node> wktNodeIter;
                    Iter.close(nodeIter);
                    nodeIter = wktNodeIter = G.iterSP(graph, geometry, Geo.AS_WKT_NODE);
                    ExtendedIterator<Node> gmlNodeIter = G.iterSP(graph, geometry, Geo.AS_GML_NODE);
                    nodeIter = Iter.append(wktNodeIter, gmlNodeIter);
                }
            }
            catch (Throwable t) {
                t.addSuppressed(new RuntimeException("Error encountered.", t));
                Iter.close(nodeIter);
                throw t;
            }
            Iterator<SpatialIndexItem> itemIter = Iter.map(nodeIter, geometryNode -> {
                GeometryWrapper geometryWrapper = GeometryWrapper.extract(geometryNode);
                SpatialIndexItem item = SpatialIndexFindUtils.makeSpatialIndexItem(feature, geometryWrapper, srsURI);
                return item;
            });
            return itemIter;
        });
        return result;
    }

    public static IteratorCloseable<SpatialIndexItem> findGeoPredicateIndexItems(Graph graph, String srsURI) {
        boolean enableWarnings = false;
        boolean[] loggedMultipleLatLons = new boolean[]{false};
        ExtendedIterator<Triple> latIt = graph.find(Node.ANY, SpatialExtension.GEO_LAT_NODE, Node.ANY);
        Iter<SpatialIndexItem> result = Iter.iter(latIt).flatMap(triple -> {
            Node feature = triple.getSubject();
            Node lat = triple.getObject();
            ExtendedIterator<Node> lons = G.iterSP(graph, feature, SpatialExtension.GEO_LON_NODE);
            int[] lonCounter = new int[]{0};
            Iter<SpatialIndexItem> r = Iter.iter(lons).map(lon -> {
                if (enableWarnings) {
                    if (lonCounter[0] == 1 && !loggedMultipleLatLons[0]) {
                        LOGGER.warn("Geo predicates: multiple longitudes detected on feature " + String.valueOf(feature) + ". Further warnings will be omitted.");
                        loggedMultipleLatLons[0] = true;
                    }
                    lonCounter[0] = lonCounter[0] + 1;
                }
                GeometryWrapper geometryWrapper = ConvertLatLon.toGeometryWrapper(lat, lon);
                SpatialIndexItem item = SpatialIndexFindUtils.makeSpatialIndexItem(feature, geometryWrapper, srsURI);
                return item;
            });
            return r;
        });
        return result;
    }

    public static SpatialIndexItem makeSpatialIndexItem(Node feature, GeometryWrapper geometryWrapper, String srsURI) {
        GeometryWrapper transformedGeometryWrapper = SpatialIndexFindUtils.unsafeConvert(geometryWrapper, srsURI);
        Envelope envelope = transformedGeometryWrapper.getEnvelope();
        SpatialIndexItem item = new SpatialIndexItem(envelope, feature);
        return item;
    }

    public static GeometryWrapper unsafeConvert(GeometryWrapper geometryWrapper, String srsURI) {
        GeometryWrapper result;
        try {
            result = geometryWrapper.convertSRS(srsURI);
        }
        catch (MismatchedDimensionException | TransformException | FactoryException e2) {
            throw new RuntimeException(e2);
        }
        return result;
    }
}

